/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.AdaptableList;
import org.eclipse.hyades.log.ui.internal.wizards.LogWizardElementBase;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public abstract class WorkbenchWizardListSelectionPage
extends WizardSelectionPage
implements ISelectionChangedListener,
IDoubleClickListener {
    private String message;
    protected IWorkbench workbench;
    protected AdaptableList wizardElements;
    public TableViewer wizardSelectionViewer;
    protected IStructuredSelection currentResourceSelection;
    private static final String STORE_SELECTED_WIZARD_ID = "WizardListSelectionPage.STORE_SELECTED_WIZARD_ID";
    private static final int SIZING_LISTS_HEIGHT = 200;
    private static final int SIZING_LISTS_WIDTH = 150;

    protected WorkbenchWizardListSelectionPage(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection, AdaptableList adaptableList, String string) {
        super("singleWizardSelectionPage");
        this.setDescription(LogUIPlugin.getResourceString("WizardList.description"));
        this.wizardElements = adaptableList;
        this.currentResourceSelection = iStructuredSelection;
        this.workbench = iWorkbench;
        this.setTitle(LogUIPlugin.getResourceString("Select"));
        this.message = string;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        new Label(composite2, 0).setText(this.message);
        Table table = new Table(composite2, 2048);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 150;
        gridData.heightHint = 200;
        table.setLayoutData((Object)gridData);
        this.wizardSelectionViewer = new TableViewer(table);
        this.wizardSelectionViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.wizardSelectionViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.wizardSelectionViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        this.wizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.wizardSelectionViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.wizardSelectionViewer.setInput((Object)this.wizardElements);
        this.restoreWidgetValues();
        this.setControl((Control)composite2);
    }

    protected abstract IWizardNode createWizardNode(LogWizardElementBase var1);

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.wizardSelectionViewer, this.wizardSelectionViewer.getSelection()));
        this.getContainer().showPage(this.getNextPage());
    }

    private void restoreWidgetValues() {
        String string = this.getDialogSettings().get(STORE_SELECTED_WIZARD_ID);
        LogWizardElementBase logWizardElementBase = this.findWizard(string);
        if (logWizardElementBase == null) {
            return;
        }
        StructuredSelection structuredSelection = new StructuredSelection((Object)logWizardElementBase);
        this.wizardSelectionViewer.setSelection((ISelection)structuredSelection);
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.wizardSelectionViewer, (ISelection)structuredSelection));
    }

    public void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.wizardSelectionViewer.getSelection();
        if (iStructuredSelection.size() > 0) {
            LogWizardElementBase logWizardElementBase = (LogWizardElementBase)iStructuredSelection.getFirstElement();
            iDialogSettings.put(STORE_SELECTED_WIZARD_ID, logWizardElementBase.getParserId());
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.setErrorMessage(null);
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        LogWizardElementBase logWizardElementBase = (LogWizardElementBase)iStructuredSelection.getFirstElement();
        if (logWizardElementBase == null) {
            this.setMessage(null);
            this.setSelectedNode(null);
            return;
        }
        this.setSelectedNode(this.createWizardNode(logWizardElementBase));
        this.setMessage(logWizardElementBase.getDescription());
    }

    protected LogWizardElementBase findWizard(String string) {
        Object[] objectArray = this.wizardElements.getChildren();
        int n = 0;
        while (n < objectArray.length) {
            LogWizardElementBase logWizardElementBase = (LogWizardElementBase)objectArray[n];
            if (logWizardElementBase.getParserId().equals(string)) {
                return logWizardElementBase;
            }
            ++n;
        }
        return null;
    }

    public IStructuredSelection getCurrentResourceSelection() {
        return this.currentResourceSelection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public void selectWizardNode(IWizardNode iWizardNode) {
        this.setSelectedNode(iWizardNode);
    }
}

