/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.ClassStatisticPage;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.part.IPage;

public class ClassStatisticViewer
extends TraceViewer {
    protected Action _openSource;
    protected Action _percentMode;
    protected Action _printColumns;
    protected Action _deltaColumns;
    protected static final String _title = TraceUIPlugin.getString("STR_CLASS_ST_TITLE");

    public TraceViewerPage createPage(EObject eObject) {
        return new ClassStatisticPage(eObject, this);
    }

    public void dispose() {
        Enumeration enumeration = this._pages.elements();
        while (enumeration.hasMoreElements()) {
            IPage iPage = (IPage)enumeration.nextElement();
            if (!(iPage instanceof ClassStatisticPage)) continue;
            ((ClassStatisticPage)iPage).dispose();
        }
        this._openSource = null;
        this._percentMode = null;
        this._printColumns = null;
        if (this.fContextMenu != null) {
            this.fContextMenu.dispose();
        }
        this.fContextMenu = null;
        super.dispose();
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        String string = TraceUIPlugin.getString("SHOW_PERCENT");
        this._percentMode = new Action(string){

            public void run() {
                ClassStatisticPage classStatisticPage = (ClassStatisticPage)ClassStatisticViewer.this.getCurrentPage();
                if (classStatisticPage == null) {
                    return;
                }
                classStatisticPage.getView().getShowPercentAction().run();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._percentMode.setText(string);
        TracePluginImages.setImageDescriptors((IAction)this._percentMode, "lcl16", "percentage_show.gif");
        this._percentMode.setDescription(string);
        this._percentMode.setToolTipText(string);
        this._percentMode.setEnabled(true);
        String string2 = TraceUIPlugin.getString("STR_ST_SHOW_DELTA_COLUMNS");
        this._deltaColumns = new Action(string2){

            public void run() {
                ClassStatisticPage classStatisticPage = (ClassStatisticPage)ClassStatisticViewer.this.getCurrentPage();
                if (classStatisticPage == null) {
                    return;
                }
                classStatisticPage.getView().getDeltaColumnsAction().run();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._deltaColumns.setText(string2);
        TracePluginImages.setImageDescriptors((IAction)this._deltaColumns, "lcl16", "delta_show.gif");
        this._deltaColumns.setDescription(string2);
        this._deltaColumns.setToolTipText(string2);
        this._deltaColumns.setEnabled(true);
        String string3 = TraceUIPlugin.getString("STR_ST_PRINT_COL");
        this._printColumns = new Action(string3){

            public void run() {
                ClassStatisticPage classStatisticPage = (ClassStatisticPage)ClassStatisticViewer.this.getCurrentPage();
                if (classStatisticPage == null) {
                    return;
                }
                classStatisticPage.getView().getPrintColumnsAction().run();
            }
        };
        this._printColumns.setText(string3);
        TracePluginImages.setImageDescriptors((IAction)this._printColumns, "lcl16", "choosecolumn_co.gif");
        this._printColumns.setDescription(string3);
        this._printColumns.setToolTipText(string3);
        this._printColumns.setEnabled(true);
        String string4 = TraceUIPlugin.getString("STR_SOURCE");
        this._openSource = new Action(string4){

            public void run() {
                ClassStatisticPage classStatisticPage = (ClassStatisticPage)ClassStatisticViewer.this.getCurrentPage();
                if (classStatisticPage == null) {
                    return;
                }
                OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(classStatisticPage.getMOFObject()).getFirstElement());
            }
        };
        this._openSource.setText(string4);
        TracePluginImages.setImageDescriptors((IAction)this._openSource, "tool16", "opensource_co.gif");
        this._openSource.setDescription(string4);
        this._openSource.setToolTipText(string4);
        this._openSource.setEnabled(false);
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this._openSource);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this._percentMode);
        iToolBarManager.add((IAction)this._deltaColumns);
        iToolBarManager.add((IAction)this._printColumns);
        iToolBarManager.add((IContributionItem)new Separator());
        this.getViewSite().getActionBars().updateActionBars();
    }

    public Action percentMode() {
        return this._percentMode;
    }

    public Action deltaColumns() {
        return this._deltaColumns;
    }

    public Action openSource() {
        return this._openSource;
    }

    public void setFocus() {
        ClassStatisticPage classStatisticPage = (ClassStatisticPage)this.getCurrentPage();
        if (classStatisticPage != null) {
            classStatisticPage.setFocus();
        }
    }

    public boolean isValidObject(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TRCMonitor || object instanceof TRCNode) {
            return true;
        }
        if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Profiler")) {
            return true;
        }
        if (object instanceof TRCProcessProxy) {
            EList eList = ((TRCProcessProxy)object).getAgentProxies();
            int n = 0;
            while (n < eList.size()) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList.get(n);
                if (tRCAgentProxy != null && !tRCAgentProxy.eIsProxy() && tRCAgentProxy.getType().equals("Profiler")) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public EObject getObjectToView(EObject eObject) {
        if (eObject == null) {
            return eObject;
        }
        if (eObject instanceof TRCProcessProxy) {
            int n = 0;
            TRCAgentProxy tRCAgentProxy = null;
            EList eList = ((TRCProcessProxy)eObject).getAgentProxies();
            int n2 = 0;
            while (n2 < eList.size()) {
                TRCAgentProxy tRCAgentProxy2 = (TRCAgentProxy)eList.get(n2);
                if (tRCAgentProxy2 != null && !tRCAgentProxy2.eIsProxy() && tRCAgentProxy2.getType().equals("Profiler")) {
                    ++n;
                    tRCAgentProxy = tRCAgentProxy2;
                }
                ++n2;
            }
            if (n == 1) {
                return tRCAgentProxy;
            }
        }
        return eObject;
    }

    public String getViewTitle() {
        return _title;
    }
}

