/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.part.IPage;

public class ExecutionStatisticViewer
extends TraceViewer {
    protected Action _openSource;
    protected Action _percentMode;
    protected Action _showRawTime;
    protected Action _showCompensatedTime;
    protected static final String _title = TraceUIPlugin.getString("STR_EXECUTION_FLOW_TABLE");

    public TraceViewerPage createPage(EObject eObject) {
        return new ExecutionStatisticPage(eObject, this);
    }

    public void dispose() {
        Enumeration enumeration = this._pages.elements();
        while (enumeration.hasMoreElements()) {
            IPage iPage = (IPage)enumeration.nextElement();
            if (!(iPage instanceof ExecutionStatisticPage)) continue;
            ((ExecutionStatisticPage)iPage).dispose();
        }
        this._openSource = null;
        this._percentMode = null;
        this._showCompensatedTime = null;
        this._showRawTime = null;
        super.dispose();
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        String string = TraceUIPlugin.getString("STR_COMPENSATED_TIME");
        this._showCompensatedTime = new Action(string){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 0);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showCompensatedTime.setText(string);
        this._showCompensatedTime.setDescription(string);
        this._showCompensatedTime.setToolTipText(string);
        int n = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showCompensatedTime.setChecked(n == 0);
        String string2 = TraceUIPlugin.getString("STR_RAW_TIME");
        this._showRawTime = new Action(string2){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 1);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showRawTime.setText(string2);
        this._showRawTime.setDescription(string2);
        this._showRawTime.setToolTipText(string2);
        n = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showRawTime.setChecked(n == 1);
        String string3 = TraceUIPlugin.getString("SHOW_PERCENT");
        this._percentMode = new Action(string3){

            public void run() {
                ExecutionStatisticPage executionStatisticPage = (ExecutionStatisticPage)ExecutionStatisticViewer.this.getCurrentPage();
                if (executionStatisticPage == null) {
                    return;
                }
                executionStatisticPage.getView().getShowPercentAction().run();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._percentMode.setText(string3);
        TracePluginImages.setImageDescriptors((IAction)this._percentMode, "lcl16", "percentage_show.gif");
        this._percentMode.setDescription(string3);
        this._percentMode.setToolTipText(string3);
        this._percentMode.setEnabled(true);
        String string4 = TraceUIPlugin.getString("STR_SOURCE");
        this._openSource = new Action(string4){

            public void run() {
                ExecutionStatisticPage executionStatisticPage = (ExecutionStatisticPage)ExecutionStatisticViewer.this.getCurrentPage();
                if (executionStatisticPage == null) {
                    return;
                }
                OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(executionStatisticPage.getMOFObject()).getFirstElement());
            }
        };
        this._openSource.setText(string4);
        TracePluginImages.setImageDescriptors((IAction)this._openSource, "tool16", "opensource_co.gif");
        this._openSource.setDescription(string4);
        this._openSource.setToolTipText(string4);
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        IMenuManager iMenuManager = this.getViewSite().getActionBars().getMenuManager();
        MenuManager menuManager = new MenuManager(TraceUIPlugin.getString("STR_SHOW_TIME"));
        iMenuManager.add((IContributionItem)menuManager);
        menuManager.add((IAction)this._showCompensatedTime);
        menuManager.add((IAction)this._showRawTime);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this._openSource);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this._percentMode);
        iToolBarManager.add((IContributionItem)new Separator());
        this.getViewSite().getActionBars().updateActionBars();
    }

    public Action percentMode() {
        return this._percentMode;
    }

    public Action baseTime() {
        return this._showCompensatedTime;
    }

    public Action rawTime() {
        return this._showRawTime;
    }

    public Action openSource() {
        return this._openSource;
    }

    public void setFocus() {
        if (this.getCurrentPage() != null) {
            ((ExecutionStatisticPage)this.getCurrentPage()).setFocus();
        }
    }

    public boolean isValidObject(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TRCMonitor || object instanceof TRCNode) {
            return true;
        }
        if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Profiler")) {
            return true;
        }
        if (object instanceof TRCProcessProxy) {
            EList eList = ((TRCProcessProxy)object).getAgentProxies();
            int n = 0;
            while (n < eList.size()) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList.get(n);
                if (tRCAgentProxy != null && !tRCAgentProxy.eIsProxy() && tRCAgentProxy.getType().equals("Profiler")) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public EObject getObjectToView(EObject eObject) {
        if (eObject == null) {
            return eObject;
        }
        if (eObject instanceof TRCProcessProxy) {
            int n = 0;
            TRCAgentProxy tRCAgentProxy = null;
            EList eList = ((TRCProcessProxy)eObject).getAgentProxies();
            int n2 = 0;
            while (n2 < eList.size()) {
                TRCAgentProxy tRCAgentProxy2 = (TRCAgentProxy)eList.get(n2);
                if (tRCAgentProxy2 != null && !tRCAgentProxy2.eIsProxy() && tRCAgentProxy2.getType().equals("Profiler")) {
                    ++n;
                    tRCAgentProxy = tRCAgentProxy2;
                }
                ++n2;
            }
            if (n == 1) {
                return tRCAgentProxy;
            }
        }
        return eObject;
    }

    public String getViewTitle() {
        return _title;
    }
}

