/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.adapter.internal.PatternPage;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.GraphColorDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.part.IPage;

public class PatternViewer
extends TraceViewer {
    protected Action _reset;
    protected Action _showRawTime;
    private Action _zoomInAction;
    private Action _zoomOutAction;
    private Action _stdSelectAction;
    protected Action _showCompensatedTime;
    private boolean _stdSelect = true;
    private boolean _zoomIn = false;
    private boolean _zoomOut = false;

    public TraceViewerPage createPage(EObject eObject) {
        return new PatternPage(eObject, this);
    }

    public void dispose() {
        Enumeration enumeration = this._pages.elements();
        while (enumeration.hasMoreElements()) {
            IPage iPage = (IPage)enumeration.nextElement();
            if (!(iPage instanceof PatternPage)) continue;
            ((PatternPage)iPage).dispose();
        }
        this._showCompensatedTime = null;
        this._showRawTime = null;
        this._stdSelectAction = null;
        this._zoomInAction = null;
        this._zoomOutAction = null;
        super.dispose();
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        String string = TraceUIPlugin.getString("STR_COMPENSATED_TIME");
        this._showCompensatedTime = new Action(string){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 0);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showCompensatedTime.setText(string);
        this._showCompensatedTime.setDescription(string);
        this._showCompensatedTime.setToolTipText(string);
        int n = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showCompensatedTime.setChecked(n == 0);
        String string2 = TraceUIPlugin.getString("STR_RAW_TIME");
        this._showRawTime = new Action(string2){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 1);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showRawTime.setText(string2);
        this._showRawTime.setDescription(string2);
        this._showRawTime.setToolTipText(string2);
        n = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showRawTime.setChecked(n == 1);
        String string3 = TraceUIPlugin.getString("STR_HOME");
        this._reset = new Action(string3){

            public void run() {
                PatternPage patternPage = (PatternPage)PatternViewer.this.getCurrentPage();
                if (patternPage == null) {
                    return;
                }
                patternPage.getView().update();
            }
        };
        this._reset.setText(string3);
        TracePluginImages.setImageDescriptors((IAction)this._reset, "tool16", "home_nav.gif");
        this._reset.setDescription(string3);
        this._reset.setToolTipText(string3);
        String string4 = TraceUIPlugin.getString("STR_STD_SELECT");
        this._stdSelectAction = new Action(string4){

            public void run() {
                PatternPage patternPage = (PatternPage)PatternViewer.this.getCurrentPage();
                if (patternPage == null) {
                    return;
                }
                PatternViewer.this._stdSelect = true;
                PatternViewer.this._zoomIn = !PatternViewer.this._stdSelect;
                PatternViewer.this._zoomOut = !PatternViewer.this._stdSelect;
                PatternViewer.this._stdSelectAction.setChecked(true);
                PatternViewer.this._zoomInAction.setChecked(false);
                PatternViewer.this._zoomOutAction.setChecked(false);
                patternPage.getView().zoomIn(PatternViewer.this._zoomIn);
                patternPage.getView().zoomOut(PatternViewer.this._zoomOut);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._stdSelectAction.setText(string4);
        TracePluginImages.setImageDescriptors((IAction)this._stdSelectAction, "lcl16", "select_zoomin.gif");
        this._stdSelectAction.setDescription(string4);
        this._stdSelectAction.setToolTipText(string4);
        String string5 = TraceUIPlugin.getString("STR_ZOOM_IN");
        this._zoomInAction = new Action(string5){

            public void run() {
                PatternPage patternPage = (PatternPage)PatternViewer.this.getCurrentPage();
                if (patternPage == null) {
                    return;
                }
                PatternViewer.this._zoomIn = this.isChecked();
                if (!PatternViewer.this._zoomIn) {
                    PatternViewer.this._stdSelect = true;
                } else {
                    PatternViewer.this._stdSelect = !PatternViewer.this._zoomIn;
                    PatternViewer.this._zoomOut = !PatternViewer.this._zoomIn;
                }
                if (PatternViewer.this._zoomIn) {
                    PatternViewer.this._stdSelectAction.setChecked(false);
                    PatternViewer.this._zoomOutAction.setChecked(false);
                } else {
                    PatternViewer.this._stdSelectAction.setChecked(true);
                }
                patternPage.getView().zoomIn(PatternViewer.this._zoomIn);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._zoomInAction.setText(string5);
        TracePluginImages.setImageDescriptors((IAction)this._zoomInAction, "lcl16", "zoomin_nav.gif");
        this._zoomInAction.setDescription(string5);
        this._zoomInAction.setToolTipText(string5);
        String string6 = TraceUIPlugin.getString("STR_ZOOM_OUT");
        this._zoomOutAction = new Action(string6){

            public void run() {
                PatternPage patternPage = (PatternPage)PatternViewer.this.getCurrentPage();
                if (patternPage == null) {
                    return;
                }
                PatternViewer.this._zoomOut = this.isChecked();
                if (!PatternViewer.this._zoomOut) {
                    PatternViewer.this._stdSelect = true;
                } else {
                    PatternViewer.this._stdSelect = !PatternViewer.this._zoomOut;
                    PatternViewer.this._zoomIn = !PatternViewer.this._zoomOut;
                }
                if (PatternViewer.this._zoomOut) {
                    PatternViewer.this._stdSelectAction.setChecked(false);
                    PatternViewer.this._zoomInAction.setChecked(false);
                } else {
                    PatternViewer.this._stdSelectAction.setChecked(true);
                }
                patternPage.getView().zoomOut(PatternViewer.this._zoomOut);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._zoomOutAction.setText(string6);
        TracePluginImages.setImageDescriptors((IAction)this._zoomOutAction, "lcl16", "zoomout_nav.gif");
        this._zoomOutAction.setDescription(string6);
        this._zoomOutAction.setToolTipText(string6);
        Action action = new Action(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT")){

            public void run() {
                GraphColorDialog graphColorDialog = new GraphColorDialog(PatternViewer.this.getViewSite().getShell(), TraceUIPlugin.getString("STR_GRAPH_COLOR_DLG"), null);
                graphColorDialog.open();
            }
        };
        action.setText(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));
        TracePluginImages.setImageDescriptors((IAction)action, "tool16", "opengraphcolor_co.gif");
        action.setDescription(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));
        action.setToolTipText(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        IMenuManager iMenuManager = this.getViewSite().getActionBars().getMenuManager();
        MenuManager menuManager = new MenuManager(TraceUIPlugin.getString("STR_SHOW_TIME"));
        iMenuManager.add((IContributionItem)menuManager);
        menuManager.add((IAction)this._showCompensatedTime);
        menuManager.add((IAction)this._showRawTime);
        iToolBarManager.removeAll();
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this._stdSelectAction);
        iToolBarManager.add((IAction)this._zoomInAction);
        iToolBarManager.add((IAction)this._zoomOutAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this._reset);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)action);
        this.getViewSite().getActionBars().updateActionBars();
    }

    public Action baseTime() {
        return this._showCompensatedTime;
    }

    public Action rawTime() {
        return this._showRawTime;
    }

    public void setFocus() {
        if (this.getCurrentPage() != null) {
            ((PatternPage)this.getCurrentPage()).setFocus();
        }
    }

    public boolean isValidObject(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TRCMonitor || object instanceof TRCNode) {
            return true;
        }
        if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Profiler")) {
            return true;
        }
        if (object instanceof TRCProcessProxy) {
            EList eList = ((TRCProcessProxy)object).getAgentProxies();
            int n = 0;
            while (n < eList.size()) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList.get(n);
                if (tRCAgentProxy != null && !tRCAgentProxy.eIsProxy() && tRCAgentProxy.getType().equals("Profiler")) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public EObject getObjectToView(EObject eObject) {
        if (eObject == null) {
            return eObject;
        }
        if (eObject instanceof TRCProcessProxy) {
            int n = 0;
            TRCAgentProxy tRCAgentProxy = null;
            EList eList = ((TRCProcessProxy)eObject).getAgentProxies();
            int n2 = 0;
            while (n2 < eList.size()) {
                TRCAgentProxy tRCAgentProxy2 = (TRCAgentProxy)eList.get(n2);
                if (tRCAgentProxy2 != null && !tRCAgentProxy2.eIsProxy() && tRCAgentProxy2.getType().equals("Profiler")) {
                    ++n;
                    tRCAgentProxy = tRCAgentProxy2;
                }
                ++n2;
            }
            if (n == 1) {
                return tRCAgentProxy;
            }
        }
        return eObject;
    }

    public String getViewTitle() {
        return TraceUIPlugin.getString("STR_EXEC_TITLE");
    }

    public void initializeActionBar() {
        this._stdSelectAction.setChecked(true);
    }
}

