/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.InvocationTablePage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.ITimeChangedListener;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class MethodInvocationStatistic
extends StatisticView
implements ITimeChangedListener {
    protected String tmpString;
    private int _drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");

    protected Composite createTable(Composite composite, int n) {
        return new TableTree(composite, n);
    }

    public MethodInvocationStatistic(Composite composite, TraceViewerPage traceViewerPage) {
        super(composite, traceViewerPage);
        this._viewerFilter = new StatisticView.StatisticFilter(this);
        TraceUIPlugin.getDefault().addTimeChangedEventListener(this);
        this._viewerFilter = new ExecutionStatisticFilter();
    }

    public String getColumnsPreferencesKey() {
        return "MInv51";
    }

    public String getDefaultColumnsTemplate() {
        String string = TraceUIPlugin.getString("STR_INVOCATION_COL") + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("STR_ST_INSTANCE_INDEX") + ":1:" + String.valueOf(1) + ":left:200," + TraceUIPlugin.getString("TITLE_START_TIME") + ":2:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("TITLE_TIME_ON_STACK") + ":3:" + String.valueOf(1) + ":right:100";
        return string;
    }

    protected IContentProvider getContentProvider() {
        return new MethodStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new MethodStatisticLabelProvider(this);
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    protected StructuredViewer createTableViewer(Composite composite) {
        ExecutionTreeViewer executionTreeViewer = new ExecutionTreeViewer((TableTree)composite);
        return executionTreeViewer;
    }

    protected void handleSelectionEvent() {
        Table table = ((TableTree)this.getTableViewer().getControl()).getTable();
        if (table != null && !table.isDisposed() && !table.isFocusControl()) {
            this.update();
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)this.fSeparator);
        iMenuManager.add((IAction)this.getUpdateAction());
        iMenuManager.add((IContributionItem)this.fSeparator);
        iMenuManager.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    public void updateButtons() {
        ((InvocationTablePage)this.getTraceViewerPage()).percentMode().setChecked(this.isShowPercent());
    }

    protected void updateDetailsPane() {
        int n = this.getTable().getSelectionIndex();
        if (n < 0) {
            return;
        }
        TableItem tableItem = this.getTable().getItem(n);
        Object object = tableItem.getData();
        if (object == null) {
            return;
        }
        if (object != null && object instanceof TableTreeItem) {
            object = ((TableTreeItem)object).getData();
        }
    }

    public void updateModelSelection() {
        ISelection iSelection = this.getTableViewer().getSelection();
        if (iSelection != null && !iSelection.isEmpty()) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).add(object);
            ViewSelectionChangedEvent viewSelectionChangedEvent = UIPlugin.getDefault().getViewSelectionChangedEvent();
            viewSelectionChangedEvent.setSource((Object)this._page.getMOFObject());
            UIPlugin.getDefault().notifyViewSelectionChangedListener(viewSelectionChangedEvent);
        }
    }

    public void dispose() {
        super.dispose();
        TraceUIPlugin.getDefault().removeTimeChangedEventListener(this);
    }

    public void handleTimeChangedEvent() {
        Action action = ((InvocationTablePage)this.getTraceViewerPage()).baseTime();
        Action action2 = ((InvocationTablePage)this.getTraceViewerPage()).rawTime();
        this._drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        if (action != null) {
            action.setChecked(this._drawMode == 0);
        }
        if (action2 != null) {
            action2.setChecked(this._drawMode == 1);
        }
        String string = TraceUIPlugin.getString("TITLE_RAW_TIME_ON_STACK");
        String string2 = TraceUIPlugin.getString("TITLE_TIME_ON_STACK");
        if (this._drawMode == 1) {
            string2 = TraceUIPlugin.getString("TITLE_RAW_TIME_ON_STACK");
            string = TraceUIPlugin.getString("TITLE_TIME_ON_STACK");
        }
        Table table = this.getTable();
        int n = table.getColumnCount();
        while (n > 0) {
            TableColumn tableColumn = table.getColumn(table.getColumnCount() - 1);
            StatisticTableColumnInfo statisticTableColumnInfo = (StatisticTableColumnInfo)tableColumn.getData();
            String string3 = statisticTableColumnInfo.getColumnData().name();
            if (string3.equals(string)) {
                statisticTableColumnInfo.getColumnData().name(string2);
                if (statisticTableColumnInfo.isSortColumn()) {
                    string2 = tableColumn.getText().substring(0, 1) + string2;
                }
                tableColumn.setText(string2);
            }
            --n;
        }
        this.getTableViewer().refresh();
    }

    public void update() {
        if (this._firstTime) {
            this.getTableViewer().addFilter((ViewerFilter)this.getViewerFilter());
            this._firstTime = false;
            Table table = this.getTable();
            TableColumn tableColumn = table.getColumn(0);
            this._viewerSorter = new MethodStatisticSorter();
            this.getViewerSorter().setSortedColumn(tableColumn);
            this.getTableViewer().setSorter((ViewerSorter)this.getViewerSorter());
        }
        this.getTableViewer().setInput((Object)this._page.getMOFObject());
        this.getTable().setRedraw(false);
        this.getTableViewer().refresh();
        this.getTable().setRedraw(true);
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent viewSelectionChangedEvent) {
        if (!this.getTraceViewerPage().getTraceViewer().isProcessRefreshEvents() || this.getTable().isFocusControl()) {
            return;
        }
        this.handleSelectionEvent();
    }

    class ExecutionTreeViewer
    extends TableTreeViewer {
        public ExecutionTreeViewer(Composite composite) {
            super(composite);
        }

        public ExecutionTreeViewer(TableTree tableTree) {
            super(tableTree);
        }

        public void expandItem(TableTreeItem tableTreeItem) {
            tableTreeItem.setExpanded(true);
            this.createChildren((Widget)tableTreeItem);
        }
    }

    public class MethodStatisticLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public MethodStatisticLabelProvider(StatisticView statisticView) {
            this._viewer = statisticView;
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            int n2 = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(n)).getColumnData().getInitalPos();
            switch (n2) {
                case 0: {
                    return ((TRCMethodInvocation)object).getMethod().getName();
                }
                case 1: {
                    TRCClass tRCClass = PerftraceUtil.getClass((TRCMethodInvocation)object);
                    return tRCClass.getName() + "." + ((TRCMethodInvocation)object).getOwningObject().getId();
                }
                case 2: {
                    if (object instanceof TRCFullMethodInvocation) {
                        return PerftraceUtil.formatTimeValue(((TRCFullMethodInvocation)object).getEntryTime());
                    }
                    return "";
                }
                case 3: {
                    if (!(object instanceof TRCFullMethodInvocation)) break;
                    TRCFullMethodInvocation tRCFullMethodInvocation = (TRCFullMethodInvocation)object;
                    double d = tRCFullMethodInvocation.getEntryTime();
                    double d2 = tRCFullMethodInvocation.getExitTime();
                    if (d2 == 0.0) {
                        d2 = tRCFullMethodInvocation.getOwningObject().getProcess().getLastEventTime();
                    }
                    return PerftraceUtil.formatTimeValue(d2 - d);
                }
            }
            return "";
        }
    }

    public class MethodStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object object) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            MethodInvocationStatistic.this.tmpList.clear();
            ITraceSelection iTraceSelection = UIPlugin.getDefault().getSelectionModel(MethodInvocationStatistic.this._page.getMOFObject());
            if (iTraceSelection.size() > 0) {
                Object object2 = iTraceSelection.getFirstElement();
                if (object2 instanceof TRCMethod) {
                    return ((TRCMethod)object2).getInvocations().toArray();
                }
                if (object2 instanceof TRCMethodInvocation) {
                    return ((TRCMethodInvocation)object2).getMethod().getInvocations().toArray();
                }
            }
            return MethodInvocationStatistic.this.tmpList.toArray();
        }

        public Object[] getChildren(Object object) {
            MethodInvocationStatistic.this.tmpList.clear();
            Object[] objectArray = ((TRCMethodInvocation)object).getInvokes().toArray();
            int n = 0;
            while (n < objectArray.length) {
                MethodInvocationStatistic.this.tmpList.add((TRCMethodInvocation)objectArray[n]);
                ++n;
            }
            return MethodInvocationStatistic.this.tmpList.toArray();
        }

        public boolean hasChildren(Object object) {
            return ((TRCMethodInvocation)object).getInvokes().size() > 0;
        }
    }

    public class MethodStatisticSorter
    extends StatisticView.StatisticSorter {
        public MethodStatisticSorter() {
            super(MethodInvocationStatistic.this);
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            double d = 0.0;
            switch (this._pos) {
                case 0: {
                    return this._sortSequence * ((TRCMethodInvocation)object).getMethod().getName().compareToIgnoreCase(((TRCMethodInvocation)object2).getMethod().getName());
                }
                case 1: {
                    TRCClass tRCClass = PerftraceUtil.getClass((TRCMethodInvocation)object);
                    TRCTraceObject tRCTraceObject = ((TRCMethodInvocation)object).getOwningObject();
                    MethodInvocationStatistic.this.tmpString = tRCClass.getName() + "." + tRCTraceObject.getId();
                    tRCTraceObject = ((TRCMethodInvocation)object2).getOwningObject();
                    tRCClass = PerftraceUtil.getClass((TRCMethodInvocation)object2);
                    return this._sortSequence * MethodInvocationStatistic.this.tmpString.compareToIgnoreCase(tRCClass.getName() + "." + tRCTraceObject.getId());
                }
                case 2: {
                    if (object instanceof TRCFullMethodInvocation && object2 instanceof TRCFullMethodInvocation) {
                        d = ((TRCFullMethodInvocation)object).getEntryTime() - ((TRCFullMethodInvocation)object2).getEntryTime();
                    }
                    if (d < 0.0) {
                        return -1 * this._sortSequence;
                    }
                    if (d > 0.0) {
                        return this._sortSequence;
                    }
                    return 0;
                }
                case 3: {
                    if (!(object instanceof TRCFullMethodInvocation) || !(object2 instanceof TRCFullMethodInvocation)) {
                        return 0;
                    }
                    TRCFullMethodInvocation tRCFullMethodInvocation = (TRCFullMethodInvocation)object;
                    double d2 = tRCFullMethodInvocation.getEntryTime();
                    double d3 = tRCFullMethodInvocation.getExitTime();
                    if (d3 == 0.0) {
                        d3 = tRCFullMethodInvocation.getOwningObject().getProcess().getLastEventTime();
                    }
                    d = d3 - d2;
                    tRCFullMethodInvocation = (TRCFullMethodInvocation)object2;
                    d2 = tRCFullMethodInvocation.getEntryTime();
                    d3 = tRCFullMethodInvocation.getExitTime();
                    if (d3 == 0.0) {
                        d3 = tRCFullMethodInvocation.getOwningObject().getProcess().getLastEventTime();
                    }
                    if ((d -= d3 - d2) < 0.0) {
                        return -1 * this._sortSequence;
                    }
                    if (d > 0.0) {
                        return this._sortSequence;
                    }
                    return 0;
                }
            }
            return 0;
        }
    }

    public class ExecutionStatisticFilter
    extends StatisticView.StatisticFilter {
        public ExecutionStatisticFilter() {
            super(MethodInvocationStatistic.this);
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            boolean bl = true;
            if (!(object2 instanceof TRCMethodInvocation)) {
                return true;
            }
            String string = "";
            string = ((TRCMethodInvocation)object2).getMethod().getName();
            if (string.equals("")) {
                string = TraceUIPlugin.getString("DEFAULT_PACKAGE");
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                string = string.toLowerCase();
            }
            if (this._exactMatch) {
                return string.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                bl = string.startsWith(this._prefix);
            }
            if (bl && this._suffix != "") {
                bl = string.endsWith(this._suffix);
            }
            if (bl) {
                int n = 0;
                while (n < this._textList.size()) {
                    String string2 = (String)this._textList.get(n);
                    int n2 = string.lastIndexOf(string2);
                    if (n2 == -1) {
                        bl = false;
                        break;
                    }
                    string = string.substring(n2 + string2.length());
                    ++n;
                }
            }
            return bl;
        }
    }
}

