/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.util.internal.IColorChangedListener;
import org.eclipse.hyades.trace.views.util.internal.IPercentChangedListener;
import org.eclipse.hyades.trace.views.util.internal.IRefChangedListener;
import org.eclipse.hyades.trace.views.util.internal.ITimeChangedListener;
import org.eclipse.hyades.trace.views.util.internal.SpectrumColorMap;
import org.eclipse.hyades.trace.views.util.internal.UpdateModel;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TraceUIPlugin
extends AbstractUIPlugin {
    private static TraceUIPlugin _plugin;
    private ResourceBundle fResourceBundle;
    private ListenerList fColorChangedEventListeners = new ListenerList(20);
    private ListenerList fRefChangedEventListeners = new ListenerList(20);
    private ListenerList fTimeChangedEventListeners = new ListenerList(20);
    private ListenerList fPercentChangedEventListeners = new ListenerList(20);

    public TraceUIPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        if (_plugin == null) {
            _plugin = this;
        }
        try {
            this.fResourceBundle = this.getDescriptor().getResourceBundle();
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException);
            missingResourceException.printStackTrace();
        }
    }

    public static TraceUIPlugin getDefault() {
        return _plugin;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return TracePluginImages.getImageDescriptor(string);
    }

    public static void setImageDescriptors(IAction iAction, String string, String string2) {
        TracePluginImages.setImageDescriptors(iAction, string, string2);
    }

    public static String getPluginId() {
        return TraceUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public ResourceBundle getResourceBundle() {
        return this.fResourceBundle;
    }

    public static String getString(String string) {
        ResourceBundle resourceBundle = TraceUIPlugin.getDefault().getResourceBundle();
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"background_rgb", (RGB)new RGB(255, 255, 255));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"selection_rgb", (RGB)new RGB(255, 255, 149));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"unknown_rgb", (RGB)new RGB(128, 128, 128));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)"classes_rgb", (RGB)new RGB(71, 141, 141));
        iPreferenceStore.setDefault("bg_option", "system_default");
        iPreferenceStore.setDefault("class_option", "class_default_color");
        iPreferenceStore.setDefault("obj_ref_display", 0);
        iPreferenceStore.setDefault("time_display", 0);
        iPreferenceStore.setDefault("percent", 0);
    }

    public static void log(IStatus iStatus) {
        TraceUIPlugin.getDefault().getLog().log(iStatus);
    }

    public void shutdown() throws CoreException {
        SpectrumColorMap.shutdown();
        TracePluginImages.shutdown();
        super.shutdown();
    }

    public void startup() throws CoreException {
        UIPlugin.getDefault().addProfileEventListener((IProfileEventListener)new UpdateModel());
        SpectrumColorMap.startup();
    }

    public void addColorChangedEventListener(IColorChangedListener iColorChangedListener) {
        this.fColorChangedEventListeners.add((Object)iColorChangedListener);
    }

    public void addRefChangedEventListener(IRefChangedListener iRefChangedListener) {
        this.fRefChangedEventListeners.add((Object)iRefChangedListener);
    }

    public void addTimeChangedEventListener(ITimeChangedListener iTimeChangedListener) {
        this.fTimeChangedEventListeners.add((Object)iTimeChangedListener);
    }

    public void removeColorChangedEventListener(IColorChangedListener iColorChangedListener) {
        this.fColorChangedEventListeners.remove((Object)iColorChangedListener);
    }

    public void removeRefChangedEventListener(IRefChangedListener iRefChangedListener) {
        this.fRefChangedEventListeners.remove((Object)iRefChangedListener);
    }

    public void removeTimeChangedEventListener(ITimeChangedListener iTimeChangedListener) {
        this.fTimeChangedEventListeners.remove((Object)iTimeChangedListener);
    }

    public void notifyColorChangedEventListener() {
        Object[] objectArray = this.fColorChangedEventListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IColorChangedListener)objectArray[n]).handleColorChangedEvent();
            ++n;
        }
    }

    public void notifyRefChangedEventListener() {
        Object[] objectArray = this.fRefChangedEventListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IRefChangedListener)objectArray[n]).handleRefChangedEvent();
            ++n;
        }
    }

    public void notifyTimeChangedEventListener() {
        Object[] objectArray = this.fTimeChangedEventListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((ITimeChangedListener)objectArray[n]).handleTimeChangedEvent();
            ++n;
        }
    }

    public void removePercentChangedEventListener(IPercentChangedListener iPercentChangedListener) {
        this.fPercentChangedEventListeners.remove((Object)iPercentChangedListener);
    }

    public void addPercentChangedEventListener(IPercentChangedListener iPercentChangedListener) {
        this.fPercentChangedEventListeners.add((Object)iPercentChangedListener);
    }

    public void notifyPercentChangedEventListener() {
        Object[] objectArray = this.fPercentChangedEventListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IPercentChangedListener)objectArray[n]).handlePercentChangedEvent();
            ++n;
        }
    }
}

