/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.IColorChangedListener;
import org.eclipse.hyades.trace.views.util.internal.SpectrumColorMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public abstract class BufferedCanvas
extends Canvas
implements IColorChangedListener {
    private Image fBuffer;

    public BufferedCanvas(Composite composite, int n) {
        super(composite, n + 262144);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                BufferedCanvas.this.doubleBufferPaint(paintEvent.gc);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (BufferedCanvas.this.fBuffer != null) {
                    TraceUIPlugin.getDefault().removeColorChangedEventListener(BufferedCanvas.this);
                    BufferedCanvas.this.fBuffer.dispose();
                    BufferedCanvas.this.fBuffer = null;
                }
            }
        });
        TraceUIPlugin.getDefault().addColorChangedEventListener(this);
    }

    public abstract void doPaint(GC var1);

    private void doubleBufferPaint(GC gC) {
        Rectangle rectangle;
        Point point = this.getSize();
        if (point.x <= 0 || point.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            rectangle = this.fBuffer.getBounds();
            if (rectangle.width != point.x || rectangle.height != point.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.getDisplay(), point.x, point.y);
        }
        rectangle = new GC((Drawable)this.fBuffer);
        try {
            rectangle.setBackground(this.getBackground());
            rectangle.fillRectangle(0, 0, point.x, point.y);
            this.doPaint((GC)rectangle);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            rectangle.dispose();
            throw throwable;
        }
        rectangle.dispose();
        gC.drawImage(this.fBuffer, 0, 0);
    }

    public void repaint() {
        if (!this.isDisposed()) {
            GC gC = new GC((Drawable)this);
            FontData fontData = SpectrumColorMap.getFontData();
            Font font = new Font((Device)this.getDisplay(), fontData);
            gC.setFont(font);
            this.doubleBufferPaint(gC);
            font.dispose();
            gC.dispose();
        }
    }

    public void handleColorChangedEvent() {
        if (!this.isDisposed()) {
            this.setBackground(SpectrumColorMap.getBackgroundColor());
            this.repaint();
        } else {
            TraceUIPlugin.getDefault().removeColorChangedEventListener(this);
        }
    }
}

