/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;

public class ColumnData {
    public static final int IS_VISIBLE = 1;
    public static final int NONDELETABLE = 2;
    public static final int NONMOVABLE = 4;
    public static final int NONRESIZABLE = 8;
    public static final int SUPPORTS_DELTA = 16;
    private String _name;
    private int _style = 0;
    private int _width = 20;
    private int _alignment;
    private int _initialPos = 0;

    public ColumnData(String string, int n, int n2, int n3, int n4) {
        this.initialize(string, n, n2, n3, n4);
    }

    private void initialize(String string, int n, int n2, int n3, int n4) {
        this._name = string;
        this._initialPos = n;
        this._style = n2;
        this._width = n4;
        this._alignment = n3;
    }

    public static ArrayList createColumnData(String string, String string2) {
        String string3 = TraceUIPlugin.getDefault().getPreferenceStore().getString(string);
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        return ColumnData.createColumnDataFromString(string3);
    }

    public static ArrayList createColumnDataFromString(String string) {
        ArrayList arrayList = new ArrayList();
        if (string != null && !string.equals("")) {
            int n = 0;
            while (n != -1) {
                String string2;
                n = string.indexOf(",");
                if (n != -1) {
                    string2 = string.substring(0, n);
                    string = string.substring(n + 1);
                } else {
                    string2 = string;
                }
                ColumnData.addColumnData(string2, arrayList);
            }
        }
        return arrayList;
    }

    private static void addColumnData(String string, ArrayList arrayList) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        int n3 = 16384;
        int n4 = 0;
        int n5 = string.indexOf(":");
        if (n5 != -1) {
            string2 = string.substring(0, n5);
            string = string.substring(n5 + 1);
        }
        if ((n5 = string.indexOf(":")) != -1) {
            n4 = Integer.parseInt(string.substring(0, n5));
            string = string.substring(n5 + 1);
        }
        if ((n5 = string.indexOf(":")) != -1) {
            n = Integer.parseInt(string.substring(0, n5));
            string = string.substring(n5 + 1);
        }
        if ((n5 = string.indexOf(":")) != -1) {
            n3 = string.substring(0, n5).equals("left") ? 16384 : 131072;
            string = string.substring(n5 + 1);
        }
        n2 = Integer.parseInt(string);
        arrayList.add(new ColumnData(string2, n4, n, n3, n2));
    }

    public static void setColumns(ArrayList arrayList, ArrayList arrayList2, String string) {
        arrayList2.clear();
        arrayList2.addAll(arrayList);
        ColumnData.setColumns(arrayList2, string);
    }

    public static void setColumns(ArrayList arrayList, String string) {
        String string2 = "";
        boolean bl = false;
        String string3 = "";
        int n = 0;
        while (n < arrayList.size()) {
            ColumnData columnData = (ColumnData)arrayList.get(n);
            string2 = columnData.name();
            int n2 = columnData.width();
            String string4 = columnData.getAlignment() == 16384 ? "left" : "right";
            string3 = string3 + "," + string2 + ":" + columnData.getInitalPos() + ":" + columnData.getStyle() + ":" + string4 + ":" + n2;
            ++n;
        }
        if (string3.startsWith(",") && string3.length() > 1) {
            string3 = string3.substring(1);
        }
        TraceUIPlugin.getDefault().getPreferenceStore().setValue(string, string3);
    }

    public String name() {
        return this._name;
    }

    public void name(String string) {
        this._name = string;
    }

    public boolean isNonDeletable() {
        return (this._style & 2) != 0;
    }

    public boolean visible() {
        return (this._style & 1) != 0;
    }

    public int getAlignment() {
        return this._alignment;
    }

    public int getStyle() {
        return this._style;
    }

    public boolean isResizable() {
        return (this._style & 8) == 0;
    }

    public boolean isMovable() {
        return (this._style & 4) == 0;
    }

    public boolean supportsDelta() {
        return (this._style & 0x10) != 0;
    }

    public int width() {
        return this._width;
    }

    public void width(int n) {
        this._width = n;
    }

    public int getInitalPos() {
        return this._initialPos;
    }
}

