/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;

public class PerftraceUtil {
    private static NumberFormat _decimalFormat = null;
    private static NumberFormat _percentFormat = null;
    private static ArrayList tmpList = new ArrayList();

    private static void getAgentThreads(TRCAgentProxy tRCAgentProxy, ArrayList arrayList) {
        if (!tRCAgentProxy.getType().equals("Profiler") || tRCAgentProxy.getAgent().getProcess() == null) {
            return;
        }
        Object[] objectArray = ((TRCProcess)tRCAgentProxy.getAgent().getProcess()).getThreads().toArray();
        int n = 0;
        while (n < objectArray.length) {
            TRCThread tRCThread = (TRCThread)objectArray[n];
            if (tRCThread.getInitialInvocations().size() > 0) {
                if (tRCThread.getName() == null) {
                    tRCThread.setName(String.valueOf(n + 1));
                }
                arrayList.add(tRCThread);
            }
            ++n;
        }
    }

    private static void getAgentHeapDump(TRCAgentProxy tRCAgentProxy, ArrayList arrayList) {
        if (!tRCAgentProxy.getType().equals("Profiler") || tRCAgentProxy.getAgent().getProcess() == null) {
            return;
        }
        arrayList.addAll(((TRCProcess)tRCAgentProxy.getAgent().getProcess()).getHeapDumps());
    }

    private static void getAgentGc(TRCAgentProxy tRCAgentProxy, ArrayList arrayList) {
        if (!tRCAgentProxy.getType().equals("Profiler") || tRCAgentProxy.getAgent() == null || PerftraceUtil.getProcess(tRCAgentProxy.getAgent()) == null) {
            return;
        }
    }

    private static void getAgentPackages(TRCAgentProxy tRCAgentProxy, ArrayList arrayList) {
        if (!tRCAgentProxy.getType().equals("Profiler") || tRCAgentProxy.getAgent() == null || PerftraceUtil.getProcess(tRCAgentProxy.getAgent()) == null) {
            return;
        }
        arrayList.addAll(PerftraceUtil.getProcess(tRCAgentProxy.getAgent()).getPackages());
    }

    private static void getAgentClasses(TRCAgentProxy tRCAgentProxy, ArrayList arrayList) {
        if (!tRCAgentProxy.getType().equals("Profiler") || tRCAgentProxy.getAgent() == null || PerftraceUtil.getProcess(tRCAgentProxy.getAgent()) == null) {
            return;
        }
        Object[] objectArray = PerftraceUtil.getProcess(tRCAgentProxy.getAgent()).getPackages().toArray();
        int n = 0;
        while (n < objectArray.length) {
            arrayList.addAll(((TRCPackage)objectArray[n]).getClasses());
            ++n;
        }
    }

    private static void getAgentObjReferences(TRCAgentProxy tRCAgentProxy, ArrayList arrayList) {
        if (!tRCAgentProxy.getType().equals("Profiler") || tRCAgentProxy.getAgent() == null || PerftraceUtil.getProcess(tRCAgentProxy.getAgent()) == null) {
            return;
        }
    }

    public static Object[] getAllPackages(EObject eObject) {
        tmpList.clear();
        if (eObject != null) {
            if (eObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentPackages((TRCAgentProxy)eObject, tmpList);
                return tmpList.toArray();
            }
            if (eObject instanceof TRCProcessProxy) {
                Object[] objectArray = ((TRCProcessProxy)eObject).getAgentProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    PerftraceUtil.getAgentPackages((TRCAgentProxy)objectArray[n], tmpList);
                    ++n;
                }
                return tmpList.toArray();
            }
            if (eObject instanceof TRCNode) {
                Object[] objectArray = ((TRCNode)eObject).getProcessProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray2 = ((TRCProcessProxy)objectArray[n]).getAgentProxies().toArray();
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        PerftraceUtil.getAgentPackages((TRCAgentProxy)objectArray2[n2], tmpList);
                        ++n2;
                    }
                    ++n;
                }
                return tmpList.toArray();
            }
            if (eObject instanceof TRCMonitor) {
                Object[] objectArray = ((TRCMonitor)eObject).getNodes().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray3 = ((TRCNode)objectArray[n]).getProcessProxies().toArray();
                    int n3 = 0;
                    while (n3 < objectArray3.length) {
                        Object[] objectArray4 = ((TRCProcessProxy)objectArray3[n3]).getAgentProxies().toArray();
                        int n4 = 0;
                        while (n4 < objectArray4.length) {
                            PerftraceUtil.getAgentPackages((TRCAgentProxy)objectArray4[n4], tmpList);
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n;
                }
                return tmpList.toArray();
            }
        }
        return tmpList.toArray();
    }

    public static Object[] getAllReferences(EObject eObject) {
        tmpList.clear();
        if (eObject != null) {
            if (eObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentObjReferences((TRCAgentProxy)eObject, tmpList);
                return tmpList.toArray();
            }
            if (eObject instanceof TRCProcessProxy) {
                Object[] objectArray = ((TRCProcessProxy)eObject).getAgentProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    PerftraceUtil.getAgentObjReferences((TRCAgentProxy)objectArray[n], tmpList);
                    ++n;
                }
                return tmpList.toArray();
            }
            if (eObject instanceof TRCNode) {
                Object[] objectArray = ((TRCNode)eObject).getProcessProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray2 = ((TRCProcessProxy)objectArray[n]).getAgentProxies().toArray();
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        PerftraceUtil.getAgentObjReferences((TRCAgentProxy)objectArray2[n2], tmpList);
                        ++n2;
                    }
                    ++n;
                }
                return tmpList.toArray();
            }
            if (eObject instanceof TRCMonitor) {
                Object[] objectArray = ((TRCMonitor)eObject).getNodes().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray3 = ((TRCNode)objectArray[n]).getProcessProxies().toArray();
                    int n3 = 0;
                    while (n3 < objectArray3.length) {
                        Object[] objectArray4 = ((TRCProcessProxy)objectArray3[n3]).getAgentProxies().toArray();
                        int n4 = 0;
                        while (n4 < objectArray4.length) {
                            PerftraceUtil.getAgentObjReferences((TRCAgentProxy)objectArray4[n4], tmpList);
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n;
                }
                return tmpList.toArray();
            }
        }
        return tmpList.toArray();
    }

    public static Object[] getAllClasses(EObject eObject) {
        tmpList.clear();
        if (eObject != null) {
            if (eObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentClasses((TRCAgentProxy)eObject, tmpList);
                return tmpList.toArray();
            }
            if (eObject instanceof TRCProcessProxy) {
                Object[] objectArray = ((TRCProcessProxy)eObject).getAgentProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    PerftraceUtil.getAgentClasses((TRCAgentProxy)objectArray[n], tmpList);
                    ++n;
                }
                return tmpList.toArray();
            }
            if (eObject instanceof TRCNode) {
                Object[] objectArray = ((TRCNode)eObject).getProcessProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray2 = ((TRCProcessProxy)objectArray[n]).getAgentProxies().toArray();
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        PerftraceUtil.getAgentClasses((TRCAgentProxy)objectArray2[n2], tmpList);
                        ++n2;
                    }
                    ++n;
                }
                return tmpList.toArray();
            }
            if (eObject instanceof TRCMonitor) {
                Object[] objectArray = ((TRCMonitor)eObject).getNodes().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray3 = ((TRCNode)objectArray[n]).getProcessProxies().toArray();
                    int n3 = 0;
                    while (n3 < objectArray3.length) {
                        Object[] objectArray4 = ((TRCProcessProxy)objectArray3[n3]).getAgentProxies().toArray();
                        int n4 = 0;
                        while (n4 < objectArray4.length) {
                            PerftraceUtil.getAgentClasses((TRCAgentProxy)objectArray4[n4], tmpList);
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n;
                }
                return tmpList.toArray();
            }
        }
        return tmpList.toArray();
    }

    public static Object[] getAllGc(EObject eObject) {
        tmpList.clear();
        if (eObject != null) {
            if (eObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentGc((TRCAgentProxy)eObject, tmpList);
                return tmpList.toArray();
            }
            if (eObject instanceof TRCProcessProxy) {
                Object[] objectArray = ((TRCProcessProxy)eObject).getAgentProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    PerftraceUtil.getAgentGc((TRCAgentProxy)objectArray[n], tmpList);
                    ++n;
                }
                return tmpList.toArray();
            }
            if (eObject instanceof TRCNode) {
                Object[] objectArray = ((TRCNode)eObject).getProcessProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray2 = ((TRCProcessProxy)objectArray[n]).getAgentProxies().toArray();
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        PerftraceUtil.getAgentGc((TRCAgentProxy)objectArray2[n2], tmpList);
                        ++n2;
                    }
                    ++n;
                }
                return tmpList.toArray();
            }
            if (eObject instanceof TRCMonitor) {
                Object[] objectArray = ((TRCMonitor)eObject).getNodes().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray3 = ((TRCNode)objectArray[n]).getProcessProxies().toArray();
                    int n3 = 0;
                    while (n3 < objectArray3.length) {
                        Object[] objectArray4 = ((TRCProcessProxy)objectArray3[n3]).getAgentProxies().toArray();
                        int n4 = 0;
                        while (n4 < objectArray4.length) {
                            PerftraceUtil.getAgentGc((TRCAgentProxy)objectArray4[n4], tmpList);
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n;
                }
                return tmpList.toArray();
            }
        }
        return tmpList.toArray();
    }

    public static Object[] getAllHeapDump(EObject eObject) {
        tmpList.clear();
        if (eObject != null) {
            if (eObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentHeapDump((TRCAgentProxy)eObject, tmpList);
                return tmpList.toArray();
            }
            if (eObject instanceof TRCProcessProxy) {
                Object[] objectArray = ((TRCProcessProxy)eObject).getAgentProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    PerftraceUtil.getAgentHeapDump((TRCAgentProxy)objectArray[n], tmpList);
                    ++n;
                }
                return tmpList.toArray();
            }
            if (eObject instanceof TRCNode) {
                Object[] objectArray = ((TRCNode)eObject).getProcessProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray2 = ((TRCProcessProxy)objectArray[n]).getAgentProxies().toArray();
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        PerftraceUtil.getAgentHeapDump((TRCAgentProxy)objectArray2[n2], tmpList);
                        ++n2;
                    }
                    ++n;
                }
                return tmpList.toArray();
            }
            if (eObject instanceof TRCMonitor) {
                Object[] objectArray = ((TRCMonitor)eObject).getNodes().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray3 = ((TRCNode)objectArray[n]).getProcessProxies().toArray();
                    int n3 = 0;
                    while (n3 < objectArray3.length) {
                        Object[] objectArray4 = ((TRCProcessProxy)objectArray3[n3]).getAgentProxies().toArray();
                        int n4 = 0;
                        while (n4 < objectArray4.length) {
                            PerftraceUtil.getAgentHeapDump((TRCAgentProxy)objectArray4[n4], tmpList);
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n;
                }
                return tmpList.toArray();
            }
        }
        return tmpList.toArray();
    }

    public static Object[] getAllThreads(EObject eObject) {
        tmpList.clear();
        if (eObject != null) {
            if (eObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentThreads((TRCAgentProxy)eObject, tmpList);
                return tmpList.toArray();
            }
            if (eObject instanceof TRCProcessProxy) {
                Object[] objectArray = ((TRCProcessProxy)eObject).getAgentProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    PerftraceUtil.getAgentThreads((TRCAgentProxy)objectArray[n], tmpList);
                    ++n;
                }
                return tmpList.toArray();
            }
            if (eObject instanceof TRCNode) {
                Object[] objectArray = ((TRCNode)eObject).getProcessProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray2 = ((TRCProcessProxy)objectArray[n]).getAgentProxies().toArray();
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        PerftraceUtil.getAgentThreads((TRCAgentProxy)objectArray2[n2], tmpList);
                        ++n2;
                    }
                    ++n;
                }
                return tmpList.toArray();
            }
            if (eObject instanceof TRCMonitor) {
                Object[] objectArray = ((TRCMonitor)eObject).getNodes().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray3 = ((TRCNode)objectArray[n]).getProcessProxies().toArray();
                    int n3 = 0;
                    while (n3 < objectArray3.length) {
                        Object[] objectArray4 = ((TRCProcessProxy)objectArray3[n3]).getAgentProxies().toArray();
                        int n4 = 0;
                        while (n4 < objectArray4.length) {
                            PerftraceUtil.getAgentThreads((TRCAgentProxy)objectArray4[n4], tmpList);
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n;
                }
                return tmpList.toArray();
            }
        }
        return tmpList.toArray();
    }

    public static int getTotalCalls(EObject eObject) {
        int n = 0;
        if (eObject != null) {
            if (eObject instanceof TRCAgentProxy) {
                TRCProcess tRCProcess;
                if (((TRCAgentProxy)eObject).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)eObject).getAgent().getProcess()) != null) {
                    n = tRCProcess.getCalls();
                }
            } else if (eObject instanceof TRCProcessProxy) {
                Object[] objectArray = ((TRCProcessProxy)eObject).getAgentProxies().toArray();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    TRCProcess tRCProcess;
                    if (((TRCAgentProxy)objectArray[n2]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray[n2]).getAgent().getProcess()) != null) {
                        n += tRCProcess.getCalls();
                    }
                    ++n2;
                }
            } else if (eObject instanceof TRCNode) {
                Object[] objectArray = ((TRCNode)eObject).getProcessProxies().toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    Object[] objectArray2 = ((TRCProcessProxy)objectArray[n3]).getAgentProxies().toArray();
                    int n4 = 0;
                    while (n4 < objectArray2.length) {
                        TRCProcess tRCProcess;
                        if (((TRCAgentProxy)objectArray2[n4]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray2[n4]).getAgent().getProcess()) != null) {
                            n += tRCProcess.getCalls();
                        }
                        ++n4;
                    }
                    ++n3;
                }
            } else if (eObject instanceof TRCMonitor) {
                Object[] objectArray = ((TRCMonitor)eObject).getNodes().toArray();
                int n5 = 0;
                while (n5 < objectArray.length) {
                    Object[] objectArray3 = ((TRCNode)objectArray[n5]).getProcessProxies().toArray();
                    int n6 = 0;
                    while (n6 < objectArray3.length) {
                        Object[] objectArray4 = ((TRCProcessProxy)objectArray3[n6]).getAgentProxies().toArray();
                        int n7 = 0;
                        while (n7 < objectArray4.length) {
                            TRCProcess tRCProcess;
                            if (((TRCAgentProxy)objectArray4[n7]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray4[n7]).getAgent().getProcess()) != null) {
                                n += tRCProcess.getCalls();
                            }
                            ++n7;
                        }
                        ++n6;
                    }
                    ++n5;
                }
            }
        }
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public static int getTotalInstances(EObject eObject) {
        int n = 0;
        if (eObject != null) {
            if (eObject instanceof TRCAgentProxy) {
                TRCProcess tRCProcess;
                if (((TRCAgentProxy)eObject).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)eObject).getAgent().getProcess()) != null) {
                    n = tRCProcess.getTotalInstances();
                }
            } else if (eObject instanceof TRCProcessProxy) {
                Object[] objectArray = ((TRCProcessProxy)eObject).getAgentProxies().toArray();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    TRCProcess tRCProcess;
                    if (((TRCAgentProxy)objectArray[n2]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray[n2]).getAgent().getProcess()) != null) {
                        n += tRCProcess.getTotalInstances();
                    }
                    ++n2;
                }
            } else if (eObject instanceof TRCNode) {
                Object[] objectArray = ((TRCNode)eObject).getProcessProxies().toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    Object[] objectArray2 = ((TRCProcessProxy)objectArray[n3]).getAgentProxies().toArray();
                    int n4 = 0;
                    while (n4 < objectArray2.length) {
                        TRCProcess tRCProcess;
                        if (((TRCAgentProxy)objectArray2[n4]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray2[n4]).getAgent().getProcess()) != null) {
                            n += tRCProcess.getTotalInstances();
                        }
                        ++n4;
                    }
                    ++n3;
                }
            } else if (eObject instanceof TRCMonitor) {
                Object[] objectArray = ((TRCMonitor)eObject).getNodes().toArray();
                int n5 = 0;
                while (n5 < objectArray.length) {
                    Object[] objectArray3 = ((TRCNode)objectArray[n5]).getProcessProxies().toArray();
                    int n6 = 0;
                    while (n6 < objectArray3.length) {
                        Object[] objectArray4 = ((TRCProcessProxy)objectArray3[n6]).getAgentProxies().toArray();
                        int n7 = 0;
                        while (n7 < objectArray4.length) {
                            TRCProcess tRCProcess;
                            if (((TRCAgentProxy)objectArray4[n7]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray4[n7]).getAgent().getProcess()) != null) {
                                n += tRCProcess.getTotalInstances();
                            }
                            ++n7;
                        }
                        ++n6;
                    }
                    ++n5;
                }
            }
        }
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public static int getActiveInstances(EObject eObject) {
        int n = 0;
        if (eObject != null) {
            if (eObject instanceof TRCAgentProxy) {
                TRCProcess tRCProcess;
                if (((TRCAgentProxy)eObject).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)eObject).getAgent().getProcess()) != null) {
                    n = tRCProcess.getTotalInstances() - tRCProcess.getCollectedInstances();
                }
            } else if (eObject instanceof TRCProcessProxy) {
                Object[] objectArray = ((TRCProcessProxy)eObject).getAgentProxies().toArray();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    TRCProcess tRCProcess;
                    if (((TRCAgentProxy)objectArray[n2]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray[n2]).getAgent().getProcess()) != null) {
                        n += tRCProcess.getTotalInstances() - tRCProcess.getCollectedInstances();
                    }
                    ++n2;
                }
            } else if (eObject instanceof TRCNode) {
                Object[] objectArray = ((TRCNode)eObject).getProcessProxies().toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    Object[] objectArray2 = ((TRCProcessProxy)objectArray[n3]).getAgentProxies().toArray();
                    int n4 = 0;
                    while (n4 < objectArray2.length) {
                        TRCProcess tRCProcess;
                        if (((TRCAgentProxy)objectArray2[n4]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray2[n4]).getAgent().getProcess()) != null) {
                            n += tRCProcess.getTotalInstances() - tRCProcess.getCollectedInstances();
                        }
                        ++n4;
                    }
                    ++n3;
                }
            } else if (eObject instanceof TRCMonitor) {
                Object[] objectArray = ((TRCMonitor)eObject).getNodes().toArray();
                int n5 = 0;
                while (n5 < objectArray.length) {
                    Object[] objectArray3 = ((TRCNode)objectArray[n5]).getProcessProxies().toArray();
                    int n6 = 0;
                    while (n6 < objectArray3.length) {
                        Object[] objectArray4 = ((TRCProcessProxy)objectArray3[n6]).getAgentProxies().toArray();
                        int n7 = 0;
                        while (n7 < objectArray4.length) {
                            TRCProcess tRCProcess;
                            if (((TRCAgentProxy)objectArray4[n7]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray4[n7]).getAgent().getProcess()) != null) {
                                n += tRCProcess.getTotalInstances() - tRCProcess.getCollectedInstances();
                            }
                            ++n7;
                        }
                        ++n6;
                    }
                    ++n5;
                }
            }
        }
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public static double getMaximumTime(EObject eObject) {
        double d = 0.0;
        if (eObject != null) {
            if (eObject instanceof TRCAgentProxy) {
                TRCProcess tRCProcess;
                if (((TRCAgentProxy)eObject).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)eObject).getAgent().getProcess()) != null) {
                    d = tRCProcess.getLastEventTime();
                }
            } else if (eObject instanceof TRCProcessProxy) {
                Object[] objectArray = ((TRCProcessProxy)eObject).getAgentProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    double d2;
                    TRCProcess tRCProcess;
                    if (((TRCAgentProxy)objectArray[n]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray[n]).getAgent().getProcess()) != null && (d2 = tRCProcess.getLastEventTime()) > d) {
                        d = d2;
                    }
                    ++n;
                }
            } else if (eObject instanceof TRCNode) {
                Object[] objectArray = ((TRCNode)eObject).getProcessProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray2 = ((TRCProcessProxy)objectArray[n]).getAgentProxies().toArray();
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        double d3;
                        TRCProcess tRCProcess;
                        if (((TRCAgentProxy)objectArray2[n2]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray2[n2]).getAgent().getProcess()) != null && (d3 = tRCProcess.getLastEventTime()) > d) {
                            d = d3;
                        }
                        ++n2;
                    }
                    ++n;
                }
            } else if (eObject instanceof TRCMonitor) {
                Object[] objectArray = ((TRCMonitor)eObject).getNodes().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray3 = ((TRCNode)objectArray[n]).getProcessProxies().toArray();
                    int n3 = 0;
                    while (n3 < objectArray3.length) {
                        Object[] objectArray4 = ((TRCProcessProxy)objectArray3[n3]).getAgentProxies().toArray();
                        int n4 = 0;
                        while (n4 < objectArray4.length) {
                            double d4;
                            TRCProcess tRCProcess;
                            if (((TRCAgentProxy)objectArray4[n4]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray4[n4]).getAgent().getProcess()) != null && (d4 = tRCProcess.getLastEventTime()) > d) {
                                d = d4;
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n;
                }
            }
        }
        if (d == 0.0) {
            d = 1.0;
        }
        return d;
    }

    public static long getTotalSize(EObject eObject) {
        long l = 0L;
        if (eObject != null) {
            if (eObject instanceof TRCAgentProxy) {
                TRCProcess tRCProcess;
                if (((TRCAgentProxy)eObject).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)eObject).getAgent().getProcess()) != null) {
                    l = tRCProcess.getTotalSize();
                }
            } else if (eObject instanceof TRCProcessProxy) {
                Object[] objectArray = ((TRCProcessProxy)eObject).getAgentProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    TRCProcess tRCProcess;
                    if (((TRCAgentProxy)objectArray[n]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray[n]).getAgent().getProcess()) != null) {
                        l += (long)tRCProcess.getTotalSize();
                    }
                    ++n;
                }
            } else if (eObject instanceof TRCNode) {
                Object[] objectArray = ((TRCNode)eObject).getProcessProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray2 = ((TRCProcessProxy)objectArray[n]).getAgentProxies().toArray();
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        TRCProcess tRCProcess;
                        if (((TRCAgentProxy)objectArray2[n2]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray2[n2]).getAgent().getProcess()) != null) {
                            l += (long)tRCProcess.getTotalSize();
                        }
                        ++n2;
                    }
                    ++n;
                }
            } else if (eObject instanceof TRCMonitor) {
                Object[] objectArray = ((TRCMonitor)eObject).getNodes().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray3 = ((TRCNode)objectArray[n]).getProcessProxies().toArray();
                    int n3 = 0;
                    while (n3 < objectArray3.length) {
                        Object[] objectArray4 = ((TRCProcessProxy)objectArray3[n3]).getAgentProxies().toArray();
                        int n4 = 0;
                        while (n4 < objectArray4.length) {
                            TRCProcess tRCProcess;
                            if (((TRCAgentProxy)objectArray4[n4]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray4[n4]).getAgent().getProcess()) != null) {
                                l += (long)tRCProcess.getTotalSize();
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n;
                }
            }
        }
        if (l == 0L) {
            l = 1L;
        }
        return l;
    }

    public static long getActiveSize(EObject eObject) {
        long l = 0L;
        if (eObject != null) {
            if (eObject instanceof TRCAgentProxy) {
                TRCProcess tRCProcess;
                if (((TRCAgentProxy)eObject).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)eObject).getAgent().getProcess()) != null) {
                    l = tRCProcess.getTotalSize() - tRCProcess.getCollectedSize();
                }
            } else if (eObject instanceof TRCProcessProxy) {
                Object[] objectArray = ((TRCProcessProxy)eObject).getAgentProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    TRCProcess tRCProcess;
                    if (((TRCAgentProxy)objectArray[n]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray[n]).getAgent().getProcess()) != null) {
                        l += (long)(tRCProcess.getTotalSize() - tRCProcess.getCollectedSize());
                    }
                    ++n;
                }
            } else if (eObject instanceof TRCNode) {
                Object[] objectArray = ((TRCNode)eObject).getProcessProxies().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray2 = ((TRCProcessProxy)objectArray[n]).getAgentProxies().toArray();
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        TRCProcess tRCProcess;
                        if (((TRCAgentProxy)objectArray2[n2]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray2[n2]).getAgent().getProcess()) != null) {
                            l += (long)(tRCProcess.getTotalSize() - tRCProcess.getCollectedSize());
                        }
                        ++n2;
                    }
                    ++n;
                }
            } else if (eObject instanceof TRCMonitor) {
                Object[] objectArray = ((TRCMonitor)eObject).getNodes().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Object[] objectArray3 = ((TRCNode)objectArray[n]).getProcessProxies().toArray();
                    int n3 = 0;
                    while (n3 < objectArray3.length) {
                        Object[] objectArray4 = ((TRCProcessProxy)objectArray3[n3]).getAgentProxies().toArray();
                        int n4 = 0;
                        while (n4 < objectArray4.length) {
                            TRCProcess tRCProcess;
                            if (((TRCAgentProxy)objectArray4[n4]).getAgent() != null && (tRCProcess = (TRCProcess)((TRCAgentProxy)objectArray4[n4]).getAgent().getProcess()) != null) {
                                l += (long)(tRCProcess.getTotalSize() - tRCProcess.getCollectedSize());
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                    ++n;
                }
            }
        }
        if (l == 0L) {
            l = 1L;
        }
        return l;
    }

    public static boolean collectStatisticInfo(EObject eObject) {
        if (eObject != null) {
            int n;
            int n2;
            Object[] objectArray;
            if (eObject instanceof TRCAgentProxy) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eObject;
                return tRCAgentProxy.getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || tRCAgentProxy.getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || tRCAgentProxy.getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL;
            }
            if (eObject instanceof TRCProcessProxy) {
                objectArray = ((TRCProcessProxy)eObject).getAgentProxies().toArray();
                n2 = 0;
                while (n2 < objectArray.length) {
                    boolean bl;
                    boolean bl2 = bl = ((TRCAgentProxy)objectArray[n2]).getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)objectArray[n2]).getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)objectArray[n2]).getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL;
                    if (!bl) {
                        return false;
                    }
                    ++n2;
                }
            }
            if (eObject instanceof TRCNode) {
                objectArray = ((TRCNode)eObject).getProcessProxies().toArray();
                n2 = 0;
                while (n2 < objectArray.length) {
                    Object[] objectArray2 = ((TRCProcessProxy)objectArray[n2]).getAgentProxies().toArray();
                    n = 0;
                    while (n < objectArray2.length) {
                        boolean bl;
                        boolean bl3 = bl = ((TRCAgentProxy)objectArray2[n]).getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)objectArray2[n]).getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)objectArray2[n]).getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL;
                        if (!bl) {
                            return false;
                        }
                        ++n;
                    }
                    ++n2;
                }
            }
            if (eObject instanceof TRCMonitor) {
                objectArray = ((TRCMonitor)eObject).getNodes().toArray();
                n2 = 0;
                while (n2 < objectArray.length) {
                    Object[] objectArray3 = ((TRCNode)objectArray[n2]).getProcessProxies().toArray();
                    n = 0;
                    while (n < objectArray3.length) {
                        Object[] objectArray4 = ((TRCProcessProxy)objectArray3[n]).getAgentProxies().toArray();
                        int n3 = 0;
                        while (n3 < objectArray4.length) {
                            boolean bl;
                            boolean bl4 = bl = ((TRCAgentProxy)objectArray4[n3]).getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)objectArray4[n3]).getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)objectArray4[n3]).getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL;
                            if (!bl) {
                                return false;
                            }
                            ++n3;
                        }
                        ++n;
                    }
                    ++n2;
                }
            }
        }
        return true;
    }

    public static boolean collectInstanceInformation(TRCAgentProxy tRCAgentProxy) {
        TRCConfiguration tRCConfiguration;
        EList eList;
        if (tRCAgentProxy.getName().equals("J2EE Request Profiler")) {
            return true;
        }
        TRCCollectionMode tRCCollectionMode = tRCAgentProxy.getCollectionMode();
        if (tRCCollectionMode == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL || tRCCollectionMode == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || tRCCollectionMode == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL) {
            return false;
        }
        Iterator iterator = tRCAgentProxy.getConfigurations().iterator();
        if (iterator.hasNext() && (eList = (tRCConfiguration = (TRCConfiguration)iterator.next()).getOptions()) != null) {
            Iterator iterator2 = eList.iterator();
            while (iterator2.hasNext()) {
                TRCOption tRCOption = (TRCOption)iterator2.next();
                if (!tRCOption.getKey().equals("TRACE_MODE") || !tRCOption.getValue().equals("noObjectCorrelation")) continue;
                return false;
            }
        }
        return true;
    }

    public static TRCProcess getProcess(TRCAgent tRCAgent) {
        if (tRCAgent.getProcess() instanceof TRCProcess) {
            return (TRCProcess)tRCAgent.getProcess();
        }
        return null;
    }

    public static String getPackageName(TRCPackage tRCPackage, Object object) {
        StringBuffer stringBuffer = new StringBuffer(tRCPackage.getName());
        if (stringBuffer.length() == 0) {
            stringBuffer.append(TraceUIPlugin.getString("DEFAULT_PACKAGE"));
        }
        if (object instanceof TRCAgentProxy || object instanceof TRCProcessProxy) {
            return stringBuffer.toString();
        }
        return stringBuffer.append(" [").append(tRCPackage.getProcess().getPid()).append("]").toString();
    }

    public static long getTime(double d) {
        return (long)(d * 1000000.0);
    }

    public static String formatAsPercentage(double d) {
        if (_percentFormat == null) {
            _percentFormat = NumberFormat.getPercentInstance();
            _percentFormat.setMaximumIntegerDigits(3);
            _percentFormat.setMaximumFractionDigits(2);
            _percentFormat.setMinimumFractionDigits(2);
        }
        return _percentFormat.format(d);
    }

    public static String getThreadName(TRCThread tRCThread) {
        StringBuffer stringBuffer = new StringBuffer(tRCThread.getName());
        return stringBuffer.append("[").append(tRCThread.getProcess().getPid()).append("]").toString();
    }

    public static String formatTimeValue(double d) {
        if (_decimalFormat == null) {
            _decimalFormat = NumberFormat.getNumberInstance();
            _decimalFormat.setMaximumFractionDigits(6);
            _decimalFormat.setMinimumFractionDigits(6);
        }
        return _decimalFormat.format(d);
    }

    public static TRCClass getClass(TRCMethodInvocation tRCMethodInvocation) {
        TRCTraceObject tRCTraceObject = tRCMethodInvocation.getOwningObject();
        if (tRCTraceObject.getIsA() != tRCMethodInvocation.getProcess().getClassClass()) {
            return tRCTraceObject.getIsA();
        }
        return tRCMethodInvocation.getMethod().getDefiningClass();
    }

    public static TRCClass getClass(TRCObject tRCObject) {
        TRCClass tRCClass = tRCObject.getIsA();
        if (tRCClass == tRCObject.getProcess().getClassClass()) {
            TRCPackage[] tRCPackageArray = (TRCPackage[])tRCObject.getProcess().getPackages().toArray();
            int n = 0;
            while (n < tRCPackageArray.length) {
                TRCClass[] tRCClassArray = (TRCClass[])tRCPackageArray[n].getClasses().toArray();
                int n2 = 0;
                while (n2 < tRCClassArray.length) {
                    Object[] objectArray = tRCClassArray[n2].getClassObjects().toArray();
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        if (objectArray[n3] == tRCObject) {
                            return tRCClassArray[n2];
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return tRCClass;
    }
}

