/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PrintColumnsDialog
extends Dialog
implements SelectionListener,
Listener,
ModifyListener {
    private Text _txtTargetFileName;
    private Button _btnTargetBrowse;
    private String _fileName = "";
    private String _title;
    private Shell _shell;

    public PrintColumnsDialog(Shell shell, String string, Image image) {
        super(shell);
        this._shell = shell;
        this._title = string;
        Window.setDefaultImage((Image)image);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 4;
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 300;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)gridData);
        Label label = new Label(composite3, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(TraceUIPlugin.getString("STR_PRINT_DLG_TEXT"));
        Label label2 = new Label(composite3, 0);
        gridData = new GridData();
        label2.setLayoutData((Object)gridData);
        label2.setText(TraceUIPlugin.getString("STR_PRINT_DLG_FILE"));
        this._txtTargetFileName = new Text(composite3, 2048);
        this._txtTargetFileName.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._btnTargetBrowse = new Button(composite3, 8);
        this._btnTargetBrowse.setText(TraceUIPlugin.getString("STR_PRINT_DLG_BROWSE"));
        this._btnTargetBrowse.addListener(13, (Listener)this);
        this._txtTargetFileName.addModifyListener((ModifyListener)this);
        return composite2;
    }

    protected void buttonPressed(int n) {
        super.buttonPressed(n);
    }

    protected void okPressed() {
        this._fileName = this._txtTargetFileName.getText().trim();
        if (this._fileName == null || this._fileName.equals("")) {
            MessageDialog.openError((Shell)this._shell, (String)TraceUIPlugin.getString("STR_TRACE_MSG"), (String)TraceUIPlugin.getString("STR_PRINT_DLG_ERROR"));
            return;
        }
        super.okPressed();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public void handleEvent(Event event) {
        if (event.widget == this._btnTargetBrowse) {
            this.showTargetDialog();
        }
    }

    private void showTargetDialog() {
        String string = this._txtTargetFileName.getText();
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setFileName(string);
        fileDialog.setFilterExtensions(new String[]{"*.htm", "*.*"});
        String string2 = fileDialog.open();
        if (string2 != null) {
            this._txtTargetFileName.setText(string2);
        }
        this._fileName = string2;
    }

    public void modifyText(ModifyEvent modifyEvent) {
    }

    public String getFileName() {
        return this._fileName;
    }
}

