/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.DeleteUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class DeleteAction
extends SelectionProviderAction
implements ISelectionChangedListener {
    protected Object fSelection;
    protected Object[] fSelections;
    private Shell shell;
    private PDProjectExplorer fViewer;
    private ArrayList deletedPaths = new ArrayList();

    public DeleteAction(PDProjectExplorer pDProjectExplorer) {
        super((ISelectionProvider)pDProjectExplorer.getViewer(), UIPlugin.getResourceString("DELETE"));
        this.setDescription(UIPlugin.getResourceString("DELETE_RESOURCE"));
        this.setToolTipText(UIPlugin.getResourceString("DELETE_OBJECT_TOOLTIP"));
        WorkbenchHelp.setHelp((IAction)this, (String)(UIPlugin.getPluginId() + ".delt0000"));
        this.fViewer = pDProjectExplorer;
    }

    public void run() {
        Object object;
        Object object2;
        if (this.fSelections == null) {
            return;
        }
        this.shell = this.fViewer.getShell();
        this.fViewer.getViewer().setSelection(null);
        int n = 0;
        while (n < this.fSelections.length) {
            object2 = this.fSelections[n];
            if (!this.validForDelete(object2)) {
                return;
            }
            ++n;
        }
        object2 = new DeleteResourceDialog(this.fViewer.getShell());
        if (object2.open() != 0) {
            return;
        }
        final boolean bl = ((DeleteResourceDialog)((Object)object2)).getDeleteContent();
        this.deletedPaths.clear();
        int n2 = 0;
        while (n2 < this.fSelections.length) {
            object = this.fSelections[n2];
            if (object != null) {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    public void run() {
                        if (object instanceof IResource) {
                            if (!DeleteAction.this.containsPath(((IResource)object).getFullPath())) {
                                DeleteUtil.deleteResource((IResource)object, bl);
                                DeleteAction.this.deletedPaths.add(((IResource)object).getFullPath());
                            }
                        } else if (object instanceof TRCMonitor) {
                            DeleteUtil.deleteMonitor((TRCMonitor)object, true, bl);
                        } else if (object instanceof TRCNode) {
                            DeleteUtil.deleteNode((TRCNode)object, true, bl);
                        } else if (object instanceof TRCAgentProxy) {
                            DeleteUtil.deleteAgent((TRCAgentProxy)object, true, bl);
                        } else if (object instanceof TRCProcessProxy) {
                            DeleteUtil.deleteProcess((TRCProcessProxy)object, true, bl);
                        }
                    }
                });
            }
            ++n2;
        }
        this.fSelections = null;
        this.deletedPaths.clear();
        this.fSelection = null;
        this.shell = null;
        object = UIPlugin.getDefault().getProfileEvent();
        ((ProfileEvent)object).setSource(null);
        ((ProfileEvent)object).setType(128);
        UIPlugin.getDefault().notifyProfileEventListener((ProfileEvent)object);
    }

    private boolean containsPath(IPath iPath) {
        Iterator iterator = ((AbstractList)this.deletedPaths).iterator();
        while (iterator.hasNext()) {
            IPath iPath2 = (IPath)iterator.next();
            if (!iPath2.isPrefixOf(iPath)) continue;
            return true;
        }
        return false;
    }

    private boolean checkContainer(IContainer iContainer, int n) {
        IResource[] iResourceArray;
        if (n != 0) {
            if (n != -1) {
                --n;
            }
            try {
                iResourceArray = iContainer.members();
                int n2 = 0;
                while (n2 < iResourceArray.length) {
                    if (iResourceArray[n2] instanceof IContainer && !this.checkContainer((IContainer)iResourceArray[n2], n)) {
                        return false;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
                return false;
            }
        }
        iResourceArray = PDContentProvider.getMonitors(iContainer);
        return true;
    }

    private boolean validForDelete(Object object) {
        if (object != null) {
            if (object instanceof IContainer) {
                return this.checkContainer((IContainer)object, -1);
            }
            return !(object instanceof TRCAgentProxy ? !this.checkAgentState((TRCAgentProxy)object) : object instanceof TRCProcessProxy && !this.checkAgentsState(((TRCProcessProxy)object).getAgentProxies()));
        }
        return true;
    }

    private boolean checkAgentsState(EList eList) {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator.next();
            if (tRCAgentProxy.eIsProxy() || this.checkAgentState(tRCAgentProxy)) continue;
            return false;
        }
        return true;
    }

    private boolean checkAgentState(TRCAgentProxy tRCAgentProxy) {
        if (tRCAgentProxy.isActive() && (tRCAgentProxy.isAttached() || tRCAgentProxy.isMonitored())) {
            this.treatActiveAgentWhenDelete(tRCAgentProxy);
            return false;
        }
        return true;
    }

    private void treatActiveAgentWhenDelete(TRCAgentProxy tRCAgentProxy) {
        String string = UIPlugin.getResourceString("DELETE_ACTIVE_AGENT_ERROR_");
        string = HyadesUtil.change(string, "%1", tRCAgentProxy.getName());
        if (this.shell != null) {
            final Status status = new Status(2, "org.eclipse.core.resources", 566, string, null);
            this.shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)DeleteAction.this.shell, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("DELETE_FILE_ERROR_TITLE"), (IStatus)status);
                }
            });
        }
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
    }

    public void setSelection(Object object) {
        this.fSelection = object;
    }

    public void setSelections(Object[] objectArray) {
        this.fSelections = objectArray;
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
        this.fSelections = null;
        this.deletedPaths.clear();
        this.deletedPaths = null;
        this.fSelection = null;
        this.shell = null;
    }

    class DeleteResourceDialog
    extends MessageDialog {
        private boolean deleteContent = false;
        private Button radio1;
        private Button radio2;
        private SelectionListener selectionListener = new SelectionAdapter(this){
            private final /* synthetic */ DeleteResourceDialog this$1;
            {
                this.this$1 = deleteResourceDialog;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                if (button.getSelection()) {
                    DeleteResourceDialog.access$002(this.this$1, button == DeleteResourceDialog.access$100(this.this$1));
                }
            }
        };

        DeleteResourceDialog(Shell shell) {
            super(shell, UIPlugin.getResourceString("TRACE_MSG"), null, UIPlugin.getResourceString("CONFIRM_DEL_MSG"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        }

        protected Control createCustomArea(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite2, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            String string = UIPlugin.getResourceString("STR_DELETE_RESOURCE_PATH");
            this.radio1.setText(string);
            this.radio2 = new Button(composite2, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            String string2 = UIPlugin.getResourceString("STR_NOT_DELETE_RESOURCE");
            this.radio2.setText(string2);
            this.radio1.setSelection(this.deleteContent);
            this.radio2.setSelection(!this.deleteContent);
            return composite2;
        }

        public boolean getDeleteContent() {
            return this.deleteContent;
        }

        static /* synthetic */ boolean access$002(DeleteResourceDialog deleteResourceDialog, boolean bl) {
            deleteResourceDialog.deleteContent = bl;
            return deleteResourceDialog.deleteContent;
        }

        static /* synthetic */ Button access$100(DeleteResourceDialog deleteResourceDialog) {
            return deleteResourceDialog.radio1;
        }
    }
}

