/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class RefreshFromLocalAction
extends SelectionProviderAction
implements ISelectionChangedListener {
    private PDProjectExplorer fViewer;

    public RefreshFromLocalAction(PDProjectExplorer pDProjectExplorer) {
        super((ISelectionProvider)pDProjectExplorer.getViewer(), UIPlugin.getResourceString("RELOAD"));
        this.setDescription(UIPlugin.getResourceString("RELOAD_LOCAL_FILE"));
        this.fViewer = pDProjectExplorer;
        WorkbenchHelp.setHelp((IAction)this, (String)(UIPlugin.getPluginId() + ".refl0000"));
        this.setToolTipText(UIPlugin.getResourceString("RELOAD_LOCAL_FILE_TOOLTIP"));
    }

    public void run() {
        String string = UIPlugin.getResourceString("TRACE_MSG");
        String string2 = UIPlugin.getResourceString("RELOAD_QUESTION");
        if (!MessageDialog.openQuestion((Shell)this.fViewer.getShell(), (String)string, (String)string2)) {
            return;
        }
        PDContentProvider.resetMonitors();
        Hashtable hashtable = SaveUtil.getDocuments();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Resource resource = (Resource)enumeration.nextElement();
            Iterator iterator = resource.getContents().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof TRCProcessProxy) {
                    UIPlugin.getDefault().getTraceManager().deregisterTrace((TRCProcessProxy)e);
                    UIPlugin.getDefault().deregisterLaunchProcess((TRCProcessProxy)e);
                }
                if (e instanceof TRCAgentProxy) {
                    UIPlugin.getDefault().getTraceManager().deregisterTrace((TRCAgentProxy)e);
                }
                ArrayList arrayList = UIPlugin.getDefault().getDeleteListeners();
                int n = 0;
                while (n < arrayList.size()) {
                    ((IDeleteListener)arrayList.get(n)).deregister(e);
                    ++n;
                }
                SaveUtil.removeDocument((Resource)resource);
                resource.getResourceSet().getResources().remove(resource);
            }
        }
        this.fViewer.getViewer().refresh();
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(true);
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
    }
}

