/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.help.WorkbenchHelp;

public class SaveAction
extends SelectionProviderAction
implements ISelectionChangedListener,
IRunnableWithProgress {
    private PDProjectExplorer fViewer;
    private Object[] fSelections;
    private IResource fResSelection;
    private IResource[] fResSelections;
    private Shell fShell;
    private IStatus status;
    private final String MONITOR = UIPlugin.getResourceString("SAVE_MONITOR_TEXT");
    private final String NODE = UIPlugin.getResourceString("SAVE_NODE_TEXT");
    private final String PROCESS = UIPlugin.getResourceString("SAVE_PROCESS_TEXT");
    private final String AGENT = UIPlugin.getResourceString("SAVE_AGENT_TEXT");
    private ArrayList processedURIs = new ArrayList();

    public SaveAction(PDProjectExplorer pDProjectExplorer) {
        super((ISelectionProvider)pDProjectExplorer.getViewer(), UIPlugin.getResourceString("SAVE"));
        this.setDescription(UIPlugin.getResourceString("SAVE"));
        this.fViewer = pDProjectExplorer;
        WorkbenchHelp.setHelp((IAction)this, (String)(UIPlugin.getPluginId() + ".save0000"));
    }

    public void run() {
        String string = UIPlugin.getResourceString("TRACE_MSG");
        String string2 = "";
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fViewer.getViewer().getSelection();
        this.fSelections = iStructuredSelection.toArray();
        this.fShell = this.fViewer.getShell();
        Item[] itemArray = this.fViewer.getViewer().getTreeSelections();
        string2 = itemArray.length == 1 && itemArray[0].getData() != null && itemArray[0].getData() instanceof IProject ? UIPlugin.getResourceString("SAVE_PROJECT_Q") : UIPlugin.getResourceString("SAVE_RES_Q");
        if (!MessageDialog.openQuestion((Shell)this.fViewer.getShell(), (String)UIPlugin.getResourceString("SAVTOLOCACT_DIA_TITLE"), (String)string2)) {
            return;
        }
        this.fResSelections = new IResource[itemArray.length];
        int n = 0;
        while (n < itemArray.length) {
            this.fResSelections[n] = this.fViewer.getSelectionFolder((TreeItem)itemArray[n]);
            ++n;
        }
        this.fResSelection = this.fResSelections[0];
        this.processedURIs.clear();
        try {
            new ProgressMonitorDialog(this.fShell).run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this));
        }
        catch (InterruptedException interruptedException) {
            try {
                if (this.fResSelection != null && this.fResSelection.exists()) {
                    this.fResSelection.getProject().refreshLocal(2, null);
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            this.fResSelection = null;
            this.fResSelections = null;
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            this.fResSelection = null;
            this.fResSelections = null;
            return;
        }
        try {
            if (this.fResSelection != null && this.fResSelection.exists()) {
                this.fResSelection.getProject().refreshLocal(2, null);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        this.fResSelection = null;
        this.fResSelections = null;
    }

    public void run(IProgressMonitor iProgressMonitor) {
        ArrayList arrayList = PDContentProvider.getMonitors((IContainer)this.fResSelection);
        int n = SaveUtil.documentsSize();
        if (arrayList.size() != 0) {
            n /= arrayList.size();
        }
        iProgressMonitor.beginTask(UIPlugin.getResourceString("SAVE"), n);
        Object object = null;
        int n2 = 0;
        while (n2 < this.fSelections.length) {
            object = this.fSelections[n2];
            this.fResSelection = this.fResSelections[n2];
            if (object instanceof IContainer) {
                this.saveContainer((IContainer)object, iProgressMonitor);
            } else if (object instanceof TRCMonitor) {
                TRCMonitor tRCMonitor = (TRCMonitor)object;
                if (this.validForSave(tRCMonitor)) {
                    try {
                        if (!this.processedURIs.contains(tRCMonitor.eResource().getURI())) {
                            SaveUtil.save((TRCMonitor)tRCMonitor, (IProgressMonitor)iProgressMonitor);
                            this.processedURIs.add(tRCMonitor.eResource().getURI());
                        }
                    }
                    catch (Exception exception) {
                        this.treatSaveException(this.MONITOR, tRCMonitor.getName(), tRCMonitor.eResource());
                    }
                }
            } else if (object instanceof TRCNode) {
                this.saveNode((TRCNode)object, iProgressMonitor);
            } else if (object instanceof TRCProcessProxy) {
                this.saveProcess((TRCProcessProxy)object, iProgressMonitor);
            } else if (object instanceof TRCAgentProxy) {
                this.saveAgent((TRCAgentProxy)object, iProgressMonitor);
            }
            ++n2;
        }
    }

    private void saveAgent(TRCAgentProxy tRCAgentProxy, IProgressMonitor iProgressMonitor) {
        TRCProcessProxy tRCProcessProxy = tRCAgentProxy.getProcessProxy();
        TRCNode tRCNode = tRCProcessProxy.getNode();
        TRCMonitor tRCMonitor = tRCNode.getMonitor();
        if (this.isResourcesReadOnly(tRCMonitor.eResource())) {
            this.treatSaveReadOnlyException(tRCMonitor.getName(), tRCMonitor.eResource());
            return;
        }
        if (this.isResourcesReadOnly(tRCNode.eResource())) {
            this.treatSaveReadOnlyException(tRCNode.getName(), tRCNode.eResource());
            return;
        }
        if (this.isResourcesReadOnly(tRCProcessProxy.eResource())) {
            this.treatSaveReadOnlyException(tRCProcessProxy.getName(), tRCProcessProxy.eResource());
            return;
        }
        if (this.isResourcesReadOnly(tRCAgentProxy.eResource())) {
            this.treatSaveReadOnlyException(tRCAgentProxy.getName(), tRCAgentProxy.eResource());
            return;
        }
        if (tRCAgentProxy.isActive() && tRCAgentProxy.isMonitored()) {
            this.treatActiveAgentWhenSave(tRCAgentProxy);
            return;
        }
        try {
            if (!this.processedURIs.contains(tRCMonitor.eResource().getURI())) {
                SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)tRCMonitor.eResource());
                this.processedURIs.add(tRCMonitor.eResource().getURI());
            }
        }
        catch (Exception exception) {
            this.treatSaveException(this.MONITOR, tRCMonitor.getName(), tRCMonitor.eResource());
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            if (!this.processedURIs.contains(tRCNode.eResource().getURI())) {
                SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)tRCNode.eResource());
                this.processedURIs.add(tRCNode.eResource().getURI());
            }
        }
        catch (Exception exception) {
            this.treatSaveException(this.NODE, tRCNode.getName(), tRCNode.eResource());
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            if (!this.processedURIs.contains(tRCProcessProxy.eResource().getURI())) {
                SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)tRCProcessProxy.eResource());
                this.processedURIs.add(tRCProcessProxy.eResource().getURI());
            }
        }
        catch (Exception exception) {
            this.treatSaveException(this.PROCESS, tRCProcessProxy.getName(), tRCProcessProxy.eResource());
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            if (tRCAgentProxy.getAgent() != null && !this.processedURIs.contains(tRCAgentProxy.getAgent().eResource().getURI())) {
                SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)tRCAgentProxy.getAgent().eResource());
                this.processedURIs.add(tRCAgentProxy.getAgent().eResource().getURI());
            }
        }
        catch (Exception exception) {
            this.treatSaveException(this.AGENT, tRCAgentProxy.getName(), tRCAgentProxy.eResource());
        }
    }

    private void saveContainer(IContainer iContainer, IProgressMonitor iProgressMonitor) {
        int n;
        Object object;
        try {
            object = iContainer.members();
            n = 0;
            while (n < ((IResource[])object).length) {
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (object[n] instanceof IContainer) {
                    this.saveContainer((IContainer)object[n], iProgressMonitor);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            return;
        }
        object = PDContentProvider.getMonitors(iContainer);
        n = 0;
        while (n < ((ArrayList)object).size()) {
            TRCMonitor tRCMonitor;
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            Object e = ((ArrayList)object).get(n);
            if (e instanceof TRCMonitor && this.validForSave(tRCMonitor = (TRCMonitor)e)) {
                try {
                    if (!this.processedURIs.contains(tRCMonitor.eResource().getURI())) {
                        SaveUtil.save((TRCMonitor)tRCMonitor, (IProgressMonitor)iProgressMonitor);
                        this.processedURIs.add(tRCMonitor.eResource().getURI());
                    }
                }
                catch (Exception exception) {
                    this.treatSaveException(this.MONITOR, tRCMonitor.getName(), tRCMonitor.eResource());
                }
            }
            ++n;
        }
    }

    private void saveNode(TRCNode tRCNode, IProgressMonitor iProgressMonitor) {
        TRCAgentProxy tRCAgentProxy;
        TRCProcessProxy tRCProcessProxy;
        Object object;
        TRCMonitor tRCMonitor = tRCNode.getMonitor();
        if (this.isResourcesReadOnly(tRCMonitor.eResource())) {
            this.treatSaveReadOnlyException(tRCMonitor.getName(), tRCMonitor.eResource());
            return;
        }
        if (this.isResourcesReadOnly(tRCNode.eResource())) {
            this.treatSaveReadOnlyException(tRCNode.getName(), tRCNode.eResource());
            return;
        }
        Object[] objectArray = tRCNode.getProcessProxies().toArray();
        int n = 0;
        while (n < objectArray.length) {
            object = (TRCProcessProxy)objectArray[n];
            if (!object.eIsProxy()) {
                if (this.isResourcesReadOnly(object.eResource())) {
                    this.treatSaveReadOnlyException(object.getName(), object.eResource());
                    return;
                }
                tRCProcessProxy = object.getAgentProxies().toArray();
                int n2 = 0;
                while (n2 < ((Object[])tRCProcessProxy).length) {
                    tRCAgentProxy = (TRCAgentProxy)tRCProcessProxy[n2];
                    if (!tRCAgentProxy.eIsProxy()) {
                        if (this.isResourcesReadOnly(tRCAgentProxy.eResource())) {
                            this.treatSaveReadOnlyException(tRCAgentProxy.getName(), tRCAgentProxy.eResource());
                            return;
                        }
                        if (tRCAgentProxy.isActive() && tRCAgentProxy.isMonitored()) {
                            this.treatActiveAgentWhenSave(tRCAgentProxy);
                            return;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        try {
            if (!this.processedURIs.contains(tRCMonitor.eResource().getURI())) {
                SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)tRCMonitor.eResource());
                this.processedURIs.add(tRCMonitor.eResource().getURI());
            }
        }
        catch (Exception exception) {
            this.treatSaveException(this.MONITOR, tRCMonitor.getName(), tRCMonitor.eResource());
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            if (!this.processedURIs.contains(tRCNode.eResource().getURI())) {
                SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)tRCNode.eResource());
                this.processedURIs.add(tRCNode.eResource().getURI());
            }
        }
        catch (Exception exception) {
            this.treatSaveException(this.NODE, tRCNode.getName(), tRCNode.eResource());
        }
        object = tRCNode.getProcessProxies().iterator();
        while (object.hasNext()) {
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            tRCProcessProxy = (TRCProcessProxy)object.next();
            if (tRCProcessProxy.eIsProxy()) continue;
            try {
                if (!this.processedURIs.contains(tRCProcessProxy.eResource().getURI())) {
                    SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)tRCProcessProxy.eResource());
                    this.processedURIs.add(tRCProcessProxy.eResource().getURI());
                }
            }
            catch (Exception exception) {
                this.treatSaveException(this.PROCESS, tRCProcessProxy.getName(), tRCProcessProxy.eResource());
            }
            Iterator iterator = tRCProcessProxy.getAgentProxies().iterator();
            while (iterator.hasNext()) {
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                tRCAgentProxy = (TRCAgentProxy)iterator.next();
                if (tRCAgentProxy.eIsProxy()) continue;
                try {
                    if (tRCAgentProxy.getAgent() == null || this.processedURIs.contains(tRCAgentProxy.getAgent().eResource().getURI())) continue;
                    SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)tRCAgentProxy.getAgent().eResource());
                    this.processedURIs.add(tRCAgentProxy.getAgent().eResource().getURI());
                }
                catch (Exception exception) {
                    this.treatSaveException(this.AGENT, tRCAgentProxy.getName(), tRCAgentProxy.eResource());
                }
            }
        }
    }

    private void saveProcess(TRCProcessProxy tRCProcessProxy, IProgressMonitor iProgressMonitor) {
        Object object;
        TRCNode tRCNode = tRCProcessProxy.getNode();
        TRCMonitor tRCMonitor = tRCNode.getMonitor();
        if (this.isResourcesReadOnly(tRCMonitor.eResource())) {
            this.treatSaveReadOnlyException(tRCMonitor.getName(), tRCMonitor.eResource());
            return;
        }
        if (this.isResourcesReadOnly(tRCNode.eResource())) {
            this.treatSaveReadOnlyException(tRCNode.getName(), tRCNode.eResource());
            return;
        }
        if (this.isResourcesReadOnly(tRCProcessProxy.eResource())) {
            this.treatSaveReadOnlyException(tRCProcessProxy.getName(), tRCProcessProxy.eResource());
            return;
        }
        Object[] objectArray = tRCProcessProxy.getAgentProxies().toArray();
        int n = 0;
        while (n < objectArray.length) {
            object = (TRCAgentProxy)objectArray[n];
            if (!object.eIsProxy()) {
                if (this.isResourcesReadOnly(object.eResource())) {
                    this.treatSaveReadOnlyException(object.getName(), object.eResource());
                    return;
                }
                if (object.isActive() && object.isMonitored()) {
                    this.treatActiveAgentWhenSave((TRCAgentProxy)object);
                    return;
                }
            }
            ++n;
        }
        try {
            if (!this.processedURIs.contains(tRCMonitor.eResource().getURI())) {
                SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)tRCMonitor.eResource());
                this.processedURIs.add(tRCMonitor.eResource().getURI());
            }
        }
        catch (Exception exception) {
            this.treatSaveException(this.MONITOR, tRCMonitor.getName(), tRCMonitor.eResource());
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            if (!this.processedURIs.contains(tRCNode.eResource().getURI())) {
                SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)tRCNode.eResource());
                this.processedURIs.add(tRCNode.eResource().getURI());
            }
        }
        catch (Exception exception) {
            this.treatSaveException(this.NODE, tRCNode.getName(), tRCNode.eResource());
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            if (!this.processedURIs.contains(tRCProcessProxy.eResource().getURI())) {
                SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)tRCProcessProxy.eResource());
                this.processedURIs.add(tRCProcessProxy.eResource().getURI());
            }
        }
        catch (Exception exception) {
            this.treatSaveException(this.PROCESS, tRCProcessProxy.getName(), tRCProcessProxy.eResource());
        }
        object = tRCProcessProxy.getAgentProxies().iterator();
        while (object.hasNext()) {
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)object.next();
            if (tRCAgentProxy.eIsProxy()) continue;
            try {
                if (tRCAgentProxy.getAgent() == null || this.processedURIs.contains(tRCAgentProxy.getAgent().eResource().getURI())) continue;
                SaveUtil.saveResource((IProgressMonitor)iProgressMonitor, (Resource)tRCAgentProxy.getAgent().eResource());
                this.processedURIs.add(tRCAgentProxy.getAgent().eResource().getURI());
            }
            catch (Exception exception) {
                this.treatSaveException(this.AGENT, tRCAgentProxy.getName(), tRCAgentProxy.eResource());
            }
        }
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(true);
    }

    private void treatSaveException(String string, String string2, Resource resource) {
        if (this.processedURIs.contains(resource.getURI())) {
            return;
        }
        this.processedURIs.add(resource.getURI());
        String string3 = UIPlugin.getResourceString("SAVE_FILE_ERROR_");
        string3 = TString.change(string3, "%1", string);
        string3 = resource != null ? TString.change(string3, "%2", resource.getURI().toString()) : TString.change(string3, "%2", string2);
        if (this.fShell != null) {
            final Status status = new Status(2, "org.eclipse.core.resources", 566, string3, null);
            this.fShell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)SaveAction.this.fShell, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("SAVE_FILE_ERROR_TITLE"), (IStatus)status);
                }
            });
        }
    }

    private void treatSaveReadOnlyException(String string, Resource resource) {
        if (this.processedURIs.contains(resource.getURI())) {
            return;
        }
        this.processedURIs.add(resource.getURI());
        String string2 = UIPlugin.getResourceString("SAVE_READ_ONLY_FILE_ERROR_");
        if (resource != null) {
            string2 = TString.change(string2, "%2", resource.getURI().toString());
        }
        if (string != null) {
            string2 = TString.change(string2, "%1", string);
        }
        if (this.fShell != null) {
            final Status status = new Status(2, "org.eclipse.core.resources", 566, string2, null);
            this.fShell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)SaveAction.this.fShell, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("SAVE_FILE_ERROR_TITLE"), (IStatus)status);
                }
            });
        }
    }

    private boolean validForSave(TRCMonitor tRCMonitor) {
        if (this.isResourcesReadOnly(tRCMonitor.eResource())) {
            this.treatSaveReadOnlyException(tRCMonitor.getName(), tRCMonitor.eResource());
            return false;
        }
        Object[] objectArray = tRCMonitor.getNodes().toArray();
        int n = 0;
        while (n < objectArray.length) {
            TRCNode tRCNode = (TRCNode)objectArray[n];
            if (!tRCNode.eIsProxy()) {
                if (this.isResourcesReadOnly(tRCNode.eResource())) {
                    this.treatSaveReadOnlyException(tRCNode.getName(), tRCNode.eResource());
                    return false;
                }
                Object[] objectArray2 = tRCNode.getProcessProxies().toArray();
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)objectArray2[n2];
                    if (!tRCProcessProxy.eIsProxy()) {
                        if (this.isResourcesReadOnly(tRCProcessProxy.eResource())) {
                            this.treatSaveReadOnlyException(tRCProcessProxy.getName(), tRCProcessProxy.eResource());
                            return false;
                        }
                        Object[] objectArray3 = tRCProcessProxy.getAgentProxies().toArray();
                        int n3 = 0;
                        while (n3 < objectArray3.length) {
                            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)objectArray3[n3];
                            if (!tRCAgentProxy.eIsProxy()) {
                                if (this.isResourcesReadOnly(tRCAgentProxy.eResource())) {
                                    this.treatSaveReadOnlyException(tRCAgentProxy.getName(), tRCAgentProxy.eResource());
                                    return false;
                                }
                                if (tRCAgentProxy.isActive() && tRCAgentProxy.isMonitored()) {
                                    this.treatActiveAgentWhenSave(tRCAgentProxy);
                                    return false;
                                }
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return true;
    }

    private boolean isResourcesReadOnly(Resource resource) {
        Path path = new Path(resource.getURI().toString());
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        if (iResource != null && iResource.isAccessible()) {
            return iResource.isReadOnly();
        }
        return false;
    }

    private void treatActiveAgentWhenSave(TRCAgentProxy tRCAgentProxy) {
        if (tRCAgentProxy.getAgent() == null) {
            return;
        }
        Resource resource = tRCAgentProxy.getAgent().eResource();
        if (this.processedURIs.contains(resource.getURI())) {
            return;
        }
        this.processedURIs.add(resource.getURI());
        String string = UIPlugin.getResourceString("SAVE_ACTIVE_AGENT_ERROR_");
        string = HyadesUtil.change(string, "%1", tRCAgentProxy.getName());
        if (this.fShell != null) {
            final Status status = new Status(2, "org.eclipse.core.resources", 566, string, null);
            this.fShell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)SaveAction.this.fShell, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("SAVE_FILE_ERROR_TITLE"), (IStatus)status);
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
        this.fResSelection = null;
        this.fResSelections = null;
        this.fShell = null;
        this.fSelections = null;
    }
}

