/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.AbstractListenerActionDelegate;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class TerminateProcessActionDelegate
extends AbstractListenerActionDelegate {
    public void run(Object object, PDProjectExplorer pDProjectExplorer) {
        TRCProcessProxy tRCProcessProxy = null;
        tRCProcessProxy = object instanceof TRCAgentProxy ? ((TRCAgentProxy)object).getProcessProxy() : (TRCProcessProxy)object;
        String string = UIPlugin.getResourceString("TRACE_MSG");
        String string2 = UIPlugin.getResourceString("TERMINATE_Q");
        if (!MessageDialog.openQuestion((Shell)pDProjectExplorer.getShell(), (String)string, (String)string2)) {
            return;
        }
        String string3 = tRCProcessProxy.getNode().getName();
        Node node = PDCoreUtil.profileConnect(string3, String.valueOf(tRCProcessProxy.getNode().getPort()));
        if (node == null) {
            return;
        }
        Process process = node.getProcess(String.valueOf(tRCProcessProxy.getPid()));
        try {
            if (process != null && process.isActive()) {
                node.killProcess(process);
            }
        }
        catch (NotConnectedException notConnectedException) {
            notConnectedException.printStackTrace();
        }
        catch (InactiveProcessException inactiveProcessException) {
            inactiveProcessException.printStackTrace();
        }
        ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
        profileEvent.setSource(tRCProcessProxy);
        profileEvent.setType(16);
        UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
    }

    protected boolean enableForMultiSelection() {
        return false;
    }

    protected boolean isEnabledFor(Object object) {
        return object != null && (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).isActive() || object instanceof TRCProcessProxy && ((TRCProcessProxy)object).isActive());
    }

    public void doAction(Object object) throws Exception {
        if (object == null) {
            return;
        }
        PDProjectExplorer pDProjectExplorer = UIPlugin.getDefault().getViewer();
        if (pDProjectExplorer == null) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)"title", (String)"Action not available in current context");
            return;
        }
        this.run(object, pDProjectExplorer);
    }
}

