/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.console;

import java.util.ResourceBundle;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.console.ConsoleViewerAction;
import org.eclipse.hyades.trace.ui.internal.console.TraceConsoleViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class ConsoleGotoLineAction
extends ConsoleViewerAction {
    protected int fLastLine;
    protected ResourceBundle fBundle;
    protected String fPrefix;
    protected TraceConsoleViewer fConsoleViewer;

    public ConsoleGotoLineAction(ResourceBundle resourceBundle, String string, TraceConsoleViewer traceConsoleViewer) {
        super(resourceBundle, string, traceConsoleViewer, -1);
        this.fBundle = resourceBundle;
        this.fPrefix = string;
        this.fConsoleViewer = traceConsoleViewer;
        WorkbenchHelp.setHelp((IAction)this, (String)(UIPlugin.getPluginId() + ".cgla0000"));
    }

    protected void gotoLine(int n) {
        IDocument iDocument = this.fConsoleViewer.getDocument();
        try {
            int n2 = iDocument.getLineOffset(n);
            int n3 = iDocument.getLineLength(n);
            this.fConsoleViewer.getTextWidget().setSelection(n2);
            this.fConsoleViewer.revealRange(n2, n3);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        try {
            Point point = this.fConsoleViewer.getTextWidget().getSelection();
            IDocument iDocument = this.fConsoleViewer.getDocument();
            this.fLastLine = iDocument.getLineOfOffset(iDocument.getLength()) + 1;
            int n = point == null ? 1 : this.fConsoleViewer.getTextWidget().getLineAtOffset(point.x) + 1;
            String string = this.fBundle.getString(this.fPrefix + "dialog.title");
            String string2 = this.fBundle.getString(this.fPrefix + "dialog.message");
            String string3 = Integer.toString(n);
            Shell shell = UIPlugin.getActiveWorkbenchWindow().getShell();
            InputDialog inputDialog = new InputDialog(shell, string, string2, string3, (IInputValidator)new NumberValidator());
            inputDialog.open();
            try {
                int n2 = Integer.parseInt(inputDialog.getValue());
                this.gotoLine(n2 - 1);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    public void update() {
    }

    class NumberValidator
    implements IInputValidator {
        NumberValidator() {
        }

        public String isValid(String string) {
            try {
                int n = Integer.parseInt(string);
                if (n <= 0 || ConsoleGotoLineAction.this.fLastLine < n) {
                    return ConsoleGotoLineAction.this.fBundle.getString(ConsoleGotoLineAction.this.fPrefix + "dialog.invalid_range");
                }
            }
            catch (NumberFormatException numberFormatException) {
                return ConsoleGotoLineAction.this.fBundle.getString(ConsoleGotoLineAction.this.fPrefix + "dialog.invalid_input");
            }
            return null;
        }
    }
}

