/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.io.File;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceFileUI
implements SelectionListener {
    private Button _sentToFileCheckBox;
    private Label _fileLabel;
    private Text _file;
    private Button _browseLocation;
    private Label _note;

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 2;
        gridLayout.marginHeight = 25;
        gridLayout.verticalSpacing = 6;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.widthHint = 500;
        composite2.setLayoutData((Object)gridData);
        this._sentToFileCheckBox = new Button(composite2, 32);
        this._sentToFileCheckBox.setText(UIPlugin.getResourceString("STR_SEND_TO_FILE"));
        this._sentToFileCheckBox.setToolTipText(UIPlugin.getResourceString("STR_SEND_TO_FILE_TOOPTIP"));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this._sentToFileCheckBox.setLayoutData((Object)gridData);
        this._fileLabel = new Label(composite2, 0);
        this._fileLabel.setText(UIPlugin.getResourceString("PROFILE_FILE"));
        this._file = new Text(composite2, 2048);
        this._file.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._browseLocation = new Button(composite2, 0);
        this._browseLocation.setText(UIPlugin.getResourceString("BROWSE2"));
        this._note = new Label(composite2, 0);
        this._note.setText(UIPlugin.getResourceString("PROFILE_FILE_NOTE"));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this._note.setLayoutData((Object)gridData);
        this._sentToFileCheckBox.addSelectionListener((SelectionListener)this);
        this._browseLocation.addSelectionListener((SelectionListener)this);
        this.initData();
        WorkbenchHelp.setHelp((Control)this._sentToFileCheckBox, (String)(UIPlugin.getPluginId() + ".sttf0000"));
        WorkbenchHelp.setHelp((Control)this._file, (String)(UIPlugin.getPluginId() + ".sttf0001"));
        return composite2;
    }

    public String getFile() {
        return this._file.getText();
    }

    public void setFile(String string) {
        this._file.setText(string);
    }

    public Button getExternalBox() {
        return this._sentToFileCheckBox;
    }

    public Text getFileText() {
        return this._file;
    }

    public boolean getSelection() {
        return this._sentToFileCheckBox.getSelection();
    }

    private void initData() {
        this._sentToFileCheckBox.setSelection(false);
        this.setEnabled(false);
        this._file.setText("");
    }

    public void setEnabled(boolean bl) {
        this._fileLabel.setEnabled(bl);
        this._file.setEnabled(bl);
        this._file.setEditable(bl);
        this._browseLocation.setEnabled(bl);
        this._note.setEnabled(bl);
    }

    public void setVisible(boolean bl) {
        this._sentToFileCheckBox.setVisible(bl);
        this._fileLabel.setVisible(bl);
        this._file.setVisible(bl);
        this._browseLocation.setVisible(bl);
        this._note.setVisible(bl);
    }

    private void showResourceDialog() {
        Shell shell = UIPlugin.getActiveWorkbenchWindow().getShell();
        String string = System.getProperty("os.name");
        FileDialog fileDialog = new FileDialog(shell);
        fileDialog.setFilterExtensions(new String[]{"*.trcxml", "*"});
        fileDialog.open();
        String string2 = fileDialog.getFileName();
        if (string2 != null && !string2.equals("")) {
            if (string2.indexOf(".") < 0) {
                string2 = string2 + ".trcxml";
            }
            String string3 = fileDialog.getFilterPath();
            if (string != null && string.startsWith("Windows") && string3.endsWith(":")) {
                string3 = string3 + "\\";
            }
            this._file.setText(string3 + File.separator + string2);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._sentToFileCheckBox) {
            this.setEnabled(this._sentToFileCheckBox.getSelection());
        } else if (selectionEvent.widget == this._browseLocation) {
            this.showResourceDialog();
        }
    }
}

