/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.text.DateFormat;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceNodeUI {
    protected Text _nodeAddress;
    protected Text _nodeName;
    protected Text _portNumber;
    protected Text _hour;
    protected Text _min;
    protected Text _sec;
    protected Text _micsec;
    protected Group deltaTime;
    private boolean _haveSeperator = true;

    public TraceNodeUI(boolean bl) {
        this._haveSeperator = bl;
    }

    public TraceNodeUI() {
    }

    public Composite createControl(Composite composite) {
        GridData gridData;
        Label label;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 5;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData2 = new GridData();
        gridData2.verticalAlignment = 4;
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.widthHint = 500;
        composite2.setLayoutData((Object)gridData2);
        if (this._haveSeperator) {
            label = new Label(composite2, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            label.setLayoutData((Object)gridData);
        }
        label = new Composite(composite2, 0);
        label.setLayoutData((Object)GridUtil.createHorizontalFill());
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        label.setLayout((Layout)gridLayout);
        gridData = new Label((Composite)label, 0);
        gridData.setText(UIPlugin.getResourceString("NODE_NAME"));
        this._nodeName = new Text((Composite)label, 2052);
        this._nodeName.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label2 = new Label((Composite)label, 0);
        label2.setText(UIPlugin.getResourceString("NODE_ADDRESS"));
        this._nodeAddress = new Text((Composite)label, 2052);
        this._nodeAddress.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label3 = new Label((Composite)label, 0);
        label3.setText(UIPlugin.getResourceString("RAC_PORT_TEXT"));
        this._portNumber = new Text((Composite)label, 2052);
        this._portNumber.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._portNumber.setText(String.valueOf(10002));
        this.deltaTime = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 9;
        gridLayout.verticalSpacing = 5;
        this.deltaTime.setLayout((Layout)gridLayout);
        this.deltaTime.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.deltaTime.setText(UIPlugin.getResourceString("STR_SYNCH_NODE_TIME"));
        Label label4 = new Label((Composite)this.deltaTime, 0);
        label4.setText(UIPlugin.getResourceString("STR_DELTA_TIME"));
        this._hour = new Text((Composite)this.deltaTime, 2048);
        gridData2 = new GridData();
        gridData2.widthHint = 20;
        this._hour.setLayoutData((Object)gridData2);
        this._hour.setTextLimit(3);
        label4 = new Label((Composite)this.deltaTime, 0);
        label4.setText(":");
        this._min = new Text((Composite)this.deltaTime, 2048);
        gridData2 = new GridData();
        gridData2.widthHint = 20;
        this._min.setLayoutData((Object)gridData2);
        this._min.setTextLimit(2);
        label4 = new Label((Composite)this.deltaTime, 0);
        label4.setText(":");
        this._sec = new Text((Composite)this.deltaTime, 2048);
        gridData2 = new GridData();
        gridData2.widthHint = 20;
        this._sec.setLayoutData((Object)gridData2);
        this._sec.setTextLimit(2);
        label4.setText(":");
        this._micsec = new Text((Composite)this.deltaTime, 2048);
        gridData2 = new GridData();
        gridData2.widthHint = 40;
        this._micsec.setLayoutData((Object)gridData2);
        this._micsec.setTextLimit(6);
        label4 = new Label((Composite)this.deltaTime, 0);
        label4.setText(UIPlugin.getResourceString("STR_DELTA_HMS"));
        this._nodeName.setFocus();
        WorkbenchHelp.setHelp((Control)this._nodeAddress, (String)(UIPlugin.getPluginId() + ".nnwp0000"));
        WorkbenchHelp.setHelp((Control)this._nodeName, (String)(UIPlugin.getPluginId() + ".nnwp0001"));
        WorkbenchHelp.setHelp((Control)this._portNumber, (String)(UIPlugin.getPluginId() + ".nnwp0002"));
        WorkbenchHelp.setHelp((Control)this._hour, (String)(UIPlugin.getPluginId() + ".nnwp0003"));
        return composite2;
    }

    public Text getAddressUI() {
        return this._nodeAddress;
    }

    public Text getNodeNameUI() {
        return this._nodeName;
    }

    public Text getPortNumberUI() {
        return this._portNumber;
    }

    public Text getHourUI() {
        return this._hour;
    }

    public Text getMinUI() {
        return this._min;
    }

    public Text getSecUI() {
        return this._sec;
    }

    public Text getMicSecUI() {
        return this._micsec;
    }

    public void setEnabled(boolean bl) {
        this._nodeName.setEnabled(bl);
        this._nodeAddress.setEnabled(bl);
    }

    public double getDeltaTime() {
        int n = 0;
        try {
            n = Integer.parseInt(this._hour.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(this._min.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n3 = 0;
        try {
            n3 = Integer.parseInt(this._sec.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n4 = 0;
        try {
            n4 = Integer.parseInt(this._micsec.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ((double)n * 3600.0 + (double)(n2 * 60) + (double)n3) * 1000000.0 + (double)n4;
    }

    public void setDeltaTime(double d) {
        DateFormat dateFormat = DateFormat.getTimeInstance();
        try {
            int n = (int)(d % 1000000.0);
            int n2 = (int)((d /= 1000000.0) / 3600.0);
            int n3 = (int)(d % 3600.0 / 60.0);
            int n4 = (int)(d % 3600.0 % 60.0);
            this._hour.setText(n2 == 0 ? "" : String.valueOf(n2));
            this._min.setText(n3 == 0 ? "" : String.valueOf(n3));
            this._sec.setText(n4 == 0 ? "" : String.valueOf(n4));
            this._micsec.setText(n == 0 ? "" : String.valueOf(n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setShowDelta(boolean bl) {
        this.deltaTime.setVisible(bl);
    }
}

