/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.piclient;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.DataServerListener;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class XMLTraceDataProcessor
extends XMLLoader
implements DataServerListener {
    private boolean firstEvent = true;
    private File profilingFile = null;
    private FileWriter fileWriter = null;
    private String profileFileName = null;
    private TRCMonitor _monitor;
    private boolean _changed = false;
    private int timeout = 0;
    private String bufStr;
    private final String START_TAG = "<TRACE>";
    private final String END_TAG = "</TRACE>";
    private final String XML_VERSION_TAG = "<?xml version=\"1.0\"?>";
    private final String START_TRACE = "<TRACE>\n";
    private final String END_TRACE = "</TRACE>\n";
    private final String XML_VERSION = "<?xml version=\"1.0\"?>\n";

    public XMLTraceDataProcessor(TRCAgentProxy tRCAgentProxy) {
        super(tRCAgentProxy);
        this.setCollectionMode(tRCAgentProxy.getCollectionMode().getValue());
        new RefreshUI().start();
    }

    public XMLTraceDataProcessor(TRCMonitor tRCMonitor) {
        super(tRCMonitor);
    }

    public void setFileWriter(FileWriter fileWriter) {
        this.fileWriter = fileWriter;
    }

    public FileWriter getFileWriter() {
        return this.fileWriter;
    }

    public void setProfileFileName(String string) {
        this.profileFileName = string;
    }

    public String getProfileFileName() {
        return this.profileFileName;
    }

    public void setProfilingFile(File file) {
        this.profilingFile = file;
    }

    public File getProfilingFile() {
        return this.profilingFile;
    }

    public File createFileWriter() {
        File file = null;
        try {
            if (this.profileFileName != null) {
                file = new File(this.profileFileName);
                this.fileWriter = new FileWriter(this.profileFileName, true);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return file;
    }

    public void dataServerExited() {
        try {
            if (this.getAgentProxy() != null) {
                this.getAgentProxy().setCollectionData(false);
                this.endTrace(this.getFileWriter());
                this.setProfileFileName(null);
                this.setProfilingFile(null);
                this.setFileWriter(null);
                this.cleanUp();
                Display display = Display.getDefault();
                display.asyncExec(new Runnable(){

                    public void run() {
                        ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                        profileEvent.setSource(XMLTraceDataProcessor.this.getAgentProxy());
                        profileEvent.setType(1024);
                        UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        super.cleanUp();
        this.fileWriter = null;
    }

    public void endTrace(FileWriter fileWriter) {
        try {
            if (fileWriter != null) {
                fileWriter.close();
                fileWriter = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isValidTag(String string) {
        return !string.startsWith("<TRACE>") && !string.startsWith("<?xml version=\"1.0\"?>");
    }

    public void incommingData(byte[] byArray, int n, InetAddress inetAddress) {
        this._changed = true;
        try {
            if (this.getAgentProxy() != null && this.getAgentProxy().isToProfileFile()) {
                this.bufStr = new String(byArray, 0, n, "UTF8");
                if (this.isValidTag(this.bufStr)) {
                    this.writeByte(this.bufStr);
                }
            } else {
                if (this.firstEvent) {
                    if (n > 1 && (byArray[0] != 60 || byArray[1] != 63)) {
                        LoadersUtils.loadRootEvent((XMLLoader)this);
                    }
                    this.firstEvent = false;
                }
                super.loadEvent(byArray, n);
            }
        }
        catch (InvalidXMLException invalidXMLException) {
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOutOfMemoryError();
            this.stopAgent();
            throw outOfMemoryError;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void incommingData(char[] cArray, int n, InetAddress inetAddress) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)cArray[n2];
            ++n2;
        }
        try {
            if (this.getAgentProxy() != null && this.getAgentProxy().isToProfileFile()) {
                this.bufStr = new String(byArray, "UTF8");
                if (this.isValidTag(this.bufStr)) {
                    this.writeByte(this.bufStr);
                }
            } else {
                if (this.firstEvent) {
                    if (n > 1 && (cArray[0] != '<' || cArray[1] != '?')) {
                        LoadersUtils.loadRootEvent((XMLLoader)this);
                    }
                    this.firstEvent = false;
                }
                super.loadEvent(byArray, n);
            }
        }
        catch (InvalidXMLException invalidXMLException) {
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.handleOutOfMemoryError();
            this.stopAgent();
            throw outOfMemoryError;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void invalidDataType(byte[] byArray, int n, InetAddress inetAddress) {
    }

    public void waitingForData() {
    }

    public void startTrace(FileWriter fileWriter) {
        try {
            if (this.getAgentProxy() != null) {
                fileWriter.write("<TRACE>\n");
                fileWriter.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeHeader(FileWriter fileWriter) {
    }

    public void writeXMLVersion(FileWriter fileWriter) {
        try {
            fileWriter.write("<?xml version=\"1.0\"?>\n");
            fileWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private TRCAgentProxy getAgentProxy() {
        return this.getContext().getAgentProxy();
    }

    private String getApplicationExecutableString(TRCProcessProxy tRCProcessProxy) {
        String string = "";
        if (tRCProcessProxy.getName() == null) {
            return "";
        }
        if (!tRCProcessProxy.getName().equals("")) {
            string = "java.exe -XrunpiAgent:server=controlled ";
            if (tRCProcessProxy.getClasspath() != null && !tRCProcessProxy.getClasspath().equals("")) {
                string = string + "-cp ";
                string = string + tRCProcessProxy.getClasspath().trim();
                string = string + " ";
            }
            if (tRCProcessProxy.getVmArguments() != null && !tRCProcessProxy.getVmArguments().equals("")) {
                string = string + tRCProcessProxy.getVmArguments().trim();
                string = string + " ";
            }
            string = string + tRCProcessProxy.getName();
            if (tRCProcessProxy.getParameters() != null && !tRCProcessProxy.getParameters().equals("")) {
                string = string + tRCProcessProxy.getParameters();
            }
        }
        return string;
    }

    private void handleOutOfMemoryError() {
        String string = UIPlugin.getResourceString("PROFILE_OUT_OF_MEMORY_ERROR_");
        final Status status = new Status(2, "org.eclipse.core.resources", 566, string, null);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)new Shell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("OUT_OF_MEMORY_ERROR_TITLE"), (IStatus)status);
            }
        });
    }

    private synchronized void notifyListener(Agent agent, TRCAgentProxy tRCAgentProxy) {
        final TRCAgentProxy tRCAgentProxy2 = tRCAgentProxy;
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                profileEvent.setSource(tRCAgentProxy2);
                profileEvent.setType(2);
                UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
            }
        });
    }

    private void stopAgent() {
        if (this.getAgentProxy() != null) {
            try {
                Agent agent = (Agent)LoadersUtils.locateAgentInstance((TRCAgentProxy)this.getAgentProxy());
                if (agent != null) {
                    agent.stopMonitoring();
                }
            }
            catch (InactiveAgentException inactiveAgentException) {
                inactiveAgentException.printStackTrace();
            }
            this.getAgentProxy().setMonitored(false);
            this.getAgentProxy().setAttached(false);
            this.getAgentProxy().setActive(false);
            LoadersUtils.deregisterDataProcessor((TRCAgentProxy)this.getAgentProxy());
            if (this.fileWriter != null) {
                this.endTrace(this.fileWriter);
            }
            this.notifyListener((Agent)LoadersUtils.locateAgentInstance((TRCAgentProxy)this.getAgentProxy()), this.getAgentProxy());
        }
    }

    private void writeAgentCreate(FileWriter fileWriter) throws IOException {
        if (this.getAgentProxy() != null) {
            fileWriter.write("<agentCreate agentId=\"" + this.getAgentProxy().getRuntimeId() + "\" version=\"1.000" + "\" processIdRef=\"" + this.getAgentProxy().getProcessProxy().getRuntimeId() + "\" agentName=\"" + this.getAgentProxy().getName() + "\" agentType=\"" + this.getAgentProxy().getType() + "\" agentParameters=\"" + (this.getAgentProxy().getProcessProxy().getLaunchMode() == 0 ? "server=controlled" : "") + "\" time=\"" + new Date().getTime() / 1000L + "\"/>\n");
            fileWriter.flush();
        }
    }

    private void writeByte(String string) {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.write(string + "\n");
                this.fileWriter.flush();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void writeConfigFilter(EList eList, FileWriter fileWriter) throws IOException {
        if (eList != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                TRCFilter tRCFilter = (TRCFilter)iterator.next();
                String string = tRCFilter.getOperation();
                fileWriter.write("<filter pattern=\"" + tRCFilter.getPattern() + "\" mode=\"" + tRCFilter.getMode() + "\" genericPattern=\"SUFFIX\"/>\n");
                fileWriter.flush();
            }
        }
    }

    private void writeConfigOption(EList eList, FileWriter fileWriter) throws IOException {
        if (eList != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                TRCOption tRCOption = (TRCOption)iterator.next();
                fileWriter.write("<option key=\"" + tRCOption.getKey() + "\" value=\"" + tRCOption.getValue() + "\"/>\n");
                fileWriter.flush();
            }
        }
    }

    private void writeFilter(FileWriter fileWriter) throws IOException {
        if (this.getAgentProxy() != null) {
            EList eList = null;
            EList eList2 = this.getAgentProxy().getConfigurations();
            Iterator iterator = eList2.iterator();
            if (iterator.hasNext()) {
                TRCConfiguration tRCConfiguration = (TRCConfiguration)iterator.next();
                eList = tRCConfiguration.getFilters();
                this.writeConfigFilter(eList, fileWriter);
                return;
            }
            this.writeConfigFilter(eList, fileWriter);
        }
    }

    private void writeNode(FileWriter fileWriter) throws IOException {
        if (this.getAgentProxy() != null) {
            TRCNode tRCNode = this.getAgentProxy().getProcessProxy().getNode();
            if (tRCNode == null) {
                return;
            }
            fileWriter.write("<node nodeId=\"" + this.getAgentProxy().getProcessProxy().getNode().getRuntimeId() + "\" hostname=\"" + tRCNode.getName() + "\" ipaddress=\"" + (tRCNode.getIpAddress() != null ? tRCNode.getIpAddress() : "-Unavailable-") + "\" timezone=\"" + tRCNode.getTimezone() + "\" time=\"" + new Date().getTime() / 1000L + "\"/>\n");
            fileWriter.flush();
        }
    }

    private void writeOption(FileWriter fileWriter) throws IOException {
        EList eList = null;
        EList eList2 = this.getAgentProxy().getConfigurations();
        Iterator iterator = eList2.iterator();
        if (iterator.hasNext()) {
            TRCConfiguration tRCConfiguration = (TRCConfiguration)iterator.next();
            eList = tRCConfiguration.getOptions();
            this.writeConfigOption(eList, fileWriter);
        }
    }

    private void writeProcessCreate(FileWriter fileWriter) throws IOException {
        if (this.getAgentProxy() != null) {
            TRCProcessProxy tRCProcessProxy = this.getAgentProxy().getProcessProxy();
            if (tRCProcessProxy == null) {
                return;
            }
            fileWriter.write("<processCreate processId=\"" + tRCProcessProxy.getRuntimeId() + ("\" pid=\"" + tRCProcessProxy.getPid()) + "\" nodeIdRef=\"" + tRCProcessProxy.getNode().getRuntimeId() + "\" time=\"" + new Date().getTime() / 1000L + "\"" + " application_executable=\"" + this.getApplicationExecutableString(tRCProcessProxy) + "\"/>\n");
            fileWriter.flush();
        }
    }

    private void writeTraceStart(FileWriter fileWriter) throws IOException {
        if (this.getAgentProxy() != null) {
            fileWriter.write("<traceStart traceId=\"" + "\" agentIdRef=\"" + this.getAgentProxy().getRuntimeId() + "\" time=\"\"/>\n");
            fileWriter.flush();
        }
    }

    class RefreshUI
    extends Thread {
        public RefreshUI() {
            super("Profile UI");
        }

        public void run() {
            while (XMLTraceDataProcessor.this.getAgentProxy() != null && XMLTraceDataProcessor.this.getAgentProxy().isActive()) {
                try {
                    Display display;
                    if (XMLTraceDataProcessor.this._changed) {
                        XMLTraceDataProcessor.this._changed = false;
                        if (!XMLTraceDataProcessor.this.getAgentProxy().isCollectionData()) {
                            XMLTraceDataProcessor.this.getAgentProxy().setCollectionData(true);
                            display = Display.getDefault();
                            display.asyncExec(new Runnable(this){
                                private final /* synthetic */ RefreshUI this$1;
                                {
                                    this.this$1 = refreshUI;
                                }

                                public void run() {
                                    ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                                    profileEvent.setSource(XMLTraceDataProcessor.access$000(RefreshUI.access$200(this.this$1)));
                                    profileEvent.setType(512);
                                    UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                                }
                            });
                        }
                    } else if (XMLTraceDataProcessor.this.getAgentProxy().isCollectionData()) {
                        XMLTraceDataProcessor.this.getAgentProxy().setCollectionData(false);
                        display = Display.getDefault();
                        display.asyncExec(new Runnable(this){
                            private final /* synthetic */ RefreshUI this$1;
                            {
                                this.this$1 = refreshUI;
                            }

                            public void run() {
                                ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                                profileEvent.setSource(XMLTraceDataProcessor.access$000(RefreshUI.access$200(this.this$1)));
                                profileEvent.setType(1024);
                                UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                            }
                        });
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ XMLTraceDataProcessor access$200(RefreshUI refreshUI) {
            return refreshUI.XMLTraceDataProcessor.this;
        }
    }
}

