/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.ColorManager;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class TraceConsolePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREFIX = "console_preferences.";
    private static final String DESCRIPTION = "console_preferences.description";
    private static final String OUT = "console_preferences.out";
    private static final String ERR = "console_preferences.err";
    private static final String IN = "console_preferences.in";
    private static final String FONT = "console_preferences.font";

    public TraceConsolePreferencePage() {
        super(1);
        this.setDescription(UIPlugin.getResourceString("STR_COSOLE_PREF_DESCRIPTION"));
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(iPreferenceStore);
    }

    protected Control createContents(Composite composite) {
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".tcpp0000"));
        return super.createContents(composite);
    }

    public void createFieldEditors() {
        ColorFieldEditor colorFieldEditor = new ColorFieldEditor("Console.stdOutColor", UIPlugin.getResourceString(OUT), this.getFieldEditorParent());
        ColorFieldEditor colorFieldEditor2 = new ColorFieldEditor("Console.stdErrColor", UIPlugin.getResourceString(ERR), this.getFieldEditorParent());
        ColorFieldEditor colorFieldEditor3 = new ColorFieldEditor("Console.stdInColor", UIPlugin.getResourceString(IN), this.getFieldEditorParent());
        FontFieldEditor fontFieldEditor = new FontFieldEditor("Console.font", UIPlugin.getResourceString(FONT), this.getFieldEditorParent());
        this.addField((FieldEditor)colorFieldEditor);
        this.addField((FieldEditor)colorFieldEditor2);
        this.addField((FieldEditor)colorFieldEditor3);
        this.addField((FieldEditor)fontFieldEditor);
    }

    public static FontData getConsoleFontData() {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)iPreferenceStore, (String)"Console.font");
        return fontData;
    }

    public static Color getPreferenceColor(String string) {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string);
        ColorManager colorManager = UIPlugin.getDefault().getColorManager();
        return colorManager.getColor(rGB);
    }

    public void init(IWorkbench iWorkbench) {
    }
}

