/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.io.File;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentConfiguration;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessImpl;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.local.control.Variable;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.security.util.ConnectUtil;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.console.ConsoleDataProcessor;
import org.eclipse.hyades.trace.ui.internal.core.EnvTableElement;
import org.eclipse.hyades.trace.ui.internal.piclient.PIAttachListener;
import org.eclipse.hyades.trace.ui.internal.piclient.PIProcessListener;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.ui.internal.util.TraceArguments;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class PDCoreUtil {
    private static void addDefaultProfileData(IPreferenceStore iPreferenceStore, Agent agent, TraceArguments traceArguments, ArrayList arrayList) {
        AgentConfiguration agentConfiguration = agent.getConfiguration();
        int n = 0;
        while (n < arrayList.size()) {
            FilterTableElement filterTableElement = (FilterTableElement)arrayList.get(n);
            AgentConfigurationEntry agentConfigurationEntry = new AgentConfigurationEntry();
            if (filterTableElement.getMethod().equals("")) {
                agentConfigurationEntry.setName(filterTableElement.getText());
                agentConfigurationEntry.setType("SETFILTER");
            } else {
                agentConfigurationEntry.setName(filterTableElement.getText() + ' ' + filterTableElement.getMethod());
                agentConfigurationEntry.setType("SETMETHODFILTER");
            }
            agentConfigurationEntry.setValue(filterTableElement.getVisibility());
            agentConfigurationEntry.setEnabled(true);
            agentConfiguration.addEntry(agentConfigurationEntry);
            ++n;
        }
    }

    private static void addDefaultOptionsData(IPreferenceStore iPreferenceStore, Agent agent, TraceArguments traceArguments, Vector vector) {
        AgentConfiguration agentConfiguration = agent.getConfiguration();
        int n = 0;
        while (n < vector.size()) {
            agentConfiguration.addEntry((AgentConfigurationEntry)vector.elementAt(n));
            ++n;
        }
    }

    public static final Vector attach(String string, Vector vector, String string2, String string3) {
        return PDCoreUtil.attach(string, vector, string2, string3, "10002", null);
    }

    public static final Vector attach(String string, Vector vector, String string2, String string3, String string4, String string5) {
        Node node;
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        try {
            UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            node = NodeFactory.createNode((String)string);
            string = node.getInetAddress().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        node = PDCoreUtil.createContainer((IPath)new Path(string2));
        TRCMonitor tRCMonitor = PDCoreUtil.createMonitor((IContainer)node, string3);
        TRCNode tRCNode = PDCoreUtil.createNode(tRCMonitor, string, string4);
        TRCProcessProxy tRCProcessProxy = null;
        Vector<ConsoleDataProcessor> vector2 = new Vector<ConsoleDataProcessor>();
        int n = 0;
        while (n < vector.size()) {
            ConsoleDataProcessor consoleDataProcessor;
            Agent agent = (Agent)vector.elementAt(n);
            Process process = agent.getProcess();
            tRCProcessProxy = PDCoreUtil.createProcess(tRCNode, process);
            if (process.getConsole().getDataProcessor() == null) {
                consoleDataProcessor = new ConsoleDataProcessor(tRCProcessProxy);
                consoleDataProcessor.setConsole(process.getConsole());
            }
            try {
                consoleDataProcessor = PDCoreUtil.createAgent(tRCProcessProxy, agent);
                PIProcessListener pIProcessListener = (PIProcessListener)LoadersUtils.locateAgentListener((TRCAgentProxy)consoleDataProcessor);
                if (pIProcessListener == null) {
                    pIProcessListener = new PIAttachListener(tRCNode, tRCProcessProxy);
                    LoadersUtils.registerAgentListener((TRCAgentProxy)consoleDataProcessor, (Object)pIProcessListener);
                }
                pIProcessListener.monitor(true);
                pIProcessListener.setLaunchMode(0);
                agent.addAgentListener((AgentListener)pIProcessListener);
                agent.attach();
                vector2.add(consoleDataProcessor);
                ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                profileEvent.setSource(consoleDataProcessor);
                profileEvent.setType(4);
                UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
                if (n == 0 && string5 != null && !string5.equals("")) {
                    consoleDataProcessor.setProfileFile(string5);
                    agent.setProfileFile(consoleDataProcessor.getProfileFile());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        return vector2;
    }

    public static TRCAgentProxy createAgent(TRCProcessProxy tRCProcessProxy, Agent agent) {
        String string;
        TRCAgentProxy tRCAgentProxy = null;
        String string2 = agent.getName();
        EList eList = tRCProcessProxy.getAgentProxies();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            tRCAgentProxy = (TRCAgentProxy)iterator.next();
            if (tRCAgentProxy.eIsProxy() || !tRCAgentProxy.getName().equals(string2)) continue;
            return tRCAgentProxy;
        }
        String string3 = string = DateFormat.getDateTimeInstance(0, 0).format(new Date());
        string3 = TString.change(string3, " ", "");
        string3 = TString.change(string3, ":", "");
        String string4 = tRCProcessProxy.getNode().getMonitor().getName() + "_" + tRCProcessProxy.getNode().getName() + "_" + tRCProcessProxy.getPid() + "_" + string3 + "_" + string2;
        string4 = TString.change(string4, " ", "");
        String string5 = tRCProcessProxy.eResource().getURI().toString();
        Path path = new Path(string5);
        if (path.segmentCount() > 1) {
            string5 = path.removeLastSegments(1).toString();
        }
        String string6 = string4 + "." + "trcaxmi";
        IPath iPath = new Path(string5).append(string6);
        URI uRI = URI.createURI((String)iPath.toString());
        Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(uRI).createResource(uRI);
        EList eList2 = resource.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add(resource);
        HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
        tRCAgentProxy = hierarchyFactory.createTRCAgentProxy();
        tRCAgentProxy.setName(string2);
        if (agent.getType() != null) {
            tRCAgentProxy.setType(agent.getType());
        }
        tRCAgentProxy.setProcessProxy(tRCProcessProxy);
        TRCAgent tRCAgent = hierarchyFactory.createTRCAgent();
        tRCAgent.setAgentProxy(tRCAgentProxy);
        eList2.add(tRCAgent);
        SaveUtil.addDocument((Resource)resource);
        if (tRCAgentProxy.getType().equals("Profiler")) {
            if (tRCAgentProxy.getName().equals("J2EE Request Profiler")) {
                tRCAgentProxy.setCollectionMode(TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL);
            } else {
                TRCConfiguration tRCConfiguration = hierarchyFactory.createTRCConfiguration();
                tRCConfiguration.setName(UIPlugin.getDefault().getPluginPreferences().getString("filter_name"));
                tRCConfiguration.setActive(true);
                tRCConfiguration.setAgentProxy(tRCAgentProxy);
                tRCAgentProxy.getConfigurations().add(tRCConfiguration);
                AgentConfiguration agentConfiguration = agent.getConfiguration();
                boolean bl = false;
                boolean bl2 = false;
                if (agentConfiguration != null) {
                    int n = 0;
                    while (n < agentConfiguration.size()) {
                        Object object;
                        AgentConfigurationEntry agentConfigurationEntry = agentConfiguration.getEntryAt(n);
                        if (agentConfigurationEntry.getType().equals("SETFILTER")) {
                            object = hierarchyFactory.createTRCFilter();
                            object.setMode(agentConfigurationEntry.getValue());
                            object.setOperation("");
                            object.setPattern(agentConfigurationEntry.getName());
                            object.setType(agentConfigurationEntry.getValue());
                            object.setActive(new Boolean(agentConfigurationEntry.isEnabled()));
                            object.setConfiguration(tRCConfiguration);
                        } else if (agentConfigurationEntry.getType().equals("SETMETHODFILTER")) {
                            object = agentConfigurationEntry.getName();
                            int n2 = ((String)object).indexOf(32);
                            if (n2 > 0) {
                                TRCFilter tRCFilter = hierarchyFactory.createTRCFilter();
                                tRCFilter.setMode(agentConfigurationEntry.getValue());
                                tRCFilter.setPattern(((String)object).substring(0, n2));
                                tRCFilter.setOperation(((String)object).substring(n2 + 1, ((String)object).length()));
                                tRCFilter.setType(agentConfigurationEntry.getValue());
                                tRCFilter.setActive(new Boolean(agentConfigurationEntry.isEnabled()));
                                tRCFilter.setConfiguration(tRCConfiguration);
                            }
                        } else if (agentConfigurationEntry.getType().equals("SETOPTION")) {
                            object = hierarchyFactory.createTRCOption();
                            object.setKey(agentConfigurationEntry.getName());
                            object.setValue(agentConfigurationEntry.getValue());
                            object.setConfiguration(tRCConfiguration);
                            if (agentConfigurationEntry.getName().equals("TRACE_MODE")) {
                                bl = agentConfigurationEntry.getValue().equals("default");
                            }
                            if (agentConfigurationEntry.getName().equals("STACK_INFORMATION")) {
                                bl2 = !agentConfigurationEntry.getValue().equals("none");
                            }
                        }
                        ++n;
                    }
                }
                IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
                if (bl2) {
                    if (bl) {
                        if (iPreferenceStore.getBoolean("prof_exec_stat")) {
                            if (iPreferenceStore.getBoolean("prof_heap_inst")) {
                                tRCAgentProxy.setCollectionMode(TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL);
                            } else {
                                tRCAgentProxy.setCollectionMode(TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL);
                            }
                        } else {
                            tRCAgentProxy.setCollectionMode(TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL);
                        }
                    } else if (iPreferenceStore.getBoolean("prof_exec_stat")) {
                        tRCAgentProxy.setCollectionMode(TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL);
                    } else {
                        tRCAgentProxy.setCollectionMode(TRCCollectionMode.EXECUTION_FULL_LITERAL);
                    }
                } else if (iPreferenceStore.getBoolean("prof_heap_inst")) {
                    tRCAgentProxy.setCollectionMode(TRCCollectionMode.HEAP_FULL_LITERAL);
                } else {
                    tRCAgentProxy.setCollectionMode(TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL);
                }
            }
        }
        if (tRCAgentProxy.getAgent() != null) {
            tRCAgentProxy.getAgent().setCollectionMode(tRCAgentProxy.getCollectionMode());
        }
        tRCAgent.setName(tRCAgentProxy.getName());
        tRCAgent.setRuntimeId(tRCAgentProxy.getRuntimeId());
        tRCAgent.setType(tRCAgentProxy.getType());
        tRCAgent.setCollectionMode(tRCAgentProxy.getCollectionMode());
        return tRCAgentProxy;
    }

    public static final IContainer createContainer(IPath iPath) {
        IFolder iFolder = null;
        IWorkspace iWorkspace = UIPlugin.getPluginWorkbench();
        int n = iPath.segmentCount();
        int n2 = 0;
        while (n2 < n) {
            IFolder iFolder2;
            String string = iPath.segment(n2);
            if (n2 == 0) {
                iFolder2 = iWorkspace.getRoot().getProject(iPath.uptoSegment(n2 + 1).toString());
                if (iFolder2 == null || !iFolder2.exists()) {
                    try {
                        iFolder2.create(null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                try {
                    iFolder2.open(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iFolder = iFolder2;
            } else {
                iFolder2 = iWorkspace.getRoot().getFolder(iPath.uptoSegment(n2 + 1));
                if (iFolder2 == null || !iFolder2.exists()) {
                    try {
                        iFolder2.create(false, true, null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                iFolder = iFolder2;
            }
            ++n2;
        }
        try {
            iFolder.getProject().refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iFolder;
    }

    public static final TRCMonitor createMonitor(IContainer iContainer, String string) {
        Object object;
        IWorkspace iWorkspace = iContainer.getWorkspace();
        TRCMonitor tRCMonitor = null;
        ArrayList arrayList = PDContentProvider.getMonitors(iContainer);
        int n = 0;
        while (n < arrayList.size()) {
            object = arrayList.get(n);
            if (object instanceof TRCMonitor && ((TRCMonitor)object).getName().equals(string)) {
                return (TRCMonitor)object;
            }
            ++n;
        }
        object = TString.change(string, " ", "");
        String string2 = object + "." + "trcmxmi";
        IPath iPath = iContainer.getFullPath().append(string2);
        URI uRI = URI.createURI((String)("platform:/resource" + iPath.toString()));
        Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(uRI).createResource(uRI);
        EList eList = resource.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add(resource);
        HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
        tRCMonitor = hierarchyFactory.createTRCMonitor();
        tRCMonitor.setName(string);
        SaveUtil.addDocument((Resource)resource);
        eList.add(tRCMonitor);
        PDContentProvider.addMonitor((IResource)iContainer, tRCMonitor);
        return tRCMonitor;
    }

    public static final TRCNode createNode(TRCMonitor tRCMonitor, String string, String string2) {
        TRCNode tRCNode;
        Object[] objectArray;
        String string3 = "";
        try {
            objectArray = NodeFactory.createNode((String)string);
            string = objectArray.getInetAddress().getHostName();
            string3 = objectArray.getInetAddress().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        objectArray = tRCMonitor.getNodes().toArray();
        int n = 0;
        while (n < objectArray.length) {
            tRCNode = (TRCNode)objectArray[n];
            if (!tRCNode.eIsProxy() && tRCNode.getName().equals(string)) {
                tRCNode.setPort(Integer.parseInt(string2));
                return tRCNode;
            }
            ++n;
        }
        tRCNode = null;
        String string4 = TString.change(tRCMonitor.getName(), " ", "") + "_" + TString.change(string, " ", "");
        String string5 = string4 + "." + "trcnxmi";
        String string6 = tRCMonitor.eResource().getURI().toString();
        Path path = new Path(string6);
        if (path.segmentCount() > 1) {
            string6 = path.removeLastSegments(1).toString();
        }
        IPath iPath = new Path(string6).append(string5);
        URI uRI = URI.createURI((String)iPath.toString());
        Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(uRI).createResource(uRI);
        EList eList = resource.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add(resource);
        HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
        tRCNode = hierarchyFactory.createTRCNode();
        tRCNode.setName(string);
        tRCNode.setIpAddress(string3);
        tRCNode.setMonitor(tRCMonitor);
        tRCNode.setPort(Integer.parseInt(string2));
        eList.add(tRCNode);
        SaveUtil.addDocument((Resource)resource);
        EList eList2 = tRCMonitor.getNodes();
        try {
            eList2.add(tRCNode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return tRCNode;
    }

    public static TRCProcessProxy createProcess(TRCNode tRCNode, Process process) {
        try {
            String string;
            Object object;
            TRCProcessProxy tRCProcessProxy = null;
            EList eList = tRCNode.getProcessProxies();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                tRCProcessProxy = (TRCProcessProxy)iterator.next();
                if (tRCProcessProxy.eIsProxy() || !String.valueOf(tRCProcessProxy.getPid()).equals(process.getProcessId())) continue;
                if (tRCProcessProxy.getRuntimeId() != null && tRCProcessProxy.getRuntimeId().equals(process.getUUID())) {
                    return tRCProcessProxy;
                }
                object = tRCProcessProxy.getAgentProxies().iterator();
                while (object.hasNext()) {
                    string = (TRCAgentProxy)object.next();
                    if (string.eIsProxy() || !string.isActive()) continue;
                    return tRCProcessProxy;
                }
            }
            object = tRCNode.getMonitor();
            string = new Date().toString();
            string = TString.change(string, " ", "");
            string = TString.change(string, ":", "");
            String string2 = object.getName() + "_" + tRCNode.getName() + "_" + process.getProcessId() + "_" + string;
            String string3 = string2 + "." + "trcpxmi";
            String string4 = tRCNode.eResource().getURI().toString();
            Path path = new Path(string4);
            if (path.segmentCount() > 1) {
                string4 = path.removeLastSegments(1).toString();
            }
            IPath iPath = new Path(string4).append(string3);
            URI uRI = URI.createURI((String)iPath.toString());
            Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(uRI).createResource(uRI);
            EList eList2 = resource.getContents();
            UIPlugin.getDefault().getResourceSet().getResources().add(resource);
            SaveUtil.addDocument((Resource)resource);
            HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
            tRCProcessProxy = hierarchyFactory.createTRCProcessProxy();
            tRCProcessProxy.setPid(Integer.parseInt(process.getProcessId()));
            tRCProcessProxy.setRuntimeId(process.getUUID());
            if (process.getName() != null) {
                tRCProcessProxy.setName(process.getName());
            } else {
                tRCProcessProxy.setName(process.getExecutable());
            }
            tRCProcessProxy.setLocation(((ProcessImpl)process).getlocation());
            tRCProcessProxy.setActive(true);
            tRCProcessProxy.setLaunchMode(0);
            tRCProcessProxy.setNode(tRCNode);
            eList2.add(tRCProcessProxy);
            return tRCProcessProxy;
        }
        catch (InactiveProcessException inactiveProcessException) {
            inactiveProcessException.printStackTrace();
            return null;
        }
    }

    public static void detachAgents() {
        Hashtable hashtable = SaveUtil.getDocuments();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Resource resource = (Resource)enumeration.nextElement();
            EList eList = resource.getContents();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                TRCAgentProxy tRCAgentProxy;
                TRCProcessProxy tRCProcessProxy;
                Object e = iterator.next();
                if (!(e instanceof TRCAgentProxy) || (tRCProcessProxy = (tRCAgentProxy = (TRCAgentProxy)e).getProcessProxy()) == null || !tRCProcessProxy.isActive() || !tRCAgentProxy.isActive()) continue;
                try {
                    Agent agent;
                    Object object;
                    String string = tRCProcessProxy.getNode().getName();
                    Node node = NodeFactory.createNode((String)string);
                    if (!node.isConnected() || (object = LoadersUtils.locateAgentInstance((TRCAgentProxy)tRCAgentProxy)) == null || !(object instanceof Agent) || (agent = (Agent)object) == null || !agent.isAttached()) continue;
                    agent.detach();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static final boolean launchTrace(TraceArguments traceArguments, ArrayList arrayList, Vector vector, String string, String string2) {
        if (traceArguments.getProcess() != null && traceArguments.getAgent() == null) {
            return PDCoreUtil.launchTrace(traceArguments.getProcess());
        }
        if (traceArguments.getProcess() != null && traceArguments.getAgent() != null) {
            return PDCoreUtil.launchTrace(traceArguments.getAgent());
        }
        try {
            UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        try {
            Object object;
            String string3;
            String string4 = traceArguments.getHostName();
            Node node = PDCoreUtil.profileConnect(string4, String.valueOf(traceArguments.getPortNumber()));
            if (node == null) {
                return false;
            }
            string4 = node.getName();
            IContainer iContainer = PDCoreUtil.createContainer((IPath)new Path(string));
            TRCMonitor tRCMonitor = PDCoreUtil.createMonitor(iContainer, string2);
            TRCNode tRCNode = PDCoreUtil.createNode(tRCMonitor, string4, String.valueOf(traceArguments.getPortNumber()));
            PIProcessListener pIProcessListener = new PIProcessListener(tRCNode);
            pIProcessListener.monitor(true);
            Process process = ProcessFactory.createProcess((Node)node);
            process.setLocation(traceArguments.getLocation());
            process.addProcessListener((ProcessListener)pIProcessListener);
            pIProcessListener.setLaunchMode(1);
            boolean bl = false;
            if (iPreferenceStore.getBoolean("log_option") && (string3 = iPreferenceStore.getString("log_agents")) != null && !string3.equals("")) {
                int n = 0;
                while (n != -1) {
                    String string5;
                    n = string3.indexOf(",");
                    if (n != -1) {
                        string5 = string3.substring(0, n);
                        object = AgentFactory.createAgent((Process)process, (String)string5, (String)"Logging");
                        object.addAgentListener((AgentListener)pIProcessListener);
                        object.setAutoAttach(true);
                        string3 = string3.substring(n + 1);
                        continue;
                    }
                    string5 = AgentFactory.createAgent((Process)process, (String)string3, (String)"Logging");
                    string5.addAgentListener((AgentListener)pIProcessListener);
                    string5.setAutoAttach(true);
                }
            }
            if (iPreferenceStore.getBoolean("prof_option")) {
                bl = true;
                string3 = AgentFactory.createAgent((Process)process, (String)"Java Profiling Agent", (String)"Profiler");
                string3.addAgentListener((AgentListener)pIProcessListener);
                string3.setAutoAttach(true);
                AgentConfiguration agentConfiguration = string3.getConfiguration();
                if (agentConfiguration == null) {
                    string3.setConfiguration(new AgentConfiguration());
                }
                string3.getConfiguration().clear();
                if (traceArguments.isToProfileFile()) {
                    string3.setProfileFile(traceArguments.getProfileFile());
                }
                PDCoreUtil.addDefaultProfileData(iPreferenceStore, (Agent)string3, traceArguments, arrayList);
                PDCoreUtil.addDefaultOptionsData(iPreferenceStore, (Agent)string3, traceArguments, vector);
            }
            string3 = traceArguments.getClassName();
            if (traceArguments.getVMArguments() != null && !traceArguments.getVMArguments().equals("")) {
                string3 = traceArguments.getVMArguments() + " " + string3;
            }
            if (traceArguments.getParameters() != null && !traceArguments.getParameters().equals("")) {
                string3 = string3 + " " + traceArguments.getParameters();
            }
            String string6 = "";
            if (!bl) {
                string6 = string3;
            }
            if (bl) {
                process.setExecutable("java.exe");
                string6 = "-XrunpiAgent:server=controlled " + string3;
            } else {
                process.setExecutable("java.exe");
                string6 = string3;
            }
            process.setParameters(string6);
            process.addEnvironmentVariable(new Variable("CLASSPATH", TString.stripNewLineChar(traceArguments.getClassPath())));
            process.addEnvironmentVariable(new Variable("UICLASSPATH", traceArguments.getClassPath()));
            pIProcessListener.getProcessVariableList().add(new Variable("UICLASSPATH", traceArguments.getClassPath()));
            PDCoreUtil.setEnvironmentVariable(process, traceArguments.getEnvironmentVariable().toArray(), pIProcessListener);
            try {
                process.launch();
            }
            catch (Exception exception) {
                object = UIPlugin.getResourceString("PROCESS_LAUNCH_ERROR_");
                object = TString.change((String)object, "%1", traceArguments.getClassName());
                String string7 = UIPlugin.getResourceString("PROCESS_LAUNCH_ERRTEXT_INFO_");
                Status status = new Status(2, "org.eclipse.core.resources", 566, string7, null);
                ErrorDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)object, (IStatus)status);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    private static final boolean launchTrace(TRCAgentProxy tRCAgentProxy) {
        try {
            UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TRCProcessProxy tRCProcessProxy = tRCAgentProxy.getProcessProxy();
        TRCNode tRCNode = tRCProcessProxy.getNode();
        String string = tRCAgentProxy.getType();
        try {
            String string2 = "";
            String string3 = tRCNode.getName();
            Node node = PDCoreUtil.profileConnect(string3, String.valueOf(tRCNode.getPort()));
            if (node == null) {
                return false;
            }
            string3 = node.getName();
            Process process = ProcessFactory.createProcess((Node)node);
            process.setLocation(tRCProcessProxy.getLocation());
            PIProcessListener pIProcessListener = new PIProcessListener(tRCNode);
            pIProcessListener.monitor(true);
            process.addProcessListener((ProcessListener)pIProcessListener);
            pIProcessListener.setLaunchMode(1);
            String string4 = tRCProcessProxy.getName();
            if (tRCProcessProxy.getVmArguments() != null && !tRCProcessProxy.getVmArguments().equals("")) {
                string4 = tRCProcessProxy.getVmArguments() + " " + string4;
            }
            if (tRCProcessProxy.getParameters() != null && !tRCProcessProxy.getParameters().equals("")) {
                string4 = string4 + " " + tRCProcessProxy.getParameters();
            }
            if (string.equals("Logging")) {
                string2 = string4;
            } else {
                string2 = "-XrunpiAgent:server=controlled " + string4;
                process.setExecutable("java.exe");
            }
            process.setParameters(string2);
            process.addEnvironmentVariable(new Variable("CLASSPATH", TString.stripNewLineChar(tRCProcessProxy.getClasspath())));
            process.addEnvironmentVariable(new Variable("UICLASSPATH", tRCProcessProxy.getClasspath()));
            pIProcessListener.getProcessVariableList().add(new Variable("UICLASSPATH", tRCProcessProxy.getClasspath()));
            PDCoreUtil.setEnvironmentVariable(process, tRCProcessProxy.getEnvironmentVariables().toArray(), pIProcessListener);
            PDCoreUtil.setAgent(tRCAgentProxy, process, pIProcessListener);
            try {
                process.launch();
            }
            catch (Exception exception) {
                String string5 = UIPlugin.getResourceString("PROCESS_LAUNCH_ERROR_");
                string5 = TString.change(string5, "%1", tRCProcessProxy.getName());
                String string6 = UIPlugin.getResourceString("PROCESS_LAUNCH_ERRTEXT_INFO_");
                Status status = new Status(2, "org.eclipse.core.resources", 566, string6, null);
                ErrorDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)string5, (IStatus)status);
                return true;
            }
            UIPlugin.getDefault().getTraceManager().registerTrace(tRCAgentProxy, "trace_launch");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    private static final boolean launchTrace(TRCProcessProxy tRCProcessProxy) {
        try {
            UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TRCNode tRCNode = tRCProcessProxy.getNode();
        Object[] objectArray = tRCProcessProxy.getAgentProxies().toArray();
        try {
            String string = "";
            String string2 = tRCNode.getName();
            Node node = PDCoreUtil.profileConnect(string2, String.valueOf(tRCNode.getPort()));
            if (node == null) {
                return false;
            }
            string2 = node.getName();
            Process process = ProcessFactory.createProcess((Node)node);
            process.setLocation(tRCProcessProxy.getLocation());
            PIProcessListener pIProcessListener = new PIProcessListener(tRCNode);
            pIProcessListener.monitor(true);
            pIProcessListener.setLaunchMode(tRCProcessProxy.getLaunchMode());
            pIProcessListener.setLaunchMode(1);
            process.addProcessListener((ProcessListener)pIProcessListener);
            String string3 = tRCProcessProxy.getName();
            if (tRCProcessProxy.getVmArguments() != null && !tRCProcessProxy.getVmArguments().equals("")) {
                string3 = tRCProcessProxy.getVmArguments() + " " + string3;
            }
            if (tRCProcessProxy.getParameters() != null && !tRCProcessProxy.getParameters().equals("")) {
                string3 = string3 + " " + tRCProcessProxy.getParameters();
            }
            boolean bl = false;
            int n = 0;
            while (n < objectArray.length) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)objectArray[n];
                if (!tRCAgentProxy.eIsProxy()) {
                    if (tRCAgentProxy.getType().equals("Profiler")) {
                        bl = true;
                    }
                    PDCoreUtil.setAgent(tRCAgentProxy, process, pIProcessListener);
                }
                ++n;
            }
            if (!bl) {
                string = string3;
            }
            string = "-XrunpiAgent:server=controlled " + string3;
            process.setExecutable("java.exe");
            process.setParameters(string);
            process.addEnvironmentVariable(new Variable("CLASSPATH", TString.stripNewLineChar(tRCProcessProxy.getClasspath())));
            process.addEnvironmentVariable(new Variable("UICLASSPATH", tRCProcessProxy.getClasspath()));
            pIProcessListener.getProcessVariableList().add(new Variable("UICLASSPATH", tRCProcessProxy.getClasspath()));
            PDCoreUtil.setEnvironmentVariable(process, tRCProcessProxy.getEnvironmentVariables().toArray(), pIProcessListener);
            try {
                process.launch();
            }
            catch (Exception exception) {
                String string4 = UIPlugin.getResourceString("PROCESS_LAUNCH_ERROR_");
                string4 = TString.change(string4, "%1", tRCProcessProxy.getName());
                String string5 = UIPlugin.getResourceString("PROCESS_LAUNCH_ERRTEXT_INFO_");
                Status status = new Status(2, "org.eclipse.core.resources", 566, string5, null);
                ErrorDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)string4, (IStatus)status);
                return true;
            }
            UIPlugin.getDefault().getTraceManager().registerTrace(tRCProcessProxy, "trace_launch");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public static void setAgentConfiguration(TRCAgentProxy tRCAgentProxy, Agent agent) {
        Object[] objectArray;
        AgentConfiguration agentConfiguration = agent.getConfiguration();
        agentConfiguration.clear();
        if (tRCAgentProxy.getType().equals("Profiler") && (objectArray = tRCAgentProxy.getConfigurations().toArray()).length > 0) {
            TRCFilter tRCFilter;
            TRCConfiguration tRCConfiguration = (TRCConfiguration)objectArray[0];
            Vector vector = new Vector();
            Object[] objectArray2 = tRCConfiguration.getFilters().toArray();
            int n = 0;
            while (n < objectArray2.length) {
                tRCFilter = (TRCFilter)objectArray2[n];
                if (tRCFilter.getActive().booleanValue()) {
                    AgentConfigurationEntry agentConfigurationEntry = new AgentConfigurationEntry();
                    if (tRCFilter.getOperation().equals("") || tRCFilter.getOperation().equals("\"\"")) {
                        agentConfigurationEntry.setName(tRCFilter.getPattern());
                        agentConfigurationEntry.setType("SETFILTER");
                        agentConfigurationEntry.setValue(tRCFilter.getMode());
                        agentConfigurationEntry.setEnabled(tRCFilter.getActive().booleanValue());
                    } else {
                        agentConfigurationEntry.setName(tRCFilter.getPattern() + ' ' + tRCFilter.getOperation());
                        agentConfigurationEntry.setType("SETMETHODFILTER");
                        agentConfigurationEntry.setValue(tRCFilter.getMode());
                        agentConfigurationEntry.setEnabled(tRCFilter.getActive().booleanValue());
                    }
                    agentConfiguration.addEntry(agentConfigurationEntry);
                }
                ++n;
            }
            tRCFilter = tRCConfiguration.getOptions().toArray();
            int n2 = 0;
            while (n2 < ((TRCFilter)tRCFilter).length) {
                TRCOption tRCOption = (TRCOption)tRCFilter[n2];
                AgentConfigurationEntry agentConfigurationEntry = new AgentConfigurationEntry();
                agentConfigurationEntry.setType("SETOPTION");
                agentConfigurationEntry.setName(tRCOption.getKey());
                agentConfigurationEntry.setValue(tRCOption.getValue());
                agentConfiguration.addEntry(agentConfigurationEntry);
                ++n2;
            }
        }
    }

    private static void setAgent(TRCAgentProxy tRCAgentProxy, Process process, PIProcessListener pIProcessListener) {
        Agent agent = AgentFactory.createAgent((Process)process, (String)tRCAgentProxy.getName(), (String)tRCAgentProxy.getType());
        agent.addAgentListener((AgentListener)pIProcessListener);
        PDCoreUtil.setAgentConfiguration(tRCAgentProxy, agent);
    }

    public static Enumeration getNodeConfiguration(String string, int n) {
        try {
            Node node = PDCoreUtil.profileConnect(string, String.valueOf(n));
            if (node == null) {
                return null;
            }
            return node.listProcesses();
        }
        catch (NotConnectedException notConnectedException) {
            notConnectedException.printStackTrace();
            return null;
        }
    }

    public static Node profileConnect(String string, String string2) {
        String string3 = "";
        if (string == null || string.trim() == "" || string2 == null || string2.trim() == "") {
            string3 = UIPlugin.getResourceString("INVALID_HOST");
            Status status = new Status(2, "org.eclipse.core.resources", 2, string3, null);
            ErrorDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("CONNECTION_FAIL_TEXT"), (IStatus)status);
            return null;
        }
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        ConnectUtil connectUtil = new ConnectUtil(string, string2, iPreferenceStore.getString("user_id"), (Application)UIPlugin.getDefault());
        int n = connectUtil.connect();
        if (n == 0) {
            iPreferenceStore.setValue("user_id", connectUtil.getUserId());
            return connectUtil.getNode();
        }
        return null;
    }

    public static String getDirectoryName(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static boolean isPathExists(String string) {
        File file = new File(PDCoreUtil.getDirectoryName(string));
        return file.exists();
    }

    public static boolean createDirectoryMessage(String string, Shell shell) {
        File file = new File(PDCoreUtil.getDirectoryName(string));
        String string2 = UIPlugin.getResourceString("STR_FOLDER_CREATION_MSG");
        string2 = TString.change(string2, "%1", file.getPath());
        if (!MessageDialog.openQuestion((Shell)shell, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)string2)) {
            return false;
        }
        if (!file.mkdirs()) {
            String string3 = UIPlugin.getResourceString("STR_ERROR_FOLDER_CREATION");
            MessageDialog.openError((Shell)shell, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)string3);
            return false;
        }
        return true;
    }

    private static void setEnvironmentVariable(Process process, Object[] objectArray, PIProcessListener pIProcessListener) {
        if (objectArray == null || process == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            EnvTableElement envTableElement = (EnvTableElement)objectArray[n];
            try {
                process.addEnvironmentVariable(new Variable(envTableElement.name(), envTableElement.value()));
                pIProcessListener.getProcessVariableList().add(new Variable(envTableElement.name(), envTableElement.value()));
            }
            catch (Exception exception) {
                System.out.println("Error adding environment variable " + envTableElement.name());
            }
            ++n;
        }
    }
}

