/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentConfiguration;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.DoubleCTree;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.wizard.AttachLocalWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.help.WorkbenchHelp;

public class AttachLocalPage
extends WizardPage
implements SelectionListener,
ModifyListener,
IRunnableWithProgress {
    private DoubleCTree _list;
    private boolean _initialized = false;
    private Button _refresh;
    private boolean status = true;
    private Button _showProcess;
    private boolean fShowAll = false;
    private boolean _validPort = false;
    private String _selectedProject;
    private String _sourceLabel = UIPlugin.getResourceString("STR_LIST_SOURCE");
    private String _targetLabel = UIPlugin.getResourceString("STR_LIST_TARGET");
    private String _selectedMonitor;
    private String _profileFile;

    public AttachLocalPage(String string) {
        super(string);
        this.setTitle(UIPlugin.getResourceString("AGENT_WIZARD_TITLE"));
        this.setDescription(UIPlugin.getResourceString("AGENT_WIZARD_DSCP"));
        this.setImageDescriptor(UIPlugin.getImageDescriptor("attach_wiz.gif"));
    }

    public void setDoubleTreeLabel(String string, String string2) {
        this._sourceLabel = string;
        this._targetLabel = string2;
    }

    public DoubleCTree getList() {
        return this._list;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createFill());
        this._list = new DoubleCTree(composite2, 0, UIPlugin.getResourceString("STR_LIST_AGENTS"), this._sourceLabel, this._targetLabel);
        this._list.setWizardPage(this);
        this._refresh = new Button(composite2, 8);
        this._refresh.setText(UIPlugin.getResourceString("RESET_DATA"));
        this._refresh.setToolTipText(UIPlugin.getResourceString("REINITIALIZE_AGNT_TOOLTIP"));
        this._refresh.addSelectionListener((SelectionListener)this);
        this._list.sourceList.getTree().addSelectionListener((SelectionListener)this);
        this._list.targetList.getTree().addSelectionListener((SelectionListener)this);
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)this._list.getControl(), (String)(UIPlugin.getPluginId() + ".atlp0002"));
        WorkbenchHelp.setHelp((Control)this._refresh, (String)(UIPlugin.getPluginId() + ".atlp0000"));
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".atlp0002"));
        this.setPageComplete(this.isComplete());
    }

    public boolean finish(String string, String string2, String string3) {
        this._selectedProject = string;
        this._selectedMonitor = string2;
        this._profileFile = string3;
        return this.finish();
    }

    public boolean finish() {
        WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this);
        try {
            this.getWizard().getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyDelegatingOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)invocationTargetException.getTargetException().getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public Enumeration getNodeConfiguration() {
        String string = ((AttachLocalWizard)this.getWizard()).getNodeSelected();
        ((AttachLocalWizard)this.getWizard()).setNodeSelection(string);
        int n = ((AttachLocalWizard)this.getWizard()).getPortSelection();
        ((AttachLocalWizard)this.getWizard()).setPortSelection(n);
        return PDCoreUtil.getNodeConfiguration(string, n);
    }

    public void initialize(Enumeration enumeration) {
        this._initialized = true;
        this._list.initialize(enumeration, this.fShowAll);
    }

    public void initialize() {
        this.initialize(this.getNodeConfiguration());
    }

    public void updateComplete() {
        this.isComplete();
    }

    public boolean isComplete() {
        Vector vector = this._list.getSelectedAgents();
        return vector.size() != 0 && this._validPort;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.setPageComplete(this.isComplete());
    }

    public String pageDetails() {
        String string = "\n" + UIPlugin.getResourceString("AGENT_TXT") + ":\n";
        Vector vector = this._list.getTargetItems();
        if (vector.size() == 0) {
            string = string + "\n" + UIPlugin.getResourceString("NO_AGENT");
        } else {
            int n = 0;
            while (n < vector.size()) {
                TreeItem treeItem = (TreeItem)vector.elementAt(n);
                TreeItem[] treeItemArray = treeItem.getItems();
                int n2 = 0;
                while (n2 < treeItemArray.length) {
                    TreeItem treeItem2 = treeItemArray[n2];
                    string = string + "\t" + treeItem2.getText() + "( " + treeItem.getText() + " )" + "\n";
                    ++n2;
                }
                string = string + "\n";
                ++n;
            }
        }
        return string;
    }

    public void run(IProgressMonitor iProgressMonitor) {
        if (!this.isPageComplete()) {
            return;
        }
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                Vector vector = AttachLocalPage.this._list.getSelectedAgents();
                AttachLocalPage.this.setProfileOptions(vector);
                PDCoreUtil.attach(((AttachLocalWizard)AttachLocalPage.this.getWizard()).getNodeSelected(), vector, AttachLocalPage.this._selectedProject, AttachLocalPage.this._selectedMonitor, String.valueOf(((AttachLocalWizard)AttachLocalPage.this.getWizard()).getPortSelection()), AttachLocalPage.this._profileFile);
            }
        });
    }

    private void setProfileOptions(Vector vector) {
        Object object;
        if (!((AttachLocalWizard)this.getWizard()).isProfilingEnabled()) {
            return;
        }
        ArrayList arrayList = ((AttachLocalWizard)this.getWizard()).getFilterSet();
        ArrayList arrayList2 = new ArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            object = (FilterSetElement)arrayList.get(n);
            if (((FilterSetElement)object).getEnabled()) {
                UIPlugin.getDefault().getPluginPreferences().setValue("filter_name", ((FilterSetElement)object).getName());
                arrayList2 = ((FilterSetElement)object).getChildren();
                break;
            }
            ++n;
        }
        object = ((AttachLocalWizard)this.getWizard()).getOptions();
        int n2 = 0;
        while (n2 < vector.size()) {
            Agent agent = (Agent)vector.elementAt(n2);
            if (agent.getType() == null || agent.getType().equals("Profiler")) {
                AgentConfiguration agentConfiguration = agent.getConfiguration();
                agentConfiguration.clear();
                int n3 = 0;
                while (n3 < ((Vector)object).size()) {
                    agentConfiguration.addEntry((AgentConfigurationEntry)((Vector)object).elementAt(n3));
                    ++n3;
                }
                int n4 = 0;
                while (n4 < arrayList2.size()) {
                    FilterTableElement filterTableElement = (FilterTableElement)arrayList2.get(n4);
                    AgentConfigurationEntry agentConfigurationEntry = new AgentConfigurationEntry();
                    if (filterTableElement.getMethod().length() == 0) {
                        agentConfigurationEntry.setName(filterTableElement.getText());
                        agentConfigurationEntry.setType("SETFILTER");
                    } else {
                        agentConfigurationEntry.setName(filterTableElement.getText() + ' ' + filterTableElement.getMethod());
                        agentConfigurationEntry.setType("SETMETHODFILTER");
                    }
                    agentConfigurationEntry.setValue(filterTableElement.getVisibility());
                    agentConfigurationEntry.setEnabled(true);
                    agentConfiguration.addEntry(agentConfigurationEntry);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void wizardPageSetVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    Object object;
                    String string = ((AttachLocalWizard)AttachLocalPage.this.getWizard()).getNodeName();
                    try {
                        object = NodeFactory.createNode((String)string);
                        string = object.getInetAddress().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    object = ((AttachLocalWizard)AttachLocalPage.this.getWizard()).getNodeSelected();
                    try {
                        Node node = NodeFactory.createNode((String)object);
                        object = node.getInetAddress().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    int n = ((AttachLocalWizard)AttachLocalPage.this.getWizard()).getPortSelection();
                    int n2 = HyadesUtil.testConnection((String)object, String.valueOf(n), false);
                    if (n2 != 0) {
                        ((AttachLocalWizard)AttachLocalPage.this.getWizard()).setNodeSelection(((AttachLocalWizard)AttachLocalPage.this.getWizard()).getNodeSelected());
                        ((AttachLocalWizard)AttachLocalPage.this.getWizard()).setPortSelection(((AttachLocalWizard)AttachLocalPage.this.getWizard()).getPortSelection());
                        AttachLocalPage.this._list.initialize(null, AttachLocalPage.this.fShowAll);
                        AttachLocalPage.this._validPort = false;
                        AttachLocalPage.this.setPageComplete(AttachLocalPage.this._validPort);
                    } else {
                        AttachLocalPage.this._validPort = true;
                        if (!AttachLocalPage.this._initialized || !string.equals(object)) {
                            AttachLocalPage.this._list.initialize(AttachLocalPage.this.getNodeConfiguration(), AttachLocalPage.this.fShowAll);
                            AttachLocalPage.this._initialized = true;
                            AttachLocalPage.this.setPageComplete(AttachLocalPage.this.isComplete());
                        }
                    }
                }
            });
        }
    }

    public Button getRefreshButton() {
        return this._refresh;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.setPageComplete(this.isComplete());
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this._refresh) {
            this.initialize();
        }
        this.setPageComplete(this.isComplete());
    }
}

