/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.wizard.NewNodeWizardPage;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenNodeWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenNodeWizardPage
extends NewNodeWizardPage
implements ModifyListener {
    public OpenNodeWizardPage(String string) {
        super(string);
        this.setTitle(UIPlugin.getResourceString("NODE_PROPERTIES_TITLE"));
        this.setDescription(UIPlugin.getResourceString("NODE_PROPERTIES_DESC"));
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this._nodeUI.setEnabled(false);
        this.populateData();
        this.setPageComplete(true);
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".onwp0000"));
    }

    public boolean finish() {
        TRCNode tRCNode = ((OpenNodeWizard)this.getWizard()).getNode();
        if (tRCNode == null) {
            return true;
        }
        if (tRCNode.getDeltaTime() != this._nodeUI.getDeltaTime()) {
            tRCNode.setDeltaTime(this._nodeUI.getDeltaTime());
            ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource(tRCNode);
            profileEvent.setType(2048);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        }
        return true;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.setPageComplete(true);
        String string = this._nodeUI.getPortNumberUI().getText().trim();
        if (modifyEvent.widget == this._nodeUI.getPortNumberUI()) {
            try {
                int n = Integer.parseInt(string);
                if (n < 0) {
                    this.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                this.setPageComplete(false);
            }
        } else if (modifyEvent.widget == this._nodeUI.getHourUI()) {
            try {
                int n = Integer.parseInt(this._nodeUI.getHourUI().getText().trim());
                if (n < 0) {
                    this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
            catch (NumberFormatException numberFormatException) {
                if (this._nodeUI.getHourUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                this.setPageComplete(false);
            }
        } else if (modifyEvent.widget == this._nodeUI.getMinUI()) {
            try {
                int n = Integer.parseInt(this._nodeUI.getMinUI().getText().trim());
                if (n < 0 || n > 59) {
                    this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
            catch (NumberFormatException numberFormatException) {
                if (this._nodeUI.getMinUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                this.setPageComplete(false);
            }
        } else if (modifyEvent.widget == this._nodeUI.getSecUI()) {
            try {
                int n = Integer.parseInt(this._nodeUI.getSecUI().getText().trim());
                if (n < 0 || n > 59) {
                    this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
            catch (NumberFormatException numberFormatException) {
                if (this._nodeUI.getSecUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                this.setPageComplete(false);
            }
        } else if (modifyEvent.widget == this._nodeUI.getMicSecUI()) {
            try {
                int n = Integer.parseInt(this._nodeUI.getMicSecUI().getText().trim());
                if (n < 0 || n > 1000000) {
                    this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
            catch (NumberFormatException numberFormatException) {
                if (this._nodeUI.getMicSecUI().getText().trim().equals("")) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                    return;
                }
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                this.setPageComplete(false);
            }
        }
    }

    protected void populateData() {
        TRCNode tRCNode = ((OpenNodeWizard)this.getWizard()).getNode();
        if (tRCNode == null) {
            return;
        }
        this._nodeUI.getNodeNameUI().setText(tRCNode.getName());
        this._nodeUI.getPortNumberUI().setText(String.valueOf(tRCNode.getPort()));
        if (tRCNode.getIpAddress() != null) {
            this._nodeUI.getAddressUI().setText(tRCNode.getIpAddress());
        }
        this._locationUI.setMonitor(tRCNode.getMonitor().getName());
        double d = tRCNode.getDeltaTime();
        if (d != 0.0) {
            this._nodeUI.setDeltaTime(d);
        }
    }
}

