/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.util.SymptomDBContentProvider;
import org.eclipse.hyades.sdb.internal.util.SymptomDBDrillDownComposite;
import org.eclipse.hyades.sdb.internal.util.SymptomDBLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class SymptomDBSelectionGroup
extends Composite {
    private Listener listener;
    private Object selectedContainer;
    private TreeViewer treeViewer;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 250;
    private static final int SIZING_SELECTION_PANE_WIDTH = 250;

    public SymptomDBSelectionGroup(Composite composite, Listener listener, boolean bl) {
        this(composite, listener, bl, null);
    }

    public SymptomDBSelectionGroup(Composite composite, Listener listener, boolean bl, String string) {
        super(composite, 0);
        this.listener = listener;
        this.setFont(composite.getFont());
        this.createContents();
    }

    public void containerSelectionChanged(Object object) {
        this.selectedContainer = object;
        if (this.listener != null) {
            Event event = new Event();
            event.type = 13;
            event.widget = this;
            this.listener.handleEvent(event);
        }
    }

    public void createContents() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)this, 64);
        label.setText(SDbPlugin.getResourceString("STR_SELECT_DB_DESCR"));
        label.setFont(this.getFont());
        new Label((Composite)this, 0);
        this.createTreeViewer();
    }

    protected void createTreeViewer() {
        SymptomDBDrillDownComposite symptomDBDrillDownComposite = new SymptomDBDrillDownComposite(this, 2048);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 250;
        gridData.heightHint = 250;
        symptomDBDrillDownComposite.setLayoutData(gridData);
        this.treeViewer = new TreeViewer((Composite)symptomDBDrillDownComposite, 0);
        symptomDBDrillDownComposite.setChildTree(this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new SymptomDBContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new SymptomDBLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                SymptomDBSelectionGroup.this.containerSelectionChanged(iStructuredSelection.getFirstElement());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ISelection iSelection = doubleClickEvent.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    Object object = ((IStructuredSelection)iSelection).getFirstElement();
                    if (SymptomDBSelectionGroup.this.treeViewer.getExpandedState(object)) {
                        SymptomDBSelectionGroup.this.treeViewer.collapseToLevel(object, 1);
                    } else {
                        SymptomDBSelectionGroup.this.treeViewer.expandToLevel(object, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    public IPath getContainerFullPath() {
        if (this.selectedContainer == null) {
            return null;
        }
        if (this.selectedContainer instanceof IResource) {
            return ((IResource)this.selectedContainer).getFullPath();
        }
        return new Path(this.selectedContainer.toString());
    }

    public void setInitialFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public void setSelectedContainer(Object object) {
        this.selectedContainer = object;
        ArrayList<IContainer> arrayList = new ArrayList<IContainer>();
        if (object instanceof IContainer) {
            IContainer iContainer = ((IContainer)object).getParent();
            while (iContainer != null) {
                arrayList.add(0, iContainer);
                iContainer = iContainer.getParent();
            }
            this.treeViewer.setExpandedElements(arrayList.toArray());
            this.treeViewer.setSelection((ISelection)new StructuredSelection(object), true);
        }
    }
}

