/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.util.EventObject;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.ChooseElementComposite;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ChooseElementDialog
extends Dialog
implements IDisposable,
IDoubleClickListener,
ISelectionChangedListener {
    private static final int HEIGHT = 300;
    private ChooseElementComposite chooseElementComposite;
    private Object[] elements;
    private IContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private Object initialSelection;
    private Object selection;
    private String selectionWidgetLabel;
    private String descriptionLabel;
    private String dialogTitle;

    public ChooseElementDialog(Shell shell, Object[] objectArray, ILabelProvider iLabelProvider, IContentProvider iContentProvider) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.elements = objectArray;
        this.labelProvider = iLabelProvider;
        this.contentProvider = iContentProvider == null ? new ArrayContentProvider() : iContentProvider;
    }

    public static Object open(Shell shell, Object[] objectArray, ILabelProvider iLabelProvider) {
        return ChooseElementDialog.open(shell, HyadesUIPlugin.getString("DLG_CHOOSE_TTL"), objectArray, iLabelProvider);
    }

    public static Object open(Shell shell, String string, Object[] objectArray, ILabelProvider iLabelProvider) {
        ChooseElementDialog chooseElementDialog = new ChooseElementDialog(shell, objectArray, iLabelProvider, null);
        chooseElementDialog.setDialogTitle(string);
        chooseElementDialog.setDescriptionLabel(HyadesUIPlugin.getString("LBL_DESC"));
        int n = chooseElementDialog.open();
        chooseElementDialog.dispose();
        if (n == 1) {
            return null;
        }
        return chooseElementDialog.getSelection();
    }

    public void dispose() {
        this.contentProvider = null;
        this.labelProvider = null;
        this.initialSelection = null;
        this.chooseElementComposite.removeSelectionChangedListener(this);
        this.chooseElementComposite.removeDoubleClickListener(this);
        if (!this.chooseElementComposite.isDisposed()) {
            this.chooseElementComposite.dispose();
        }
        this.chooseElementComposite = null;
    }

    public void setInitialSelection(Object object) {
        this.initialSelection = object;
    }

    public void setDescriptionLabel(String string) {
        this.descriptionLabel = string;
    }

    public void setSelectionWidgetLabel(String string) {
        if (this.chooseElementComposite != null) {
            this.chooseElementComposite.setStructuredViewerLabel(string);
        } else {
            this.selectionWidgetLabel = string;
        }
    }

    public void setDialogTitle(String string) {
        if (this.getShell() == null) {
            this.dialogTitle = string;
        } else {
            this.getShell().setText(string);
        }
    }

    public void setContentProvider(IContentProvider iContentProvider) {
        this.contentProvider = iContentProvider != null ? iContentProvider : new ArrayContentProvider();
    }

    public Object getSelection() {
        return this.selection;
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.chooseElementComposite.setContentProvider(this.contentProvider);
        this.chooseElementComposite.setInput(this.elements);
        if (this.initialSelection != null) {
            this.chooseElementComposite.setSelection((ISelection)new StructuredSelection(this.initialSelection), true, true);
        } else {
            this.chooseElementComposite.setSelection(0, true);
        }
        if (this.chooseElementComposite.getSelection().isEmpty()) {
            this.getButton(0).setEnabled(false);
        }
        this.chooseElementComposite.getControl().setFocus();
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 300;
        gridData.widthHint = 300;
        composite2.setLayoutData((Object)gridData);
        this.chooseElementComposite = new ChooseElementComposite(composite2, 0);
        this.chooseElementComposite.setLayoutData(GridDataUtil.createFill());
        this.chooseElementComposite.createContents(this.labelProvider);
        this.chooseElementComposite.addSelectionChangedListener(this);
        this.chooseElementComposite.addDoubleClickListener(this);
        if (this.descriptionLabel == null) {
            this.descriptionLabel = HyadesUIPlugin.getString("LBL_DESC");
        }
        this.chooseElementComposite.setDescriptionLabel(this.descriptionLabel);
        if (this.selectionWidgetLabel != null) {
            this.chooseElementComposite.setStructuredViewerLabel(this.selectionWidgetLabel);
        }
        if (this.dialogTitle != null) {
            this.setDialogTitle(this.dialogTitle);
        }
        return composite2;
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        if (this.chooseElementComposite.fired((EventObject)doubleClickEvent)) {
            this.selection = ((IStructuredSelection)doubleClickEvent.getSelection()).getFirstElement();
            this.okPressed();
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (this.chooseElementComposite.fired((EventObject)selectionChangedEvent)) {
            this.getButton(0).setEnabled(true);
            this.selection = ((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
        }
    }
}

