/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard.exampleproject;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.FileUtil;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizard;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.IProjectAdjuster;

public abstract class ZipAdjusterCreationWizard
extends CreationWizard
implements IProjectAdjuster {
    private String encoding = "UTF-8";
    private List pagesToDeleteFile = new ArrayList();
    private Set zipExtensionsToChange = new HashSet();
    private String[] oldPats;
    private String[] newPats;

    public ZipAdjusterCreationWizard() {
        this.setAdjuster(this);
        this.addZipExtensions();
    }

    protected abstract void addZipExtensions();

    public void dispose() {
        this.zipExtensionsToChange.clear();
        this.pagesToDeleteFile.clear();
        this.setAdjuster(null);
        super.dispose();
    }

    public boolean addZipExtension(String string) {
        return this.zipExtensionsToChange.add(string);
    }

    public boolean removeZipExtension(String string) {
        return this.zipExtensionsToChange.remove(string);
    }

    public void removeAllZipExtensions() {
        this.zipExtensionsToChange.clear();
    }

    public ZipFile adjust(CreationWizardPage[] creationWizardPageArray, CreationWizardPage creationWizardPage, ZipFile zipFile) {
        if (!this.needsReplace(creationWizardPageArray)) {
            return null;
        }
        this.pagesToDeleteFile.add(creationWizardPage);
        try {
            return this.copyZip(zipFile.getName(), FileUtil.getTempDir() + File.separator + this.getPluginId() + FileUtil.getLastSegment(zipFile.getName()), this.oldPats, this.newPats);
        }
        catch (Exception exception) {
            this.pagesToDeleteFile.remove((Object)creationWizardPage);
            HyadesUIPlugin.logError(exception);
            return null;
        }
    }

    public void finished(CreationWizardPage creationWizardPage, ZipFile zipFile) {
        if (!this.pagesToDeleteFile.contains((Object)creationWizardPage)) {
            return;
        }
        File file = new File(zipFile.getName());
        file.delete();
    }

    public File adjust(CreationWizardPage[] creationWizardPageArray, CreationWizardPage creationWizardPage, File file) {
        if (!this.needsReplace(creationWizardPageArray)) {
            return null;
        }
        if (file.isDirectory()) {
            File file2 = new File(FileUtil.getTempDir(), this.getPluginId() + file.getName() + "LMAP");
            if (file2.exists()) {
                FileUtil.delete(file2);
            }
            if (this.copyDir(file, file2, this.oldPats, this.newPats)) {
                this.pagesToDeleteFile.add(creationWizardPage);
                return file2;
            }
            FileUtil.delete(file2);
        }
        return null;
    }

    public void finished(CreationWizardPage creationWizardPage, File file) {
        if (!this.pagesToDeleteFile.contains((Object)creationWizardPage)) {
            return;
        }
        FileUtil.delete(file);
    }

    public ZipFile copyZip(String string, String string2, String[] stringArray, String[] stringArray2) throws IOException, FileNotFoundException {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("oldPats.length != newPas.length");
        }
        boolean bl = false;
        File file = new File(string2);
        boolean bl2 = file.exists();
        if (!bl2) {
            file.createNewFile();
        }
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string));
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    zipOutputStream.putNextEntry(zipEntry);
                    FileUtil.streamCopy(zipInputStream, zipOutputStream);
                } else {
                    String string3;
                    byte[] byArray = null;
                    String string4 = string3 = FileUtil.readFromInputStream(this.encoding, zipInputStream, true);
                    int n = 0;
                    while (n < stringArray.length) {
                        string4 = StringUtil.replace(string4, stringArray[n], stringArray2[n]);
                        ++n;
                    }
                    byArray = StringUtil.encode(this.encoding, string4);
                    if (byArray == null) {
                        byArray = string4.getBytes();
                    }
                    ZipEntry zipEntry2 = new ZipEntry(zipEntry);
                    zipEntry2.setCompressedSize(-1L);
                    if (!string3.equals(string4)) {
                        zipEntry2.setSize(byArray.length);
                        CRC32 cRC32 = new CRC32();
                        cRC32.update(byArray, 0, byArray.length);
                        zipEntry2.setCrc(cRC32.getValue());
                    }
                    zipOutputStream.putNextEntry(zipEntry2);
                    zipOutputStream.write(byArray);
                }
                zipInputStream.closeEntry();
                zipOutputStream.closeEntry();
            }
            bl = true;
            Object var18_17 = null;
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            try {
                zipInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                zipOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            zipInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            zipOutputStream.close();
        }
        catch (Exception exception) {}
        if (!bl && !bl2) {
            file.delete();
        }
        return new ZipFile(file);
    }

    private boolean needsReplace(CreationWizardPage[] creationWizardPageArray) {
        if (this.oldPats != null) {
            return true;
        }
        ArrayList<CreationWizardPage> arrayList = new ArrayList<CreationWizardPage>();
        int n = 0;
        while (n < creationWizardPageArray.length) {
            IConfigurationElement[] iConfigurationElementArray = creationWizardPageArray[n].getConfigurationElement().getChildren("nature");
            if (iConfigurationElementArray != null && iConfigurationElementArray.length > 0) {
                arrayList.add(creationWizardPageArray[n]);
            } else if (!creationWizardPageArray[n].getProjectName().equals(creationWizardPageArray[n].getInitialProjectName())) {
                arrayList.add(creationWizardPageArray[n]);
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        this.oldPats = new String[arrayList.size() * 2];
        this.newPats = new String[arrayList.size() * 2];
        int n2 = 0;
        int n3 = arrayList.size();
        while (n2 < n3) {
            CreationWizardPage creationWizardPage = (CreationWizardPage)((Object)arrayList.get(n2));
            this.oldPats[n2] = creationWizardPage.getInitialProjectName() + "/";
            this.oldPats[n2 + 1] = creationWizardPage.getInitialProjectName() + "\\";
            this.newPats[n2] = creationWizardPage.getProjectName() + "/";
            this.newPats[n2 + 1] = creationWizardPage.getProjectName() + "\\";
            ++n2;
        }
        return true;
    }

    private boolean copyFiles(File file, File file2) {
        try {
            FileOutputStream fileOutputStream;
            block8: {
                if (!file2.exists()) {
                    file2.createNewFile();
                }
                FileInputStream fileInputStream = null;
                fileOutputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    fileOutputStream = new FileOutputStream(file2);
                    FileUtil.streamCopy(fileInputStream, fileOutputStream);
                    Object var6_6 = null;
                    if (fileInputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    throw throwable;
                }
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            HyadesUIPlugin.logError(exception);
            return false;
        }
        return true;
    }

    private boolean copyDir(File file, File file2, String[] stringArray, String[] stringArray2) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return true;
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile()) {
                File file3 = new File(file2, fileArray[n].getName()).getAbsoluteFile();
                if (this.zipExtensionsToChange.contains(FileUtil.getFileExtension(fileArray[n]))) {
                    try {
                        this.copyZip(fileArray[n].getAbsolutePath(), file3.getAbsolutePath(), stringArray, stringArray2);
                    }
                    catch (Exception exception) {
                        HyadesUIPlugin.logError(exception);
                    }
                } else if (file3.getName().equals(".classpath")) {
                    try {
                        String string = FileUtil.readFromFile(this.encoding, fileArray[n], false);
                        if (string != null) {
                            string = this.replaceClasspathVariables(string);
                            FileUtil.writeToFile(this.encoding, file3, false, string);
                        }
                    }
                    catch (IOException iOException) {
                        HyadesUIPlugin.logError(iOException);
                    }
                } else if (!this.copyFiles(fileArray[n], file3)) {
                    return false;
                }
            } else if (fileArray[n].isDirectory() && !"CVS".equals(fileArray[n].getName()) && !this.copyDir(fileArray[n], new File(file2, fileArray[n].getName()), stringArray, stringArray2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void beforeWorspaceRefresh(CreationWizardPage[] creationWizardPageArray) {
    }

    public void afterWorspaceRefresh(CreationWizardPage[] creationWizardPageArray) {
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }
}

