/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.model;

import org.eclipse.hyades.sd.ui.internal.model.Graph;
import org.eclipse.hyades.sd.ui.internal.model.GraphNode;
import org.eclipse.hyades.sd.ui.internal.model.Increment;
import org.eclipse.hyades.sd.ui.internal.model.NodeConnection;
import org.eclipse.hyades.sd.ui.internal.model.NodeContainer;

public class MethodNode
implements GraphNode {
    public String name = null;
    public int type = 0;
    public double startTime = 0.0;
    public double endTime = 0.0;
    public Increment startIncrement = null;
    public Increment endIncrement = null;
    public int nextNewSourceConnection = 0;
    public int nextNewTargetConnection = 0;
    public int indexInContainer = 0;
    public String shortName = null;
    public String secondaryName = null;
    public int indexInTable = -1;
    private int xOffset = 0;
    public Object userArea = null;
    public NodeContainer container = null;
    public Graph graph = null;
    public NodeConnection lastReadTargetConnection = null;
    public NodeConnection[] targetConnections = new NodeConnection[3];
    public NodeConnection[] sourceConnections = new NodeConnection[3];

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String string) {
        this.shortName = string;
    }

    public String getSecondaryName() {
        return this.secondaryName;
    }

    public void setSecondaryName(String string) {
        this.secondaryName = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double d) {
        this.startTime = d;
        this.startIncrement = this.getGraph().addIncrementAppendDup(d);
    }

    public void setStartIncrement(Increment increment) {
        this.startTime = increment.getTime();
        this.startIncrement = increment;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void setEndTime(double d) {
        this.endTime = d;
        this.endIncrement = this.getGraph().addIncrementAppendDup(d);
    }

    public void setEndIncrement(Increment increment) {
        this.endTime = increment.getTime();
        this.endIncrement = increment;
    }

    public Increment getStartIncrement() {
        return this.startIncrement;
    }

    public int getStartIncrementValue() {
        if (this.startIncrement != null) {
            return this.startIncrement.getValue();
        }
        return 0;
    }

    public Increment getEndIncrement() {
        return this.endIncrement;
    }

    public int getEndIncrementValue() {
        if (this.endIncrement != null) {
            return this.endIncrement.getValue();
        }
        return 0;
    }

    public Graph getGraph() {
        if (this.graph == null) {
            this.graph = this.getContainer().getGraph();
        }
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public NodeConnection getLastReadTargetConnection() {
        return this.lastReadTargetConnection;
    }

    public void setLastReadTargetConnection(NodeConnection nodeConnection) {
        this.lastReadTargetConnection = nodeConnection;
    }

    public NodeContainer getContainer() {
        return this.container;
    }

    public void setContainer(NodeContainer nodeContainer) {
        this.container = nodeContainer;
    }

    public NodeConnection[] getSourceConnections() {
        return this.sourceConnections;
    }

    public void setSourceConnections(NodeConnection[] nodeConnectionArray) {
        this.sourceConnections = nodeConnectionArray;
    }

    public NodeConnection[] getTargetConnections() {
        return this.targetConnections;
    }

    public void setTargetConnections(NodeConnection[] nodeConnectionArray) {
        this.targetConnections = nodeConnectionArray;
    }

    public void addSourceConnection(NodeConnection nodeConnection) {
        try {
            this.sourceConnections[this.nextNewSourceConnection] = nodeConnection;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            NodeConnection[] nodeConnectionArray = new NodeConnection[2 * this.sourceConnections.length];
            System.arraycopy(this.sourceConnections, 0, nodeConnectionArray, 0, this.sourceConnections.length);
            this.sourceConnections = nodeConnectionArray;
            this.sourceConnections[this.nextNewSourceConnection] = nodeConnection;
        }
        if (nodeConnection.getEndIncrement().getValue() < this.getStartIncrement().getValue()) {
            this.graph.moveIncrementAndAdjust(this.getStartIncrement(), nodeConnection.getStartIncrement().getValue());
        }
        if (nodeConnection.getEndIncrement().getValue() > this.getEndIncrement().getValue()) {
            this.graph.moveIncrementAndAdjust(nodeConnection.getEndIncrement(), this.getEndIncrement().getValue());
        }
        ++this.nextNewSourceConnection;
    }

    public int getSourceConnectionCount() {
        return this.nextNewSourceConnection;
    }

    public void addTargetConnection(NodeConnection nodeConnection) {
        try {
            this.targetConnections[this.nextNewTargetConnection] = nodeConnection;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            NodeConnection[] nodeConnectionArray = new NodeConnection[2 * this.targetConnections.length];
            System.arraycopy(this.targetConnections, 0, nodeConnectionArray, 0, this.targetConnections.length);
            this.targetConnections = nodeConnectionArray;
            this.targetConnections[this.nextNewTargetConnection] = nodeConnection;
        }
        if (nodeConnection.getStartIncrement().getValue() < this.getStartIncrement().getValue()) {
            this.graph.moveIncrementAndAdjust(this.getStartIncrement(), nodeConnection.getStartIncrement().getValue());
        }
        if (nodeConnection.getStartIncrement().getValue() > this.getEndIncrement().getValue()) {
            this.graph.moveIncrementAndAdjust(nodeConnection.getEndIncrement(), this.getEndIncrement().getValue());
        }
        ++this.nextNewTargetConnection;
    }

    public int getTargetConnectionCount() {
        return this.nextNewTargetConnection;
    }

    public void setUserArea(Object object) {
        this.userArea = object;
    }

    public Object getUserArea() {
        return this.userArea;
    }

    public int getIndexInContainer() {
        return this.indexInContainer;
    }

    public void setIndexInContainer(int n) {
        this.indexInContainer = n;
    }

    public void setIndexInTable(int n) {
        this.indexInTable = n;
    }

    public int getIndexInTable() {
        return this.indexInTable;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int n) {
        this.xOffset = n;
    }
}

