/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.model;

import java.util.Map;
import org.eclipse.hyades.sd.ui.internal.model.ColumnNode;
import org.eclipse.hyades.sd.ui.internal.model.ColumnPassage;
import org.eclipse.hyades.sd.ui.internal.model.GraphNode;
import org.eclipse.hyades.sd.ui.internal.model.Increment;
import org.eclipse.hyades.sd.ui.internal.model.NodeConnection;
import org.eclipse.hyades.sd.ui.internal.util.LogCDrawUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class NodeLink
implements NodeConnection {
    int sourceConnectionType = 26;
    int targetConnectionType = 26;
    boolean selected = false;
    boolean logRecordConection;
    private String name = null;
    private String shortName = null;
    private String secondaryName = null;
    private int type = 0;
    private Increment startIncrement = null;
    private Increment endIncrement = null;
    private GraphNode source;
    private GraphNode target;

    public void init(int n, int n2, boolean bl) {
        this.sourceConnectionType = n;
        this.targetConnectionType = n2;
        this.logRecordConection = bl;
    }

    public void drawSelf(GC gC, int n, ColumnNode columnNode, int n2, int n3, int n4, int n5, int n6, Map map) {
        int n7 = columnNode == this.source ? this.sourceConnectionType : this.targetConnectionType;
        Color color = gC.getForeground();
        if (this.isSelected()) {
            if (!this.logRecordConection) {
                gC.setForeground(LogCDrawUtils.getForegroundSelectedColor());
            } else {
                gC.setForeground(LogCDrawUtils.getLogHighLightColor());
            }
        } else if (!this.logRecordConection) {
            gC.setForeground(LogCDrawUtils.getConnectionColor());
        } else {
            gC.setForeground(LogCDrawUtils.getLogConnectionColor());
        }
        int n8 = n3 + n2 * (this.getStartIncrementValue() - n4);
        int n9 = 0;
        if (this.logRecordConection && (this.target.getStartIncrement().getValue() <= this.source.getStartIncrement().getValue() || this.target.getStartIncrement().getValue() >= this.source.getEndIncrement().getValue())) {
            n9 = n3 + n2 * (this.source.getStartIncrement().getValue() - n4);
        }
        switch (n7) {
            case 0: {
                gC.drawLine(n6, n8, n6 + n / 2 - n5 / 2, n8);
                this.drawArrow(gC, 0, n, n8, n2, n5, n6);
                break;
            }
            case 1: {
                gC.drawLine(n6 + n, n8, n6 + n / 2 + n5 / 2, n8);
                this.drawArrow(gC, 1, n, n8, n2, n5, n6);
                break;
            }
            case 2: {
                if (n9 == 0) {
                    gC.drawLine(n6 + n / 2 - n5 / 2, n8, n6, n8);
                    break;
                }
                gC.drawLine(n6 + n / 2 - n5 / 2, n9, n6, n9);
                break;
            }
            case 3: {
                if (n9 == 0) {
                    gC.drawLine(n6 + n / 2 + n5 / 2, n8, n6 + n, n8);
                    break;
                }
                gC.drawLine(n6 + n / 2 + n5 / 2, n9, n6 + n, n9);
                ColumnPassage columnPassage = (ColumnPassage)map.get(this);
                columnPassage.setPassagePosition(this.source.getStartIncrement().getValue());
                break;
            }
            case 4: {
                gC.drawLine(n6, n8, n6 + n / 2 - n5 / 2, n8);
                this.drawArrow(gC, 0, n, n8, n2, n5, n6);
                this.drawDecoration(gC, 0, n, n8, n2, n5);
                break;
            }
            case 5: {
                gC.drawLine(n6 + n, n8, n6 + n / 2 + n5 / 2, n8);
                this.drawArrow(gC, 1, n, n8, n2, n5, n6);
                this.drawDecoration(gC, 1, n, n8, n2, n5);
                break;
            }
            case 6: {
                gC.drawLine(n6, n8, n6 + n / 2 - n5 / 2, n8);
                this.drawArrow(gC, 2, n, n8, n2, n5, n6);
                break;
            }
            case 7: {
                gC.drawLine(n6 + n, n8, n6 + n / 2 + n5 / 2, n8);
                this.drawArrow(gC, 3, n, n8, n2, n5, n6);
                break;
            }
            case 8: {
                gC.drawLine(n6, n8, n6 + n / 2 - n5 / 2, n8);
                this.drawArrow(gC, 0, n, n8, n2, n5, n6);
                this.drawDecoration(gC, 2, n, n8, n2, n5);
                break;
            }
            case 9: {
                gC.drawLine(n6 + n, n8, n6 + n / 2 + n5 / 2, n8);
                this.drawArrow(gC, 1, n, n8, n2, n5, n6);
                this.drawDecoration(gC, 3, n, n8, n2, n5);
                break;
            }
            case 10: {
                gC.drawLine(n6, n8, n6 + n / 2 - n5 / 2, n8);
                this.drawArrow(gC, 4, n, n8, n2, n5, n6);
                break;
            }
            case 11: {
                gC.drawLine(n6 + n, n8, n6 + n / 2 + n5 / 2, n8);
                this.drawArrow(gC, 5, n, n8, n2, n5, n6);
                break;
            }
            case 12: {
                gC.drawLine(n6, n8, n6 + n / 2 - n5 / 2, n8);
                this.drawArrow(gC, 6, n, n8, n2, n5, n6);
                break;
            }
            case 13: {
                gC.drawLine(n6 + n, n8, n6 + n / 2 + n5 / 2, n8);
                this.drawArrow(gC, 7, n, n8, n2, n5, n6);
                break;
            }
            case 14: {
                gC.setLineStyle(3);
                gC.drawLine(n6, n8, n6 + n / 2 - n5 / 2, n8);
                gC.setLineStyle(1);
                this.drawArrow(gC, 0, n, n8, n2, n5, n6);
                break;
            }
            case 15: {
                gC.setLineStyle(3);
                gC.drawLine(n6 + n, n8, n6 + n / 2 + n5 / 2, n8);
                gC.setLineStyle(1);
                this.drawArrow(gC, 1, n, n8, n2, n5, n6);
                break;
            }
            case 16: {
                gC.setLineStyle(3);
                gC.drawLine(n6 + n / 2 - n5 / 2, n8, n6, n8);
                gC.setLineStyle(1);
                break;
            }
            case 17: {
                gC.setLineStyle(3);
                gC.drawLine(n6 + n / 2 + n5 / 2, n8, n6 + n, n8);
                gC.setLineStyle(1);
                break;
            }
            case 18: {
                gC.drawLine(n6 + n / 2 - n5 / 2, n8, n6 + n / 4, n8);
                gC.drawLine(n6 + n / 4, n8, n6 + n / 4, n8 + n2 / 2);
                gC.drawLine(n6 + n / 4, n8 + n2 / 2, n6 + n / 2 - n5 / 2, n8 + n2 / 2);
                this.drawArrow(gC, 0, n, n8 + n2 / 2, n2, n5, n6);
                break;
            }
            case 19: {
                gC.drawLine(n6 + n / 2 + n5 / 2, n8, n6 + 3 * n / 4, n8);
                if (this.getStartIncrementValue() != this.getEndIncrementValue()) break;
                gC.drawLine(n6 + 3 * n / 4, n8, n6 + 3 * n / 4, n8 + n2 / 2);
                gC.drawLine(n6 + 3 * n / 4, n8 + n2 / 2, n6 + n / 2 + n5 / 2, n8 + n2 / 2);
                this.drawArrow(gC, 1, n, n8 + n2 / 2, n2, n5, n6);
                break;
            }
            case 20: {
                gC.setLineStyle(3);
                gC.drawLine(n6 + n / 2 - n5 / 2, n8 - n2 / 2, n6 + n / 4, n8 - n2 / 2);
                gC.drawLine(n6 + n / 4, n8 - n2 / 2, n6 + n / 4, n8);
                gC.drawLine(n6 + n / 4, n8, n6 + n / 2 - n5 / 2, n8);
                gC.setLineStyle(1);
                this.drawArrow(gC, 0, n, n8, n2, n5, n6);
                break;
            }
            case 21: {
                gC.setLineStyle(3);
                gC.drawLine(n6 + n / 2 + n5 / 2, n8 - n2 / 2, n6 + 3 * n / 4, n8 - n2 / 2);
                gC.drawLine(n6 + 3 * n / 4, n8 - n2 / 2, n6 + 3 * n / 4, n8);
                gC.drawLine(n6 + 3 * n / 4, n8, n6 + n / 2 + n5 / 2, n8);
                gC.setLineStyle(1);
                this.drawArrow(gC, 1, n, n8, n2, n5, n6);
                break;
            }
            case 22: {
                if (n9 == 0) {
                    gC.drawLine(n6, n8, n6 + n / 2 - n5 / 2, n8);
                } else {
                    gC.drawLine(n6, n9, n6 + n / 8, n9);
                    gC.drawLine(n6 + n / 8, n9, n6 + n / 8, n8);
                    gC.drawLine(n6 + n / 8, n8, n6 + n / 2 - n5, n8);
                }
                this.drawArrow(gC, 0, n, n8, n2, n5, n6);
                break;
            }
            case 23: {
                if (n9 == 0) {
                    gC.drawLine(n6 + n, n8, n6 + n / 2 + n5 / 2, n8);
                } else {
                    gC.drawLine(n6 + n, n9, n6 + 7 * n / 8, n9);
                    gC.drawLine(n6 + 7 * n / 8, n9, n6 + 7 * n / 8, n8);
                    gC.drawLine(n6 + 7 * n / 8, n8, n6 + n / 2 + n5 / 2, n8);
                    if (n9 != n8) {
                        ((ColumnPassage)map.get(this)).setPassagePosition(this.source.getStartIncrement().getValue());
                    }
                }
                this.drawArrow(gC, 1, n, n8, n2, n5, n6);
                break;
            }
            case 26: {
                if (this.getStartIncrementValue() == this.getEndIncrementValue()) break;
                int n10 = n3 + n2 * (this.getEndIncrementValue() - n4);
                gC.drawLine(n6 + 3 * n / 4, n8, n6 + 3 * n / 4, n10);
                gC.drawLine(n6 + 3 * n / 4, n10, n6 + n / 2 + n5 / 2, n10);
                this.drawArrow(gC, 1, n, n8 + n2 / 2, n2, n5, n6);
                break;
            }
            case 27: {
                gC.drawLine(n6, n8, n6 + n / 2 - n5 / 2, n8);
                gC.drawString("?", n6 + n / 2 - 3 * n5 / 2, n8 - 3 * n2 / 4);
                break;
            }
            case 28: {
                gC.drawLine(n6 + n, n8, n6 + n / 2 + n5 / 2, n8);
                gC.drawString("?", n6 + n / 2 + 3 * n5 / 4, n8 - 3 * n2 / 4);
                break;
            }
            default: {
                System.out.println("WRONG INDEX FOR LINK!!!!!");
            }
        }
        gC.setForeground(color);
        color.dispose();
    }

    private void drawArrow(GC gC, int n, int n2, int n3, int n4, int n5, int n6) {
        switch (n) {
            case 0: {
                gC.drawLine(n6 + n2 / 2 - n5 / 2, n3, n6 + n2 / 2 - 3 * n5 / 2, n3 - n4 / 2);
                gC.drawLine(n6 + n2 / 2 - n5 / 2, n3, n6 + n2 / 2 - 3 * n5 / 2, n3 + n4 / 2);
                break;
            }
            case 1: {
                gC.drawLine(n6 + n2 / 2 + n5 / 2, n3, n6 + n2 / 2 + 3 * n5 / 2, n3 - n4 / 2);
                gC.drawLine(n6 + n2 / 2 + n5 / 2, n3, n6 + n2 / 2 + 3 * n5 / 2, n3 + n4 / 2);
                break;
            }
            case 2: {
                gC.drawLine(n6 + n2 / 2 - n5 / 2, n3 - n4 / 3, n6 + n2 / 2 - 2 * n5, n3 - n4 / 3);
                gC.drawLine(n6 + n2 / 2 - 2 * n5, n3 - n4 / 3, n6 + n2 / 2 - n5, n3 - n4 / 2);
                gC.drawLine(n6 + n2 / 2 - 2 * n5, n3 - n4 / 3, n6 + n2 / 2 - n5, n3 - n4 / 6);
                break;
            }
            case 3: {
                gC.drawLine(n6 + n2 / 2 + n5 / 2, n3 - n4 / 3, n6 + n2 / 2 + 2 * n5, n3 - n4 / 3);
                gC.drawLine(n6 + n2 / 2 + 2 * n5, n3 - n4 / 3, n6 + n2 / 2 + n5, n3 - n4 / 2);
                gC.drawLine(n6 + n2 / 2 + 2 * n5, n3 - n4 / 3, n6 + n2 / 2 + n5, n3 - n4 / 6);
                break;
            }
            case 4: {
                int[] nArray = new int[]{n6 + n2 / 2 - n5 / 2, n3, n6 + n2 / 2 - 3 * n5 / 2, n3 + n4 / 2, n6 + n2 / 2 - 3 * n5 / 2, n3 - n4 / 2};
                gC.drawPolygon(nArray);
                int[] nArray2 = new int[]{n6 + n2 / 2 - n5 / 2 + 1, n3, n6 + n2 / 2 - 3 * n5 / 2, n3 + n4 / 2, n6 + n2 / 2 - 3 * n5 / 2, n3 - n4 / 2};
                if (this.isSelected()) {
                    if (!this.logRecordConection) {
                        gC.setBackground(LogCDrawUtils.getForegroundSelectedColor());
                    } else {
                        gC.setBackground(LogCDrawUtils.getLogHighLightColor());
                    }
                } else if (!this.logRecordConection) {
                    gC.setBackground(LogCDrawUtils.getConnectionColor());
                } else {
                    gC.setBackground(LogCDrawUtils.getLogConnectionColor());
                }
                gC.fillPolygon(nArray2);
                gC.setBackground(LogCDrawUtils.getBackgroundColor());
                break;
            }
            case 5: {
                int[] nArray = new int[]{n6 + n2 / 2 + n5 / 2, n3, n6 + n2 / 2 + 3 * n5 / 2, n3 + n4 / 2, n6 + n2 / 2 + 3 * n5 / 2, n3 - n4 / 2};
                gC.drawPolygon(nArray);
                int[] nArray3 = new int[]{n6 + n2 / 2 + n5 / 2, n3, n6 + n2 / 2 + 3 * n5 / 2, n3 + n4 / 2, n6 + n2 / 2 + 3 * n5 / 2, n3 - n4 / 2};
                if (this.isSelected()) {
                    if (!this.logRecordConection) {
                        gC.setBackground(LogCDrawUtils.getForegroundSelectedColor());
                    } else {
                        gC.setBackground(LogCDrawUtils.getLogHighLightColor());
                    }
                } else if (!this.logRecordConection) {
                    gC.setBackground(LogCDrawUtils.getConnectionColor());
                } else {
                    gC.setBackground(LogCDrawUtils.getLogConnectionColor());
                }
                gC.fillPolygon(nArray3);
                gC.setBackground(LogCDrawUtils.getBackgroundColor());
                break;
            }
            case 6: {
                gC.drawLine(n6 + n2 / 2 - n5 / 2, n3, n6 + n2 / 2 - 3 * n5 / 2, n3 - n4 / 2);
                break;
            }
            case 7: {
                gC.drawLine(n6 + n2 / 2 + n5 / 2, n3, n6 + n2 / 2 + 3 * n5 / 2, n3 - n4 / 2);
                break;
            }
            default: {
                System.out.println("WRONG INDEX FOR ARROW!!!!!");
            }
        }
    }

    private void drawDecoration(GC gC, int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 0: {
                gC.drawLine(n2 / 2 - 3 * n5 / 2 - 3 * n5 / 8, n3 - n4 / 2, n2 / 2 - 5 * n5 / 2 - 3 * n5 / 8, n3 + n4 / 2);
                gC.drawLine(n2 / 2 - 3 * n5 / 2 - 3 * n5 / 8, n3 + n4 / 2, n2 / 2 - 5 * n5 / 2 - 3 * n5 / 8, n3 - n4 / 2);
                break;
            }
            case 1: {
                gC.drawLine(n2 / 2 + 3 * n5 / 2 + 3 * n5 / 8, n3 - n4 / 2, n2 / 2 + 5 * n5 / 2 + 3 * n5 / 8, n3 + n4 / 2);
                gC.drawLine(n2 / 2 + 3 * n5 / 2 + 3 * n5 / 8, n3 + n4 / 2, n2 / 2 + 5 * n5 / 2 + 3 * n5 / 8, n3 - n4 / 2);
                break;
            }
            case 2: {
                gC.drawOval(3 * n2 / 8 - 3 * n4 / 4, n3 - n4 - 1, 3 * n4 / 4, 3 * n4 / 4);
                break;
            }
            case 3: {
                gC.drawOval(5 * n2 / 8, n3 - n4 - 1, 3 * n4 / 4, 3 * n4 / 4);
                break;
            }
            default: {
                System.out.println("WRONG INDEX FOR DECORATION!!!!!");
            }
        }
    }

    public boolean isLogRecordConection() {
        return this.logRecordConection;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String string) {
        this.shortName = string;
    }

    public String getSecondaryName() {
        return this.secondaryName;
    }

    public void setSecondaryName(String string) {
        this.secondaryName = string;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public double getStartTime() {
        return 0.0;
    }

    public void setStartTime(double d) {
        this.startIncrement = this.getSource().getGraph().addIncrementAppendDup(d);
    }

    public void setStartIncrement(Increment increment) {
        this.startIncrement = increment;
    }

    public double getEndTime() {
        return 0.0;
    }

    public void setEndTime(double d) {
        this.endIncrement = this.getSource().getGraph().addIncrementAppendDup(d);
    }

    public void setEndIncrement(Increment increment) {
        this.endIncrement = increment;
    }

    public Increment getStartIncrement() {
        return this.startIncrement;
    }

    public int getStartIncrementValue() {
        if (this.startIncrement != null) {
            return this.startIncrement.getValue();
        }
        return 0;
    }

    public Increment getEndIncrement() {
        return this.endIncrement;
    }

    public int getEndIncrementValue() {
        if (this.endIncrement != null) {
            return this.endIncrement.getValue();
        }
        return 0;
    }

    public GraphNode getSource() {
        return this.source;
    }

    public void setSource(GraphNode graphNode) {
        this.source = graphNode;
    }

    public GraphNode getTarget() {
        return this.target;
    }

    public void setTarget(GraphNode graphNode) {
        this.target = graphNode;
    }

    public Object getUserArea() {
        return null;
    }

    public void setUserArea(Object object) {
    }

    public void setSelected(boolean bl) {
        this.selected = !bl ? bl : bl;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

