/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.hyades.sd.ui.internal.model.ColumnFigure;
import org.eclipse.hyades.sd.ui.internal.model.ColumnNode;
import org.eclipse.hyades.sd.ui.internal.model.ColumnPassage;
import org.eclipse.hyades.sd.ui.internal.model.Graph;
import org.eclipse.hyades.sd.ui.internal.model.GraphNode;
import org.eclipse.hyades.sd.ui.internal.model.NodeContainer;
import org.eclipse.hyades.sd.ui.internal.model.NodeLink;
import org.eclipse.hyades.sd.ui.internal.util.DrawAreaFindDialog;
import org.eclipse.hyades.sd.ui.internal.util.DrawAreaOverview;
import org.eclipse.hyades.sd.ui.internal.util.DrawAreaToolTip;
import org.eclipse.hyades.sd.ui.internal.util.DrawAreaWeightScale;
import org.eclipse.hyades.sd.ui.internal.util.LogCDrawUtils;
import org.eclipse.hyades.sd.ui.internal.views.SDViewer;
import org.eclipse.hyades.sd.ui.internal.views.SDViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;

public class SDViewerUI
extends Canvas
implements ControlListener,
SelectionListener,
PaintListener,
KeyListener,
ISelectionProvider {
    private Rectangle parentBounds;
    private Graph graph = null;
    int endOfTime = 0;
    int endOfColumns = 16;
    private MouseEvent idEvent = null;
    private DrawAreaToolTip toolTip = null;
    private DrawAreaOverview drawAreaOverview;
    private DrawAreaWeightScale drawAreaWeightScale;
    private DrawAreaFindDialog drawAreaFindDialog = null;
    private NodeLink selectedNodeLink = null;
    private ColumnNode selectedColumnNode = null;
    private ColumnFigure selectedColumnFigure = null;
    private Composite graphComposite;
    private Map columnPassages;
    private int width = 0;
    private Canvas canvas = null;
    private SDViewerPage sdViewerPage;
    private ArrayList _viewsActions = new ArrayList();
    private final String GROUP_ADD_VIEWS = "group.add.views";

    public SDViewerUI(Composite composite, Graph graph, SDViewerPage sDViewerPage) {
        super(composite, 0);
        this.sdViewerPage = sDViewerPage;
        this.parentBounds = composite.getClientArea();
        int n = LogCDrawUtils.getWeightScaleWidth();
        this.graphComposite = new Composite((Composite)this, 768);
        this.graphComposite.setLocation(n, 0);
        this.graphComposite.setSize(this.parentBounds.width - n, this.parentBounds.height);
        this.graphComposite.setBackground(LogCDrawUtils.getBackgroundColor());
        this.canvas = new Canvas(this.graphComposite, 0);
        this.canvas.setSize(this.graphComposite.getSize());
        this.canvas.setBackground(LogCDrawUtils.getBackgroundColor());
        this.canvas.setLocation(0, 0);
        this.canvas.setVisible(true);
        this.canvas.setEnabled(true);
        ScrollBar scrollBar = this.graphComposite.getVerticalBar();
        scrollBar.addSelectionListener((SelectionListener)this);
        scrollBar.setMinimum(0);
        scrollBar.setIncrement(LogCDrawUtils.getTimeUnit());
        ScrollBar scrollBar2 = this.graphComposite.getHorizontalBar();
        scrollBar2.addSelectionListener((SelectionListener)this);
        scrollBar2.setMinimum(0);
        scrollBar2.setIncrement(20);
        this.drawAreaWeightScale = new DrawAreaWeightScale((Composite)this, 0);
        this.drawAreaWeightScale.setSize(n, this.parentBounds.height);
        this.drawAreaOverview = new DrawAreaOverview(this.graphComposite, new Point(this.graphComposite.getBounds().width - scrollBar.getSize().x, this.graphComposite.getBounds().height - scrollBar2.getSize().y));
        this.columnPassages = new HashMap();
        this.reloadGraph(graph);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SDViewerUI.this.widgetDisposed(disposeEvent);
            }
        });
        this.addPaintListener(this);
        this.addControlListener(this);
        this.graphComposite.addKeyListener((KeyListener)this);
        this.canvas.addKeyListener((KeyListener)this);
    }

    public void reloadGraph(Graph graph) {
        this.resetGraph();
        this.width = 0;
        this.graph = graph;
        if (this.graph != null) {
            this.buildGraph();
            this.drawAreaWeightScale.setWeights(this.graph.getIncrementWeights());
            LogCDrawUtils.setWeightSelection(-1, null);
            if (this.toolTip == null) {
                this.toolTip = new DrawAreaToolTip((Composite)this);
            }
        }
        this.updateUI();
        LogCDrawUtils.setBottomMax(this.getSize().y / LogCDrawUtils.getTimeUnit());
        this.drawAreaOverview.redraw();
        this.graphComposite.redraw();
    }

    private void resetGraph() {
        if (this.graph != null) {
            ColumnFigure columnFigure = null;
            int n = 0;
            while (n < this.graph.getTopNodeCount()) {
                columnFigure = (ColumnFigure)this.graph.getTopNodes()[n];
                if (columnFigure != null) {
                    columnFigure.disposeMe();
                }
                ++n;
            }
        }
        this.endOfTime = 0;
        this.endOfColumns = 16;
        this.columnPassages.clear();
    }

    private void buildGraph() {
        int n = LogCDrawUtils.getTimeUnit();
        Vector vector = new Vector();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        do {
            if (this.graph.getTopNodes()[n2] == null) continue;
            ColumnFigure columnFigure = (ColumnFigure)this.graph.getTopNodes()[n2];
            this.addColumn(n2, columnFigure);
            n3 = 0;
            while (n3 < columnFigure.getInternalNodeCount()) {
                if (columnFigure.getInternalNodes()[n3] != null) {
                    ColumnNode columnNode = (ColumnNode)columnFigure.getInternalNodes()[n3];
                    columnNode.init();
                    n4 = 0;
                    while (n4 < columnNode.getSourceConnectionCount()) {
                        if (columnNode.getSourceConnections()[n4] != null) {
                            NodeLink nodeLink = (NodeLink)columnNode.getSourceConnections()[n4];
                            this.initConnection(nodeLink, true);
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
        } while (++n2 < this.graph.getTopNodeCount());
        this.endOfTime = this.graph.getMaxIncrement();
        if (this.endOfTime > 0) {
            this.adjustVScroll();
            this.adjustHScroll();
            this.drawAreaOverview.setCanvasSize(this.endOfTime);
        }
    }

    public void addColumn(int n, NodeContainer nodeContainer) {
        String string = nodeContainer.getShortName();
        string = nodeContainer.getType() == 2 ? string + "/" + nodeContainer.getSecondaryName() : "  " + string + "  ";
        this.width += ((ColumnFigure)nodeContainer).init(this.graphComposite, string, this.width - this.graphComposite.getHorizontalBar().getSelection(), n, this.canvas);
    }

    private void adjustVScroll() {
        int n = LogCDrawUtils.getTimeUnit();
        int n2 = LogCDrawUtils.getInitBoxSpace();
        ScrollBar scrollBar = this.graphComposite.getVerticalBar();
        scrollBar.setMaximum(this.endOfTime + n2 / n);
        scrollBar.setThumb(Math.min(this.graphComposite.getSize().y, this.endOfTime * n + n2) / n);
        scrollBar.setPageIncrement(Math.min(this.graphComposite.getSize().y, this.endOfTime * n + n2) / n);
    }

    private void adjustHScroll() {
        ScrollBar scrollBar = this.graphComposite.getHorizontalBar();
        this.endOfColumns = this.graphComposite.getVerticalBar().getSize().x;
        int n = 0;
        while (n < this.graph.getTopNodeCount()) {
            ColumnFigure columnFigure = (ColumnFigure)this.graph.getTopNodes()[n];
            this.endOfColumns += columnFigure.getWidth();
            ++n;
        }
        scrollBar.setMaximum(this.endOfColumns);
        scrollBar.setThumb(Math.min(this.endOfColumns, this.graphComposite.getSize().x));
        scrollBar.setPageIncrement(Math.min(this.endOfColumns, this.graphComposite.getSize().x));
    }

    public void initConnection(NodeLink nodeLink, boolean bl) {
        int n = 26;
        int n2 = 26;
        int n3 = 26;
        int n4 = nodeLink.getSource().getContainer().getIndexInContainer();
        int n5 = nodeLink.getTarget().getContainer().getIndexInContainer();
        int n6 = nodeLink.getSource().getIndexInContainer();
        int n7 = nodeLink.getTarget().getIndexInContainer();
        switch (nodeLink.getType()) {
            case 0: {
                if (n4 < n5) {
                    n = 3;
                    n2 = 27;
                    n3 = 22;
                    break;
                }
                if (n4 > n5) {
                    n = 2;
                    n2 = 28;
                    n3 = 23;
                    break;
                }
                if (n4 != n5) break;
                n = 19;
                n2 = 26;
                break;
            }
            case 1: {
                if (n4 < n5) {
                    n = 3;
                    n2 = 0;
                    n3 = 22;
                    break;
                }
                if (n4 > n5) {
                    n = 2;
                    n2 = 1;
                    n3 = 23;
                    break;
                }
                if (n4 != n5) break;
                n = 19;
                n2 = 26;
                break;
            }
            case 2: {
                if (n4 < n5) {
                    n = 3;
                    n2 = 4;
                    n3 = 22;
                    break;
                }
                if (n4 > n5) {
                    n = 2;
                    n2 = 5;
                    n3 = 23;
                    break;
                }
                if (n4 != n5) break;
                n = 19;
                n2 = 26;
                break;
            }
            case 3: {
                if (n4 < n5) {
                    n = 3;
                    n2 = 6;
                    n3 = 22;
                    break;
                }
                if (n4 > n5) {
                    n = 2;
                    n2 = 7;
                    n3 = 23;
                    break;
                }
                if (n4 != n5) break;
                n = 19;
                n2 = 26;
                break;
            }
            case 4: {
                if (n4 < n5) {
                    n = 3;
                    n2 = 8;
                    n3 = 22;
                    break;
                }
                if (n4 > n5) {
                    n = 2;
                    n2 = 9;
                    n3 = 23;
                    break;
                }
                if (n4 != n5) break;
                n = 19;
                n2 = 26;
                break;
            }
            case 5: {
                if (n4 < n5) {
                    n = 3;
                    n2 = this.graph.getType() == 21 || this.graph.getType() == 22 ? 22 : 10;
                    n3 = 22;
                    break;
                }
                if (n4 > n5) {
                    n = 2;
                    n2 = this.graph.getType() == 21 || this.graph.getType() == 22 ? 23 : 11;
                    n3 = 23;
                    break;
                }
                if (n4 != n5) break;
                n = 19;
                n2 = 26;
                break;
            }
            case 6: {
                if (n4 < n5) {
                    n = 3;
                    n2 = 12;
                    n3 = 22;
                    break;
                }
                if (n4 > n5) {
                    n = 2;
                    n2 = 13;
                    n3 = 23;
                    break;
                }
                if (n4 != n5) break;
                n = 19;
                n2 = 26;
                break;
            }
            case 7: {
                if (n4 < n5) {
                    n = 17;
                    n2 = 14;
                    n3 = 24;
                    break;
                }
                if (n4 > n5) {
                    n = 16;
                    n2 = 15;
                    n3 = 25;
                    break;
                }
                if (n4 != n5) break;
                n = 21;
                n2 = 26;
                break;
            }
            default: {
                System.out.println("WRONG INDEX FOR NODECONNECTION!!!!!");
            }
        }
        nodeLink.init(n, n2, this.graph.getType() == 21 || this.graph.getType() == 22);
        if (bl && !this.columnPassages.containsKey(nodeLink)) {
            this.columnPassages.put(nodeLink, new ColumnPassage(n3, nodeLink, this.graph.getType() == 21 || this.graph.getType() == 22));
        }
    }

    public Control getControl() {
        return this;
    }

    public void paintControl(PaintEvent paintEvent) {
        this.toolTip.paintControl();
    }

    public void update() {
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        if (this.selectedColumnFigure != null) {
            this.toolTip.hideText();
            int n = this.selectedColumnFigure.getNodeContainer().getType();
        }
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)((SDViewer)this.sdViewerPage.getTraceViewer()).refresh);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)((SDViewer)this.sdViewerPage.getTraceViewer()).zoomIn);
        iMenuManager.add((IAction)((SDViewer)this.sdViewerPage.getTraceViewer()).zoomOut);
        iMenuManager.add((IAction)((SDViewer)this.sdViewerPage.getTraceViewer()).home);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)((SDViewer)this.sdViewerPage.getTraceViewer()).find);
    }

    public void removeToolTip() {
        this.toolTip.hideText();
    }

    public void setToolTip(int n, int n2, ColumnFigure columnFigure) {
        int n3 = columnFigure.getXOffset();
        int n4 = n - this.graphComposite.getHorizontalBar().getSelection();
        if (n4 == this.parentBounds.x || n4 == 0 || n2 == this.parentBounds.y || n2 == 0) {
            this.toolTip.hideText();
            return;
        }
        if (n < n3 || n > n3 + this.width) {
            return;
        }
        ColumnPassage columnPassage = columnFigure.getColumnPassageAtPosition(n2);
        if (columnPassage != null) {
            this.toolTip.showText(columnPassage.getNodeConnection().getName());
            return;
        }
        ArrayList arrayList = columnFigure.getColumnNodesAtPosition(n2);
        if (arrayList != null && arrayList.size() > 0) {
            int n5 = 0;
            while (n5 < arrayList.size()) {
                ColumnNode columnNode = (ColumnNode)arrayList.get(n5);
                if (columnNode != null && n >= n3 + columnFigure.getWidth() / 2 - 5 && n <= n3 + columnFigure.getWidth() / 2 + 5) {
                    this.toolTip.showText(columnNode.getGraphNode().getName());
                    return;
                }
                if (columnNode != null) {
                    NodeLink nodeLink = columnFigure.getNodeLinkAtPosition(columnNode, n, n2);
                    if (nodeLink != null) {
                        this.toolTip.showText(nodeLink.getName());
                        return;
                    }
                    this.toolTip.hideText();
                }
                ++n5;
            }
        } else {
            if (arrayList.size() == 0 && (n >= n3 + columnFigure.getWidth() / 2 - 1 && n <= n3 + columnFigure.getWidth() / 2 + 1 || n >= n3 && n <= n3 + columnFigure.getWidth() && LogCDrawUtils.getBoxSpace() != 0 && n2 <= LogCDrawUtils.getBoxSpace())) {
                this.toolTip.showText(columnFigure.getFullName());
                return;
            }
            if (arrayList.size() == 0) {
                this.toolTip.hideText();
            }
        }
    }

    public void setToolTip(int n, int n2, String string) {
        this.toolTip.showText(string);
    }

    private ColumnFigure getColumnFigureAtLocation(int n) {
        int n2 = 0;
        n += this.graphComposite.getHorizontalBar().getSelection();
        int n3 = 0;
        while (n3 < this.graph.getTopNodeCount()) {
            ColumnFigure columnFigure = (ColumnFigure)this.graph.getTopNodes()[n3];
            if ((n2 += columnFigure.getWidth()) >= n) {
                return columnFigure;
            }
            ++n3;
        }
        return null;
    }

    private ColumnFigure getColumnFigureAtLocation(int n, int n2) {
        n += this.graphComposite.getHorizontalBar().getSelection();
        int n3 = 0;
        while (n3 < this.graph.getTopNodeCount()) {
            ColumnFigure columnFigure = (ColumnFigure)this.graph.getTopNodes()[n3];
            if (n2 <= columnFigure.getWidth()) {
                return columnFigure;
            }
            n2 -= columnFigure.getWidth();
            ++n3;
        }
        return null;
    }

    void widgetDisposed(DisposeEvent disposeEvent) {
        if (this.canvas != null) {
            this.canvas.dispose();
        }
        if (this.graphComposite != null) {
            this.graphComposite.dispose();
        }
        this.graph = null;
        this.columnPassages.clear();
        this.idEvent = null;
        this.toolTip = null;
        this.drawAreaFindDialog = null;
        this.drawAreaOverview = null;
        this.drawAreaWeightScale = null;
        this.selectedNodeLink = null;
        this.selectedColumnNode = null;
        this.selectedColumnFigure = null;
    }

    public Rectangle getParentBounds() {
        return this.parentBounds;
    }

    public GraphNode[] getColumnFigures() {
        return this.graph.getTopNodes();
    }

    public int getEndOfTime() {
        return this.endOfTime;
    }

    public Composite getGraphComposite() {
        return this.graphComposite;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Point getSize() {
        return this.graphComposite.getSize();
    }

    public Iterator getColumnPassages() {
        return this.columnPassages.values().iterator();
    }

    public Map getColumnPassagesMap() {
        return this.columnPassages;
    }

    public boolean setFocus() {
        this.graphComposite.forceFocus();
        return this.graphComposite.setFocus();
    }

    public void setScrollbars(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.graphComposite.getHorizontalBar().setSelection(n);
        this.graphComposite.getVerticalBar().setSelection(n2);
        this.scrollViewport(n, n2);
    }

    public void scrollViewport(int n, int n2) {
        this.hScroll(n);
        this.vScroll(n2);
        this.update();
    }

    private void hScroll(int n) {
        this.scrollColumns(n);
        this.drawAreaOverview.positionShadow();
        this.updateUI();
    }

    private void vScroll(int n) {
        LogCDrawUtils.adjustStartPosition(n);
        this.drawAreaOverview.positionShadow();
        this.updateUI();
    }

    public void updateUI() {
        this.drawAreaWeightScale.drawSelf();
        this.adjustVScroll();
        this.adjustHScroll();
        this.canvas.redraw();
    }

    public void adjustColumns(int n, int n2) {
        this.width += n;
        int n3 = n2 + 1;
        while (n3 < this.graph.getTopNodeCount()) {
            ((ColumnFigure)this.graph.getTopNodes()[n3]).adjustLocation(n);
            ++n3;
        }
        this.scrollColumns(this.graphComposite.getHorizontalBar().getSelection());
        this.adjustHScroll();
        this.drawAreaOverview.close();
        this.drawAreaOverview.adjustParentSize(this.getSize().x - this.graphComposite.getVerticalBar().getSize().x, this.getSize().y - this.graphComposite.getHorizontalBar().getSize().y);
    }

    private void scrollColumns(int n) {
        this.endOfColumns = this.graphComposite.getVerticalBar().getSize().x;
        int n2 = -n;
        int n3 = 0;
        while (n3 < this.graph.getTopNodeCount()) {
            ColumnFigure columnFigure = (ColumnFigure)this.graph.getTopNodes()[n3];
            columnFigure.setOriginalLocation(n2, 0);
            n2 += columnFigure.getWidth();
            ++n3;
        }
    }

    public void goHome() {
        this.graphComposite.getHorizontalBar().setSelection(0);
        this.graphComposite.getVerticalBar().setSelection(0);
        this.scrollViewport(0, 0);
        this.drawAreaOverview.close();
    }

    public void setSelectedNode(ColumnNode columnNode, ColumnFigure columnFigure) {
        int n = 0;
        int n2 = LogCDrawUtils.getNodeWidth();
        boolean bl = true;
        if (this.selectedColumnFigure != null) {
            if (this.selectedColumnFigure.getMyCanvas().isDisposed()) {
                bl = false;
            }
            this.selectedColumnFigure.setSelected(false);
            if (bl) {
                this.selectedColumnFigure.getMyCanvas().redraw();
            }
        }
        if (columnNode == null) {
            if (this.selectedColumnNode == null) {
                return;
            }
            if (this.selectedColumnNode != null) {
                this.selectedColumnNode.setSelected(false);
                if (bl && this.selectedColumnFigure != null) {
                    n = this.selectedColumnFigure.getWidth();
                    this.selectedColumnFigure.getMyCanvas().redraw((n - n2) / 2 - 1, this.selectedColumnNode.getBeginPosition() - 1, n2 + 2, this.selectedColumnNode.getPositionRange() + 2, true);
                }
                this.selectedColumnNode = null;
                this.selectedColumnFigure = null;
            }
        } else if (columnNode != null) {
            if (this.selectedColumnNode != null) {
                this.selectedColumnNode.setSelected(false);
            }
            if (bl && this.selectedColumnFigure != null) {
                n = this.selectedColumnFigure.getWidth();
                this.selectedColumnFigure.getMyCanvas().redraw(this.selectedColumnFigure.getXOffset() + (n - n2) / 2 - 1, this.selectedColumnNode.getBeginPosition() - 1, n2 + 2, this.selectedColumnNode.getPositionRange() + 2, true);
            }
        }
        this.selectedColumnNode = columnNode;
        this.selectedColumnFigure = columnFigure;
        this.selectedColumnNode.setSelected(true);
        if (this.selectedColumnNode.getUserArea() != null) {
            UIPlugin.getDefault().getSelectionModel(this.sdViewerPage.getMOFObject()).add(this.selectedColumnNode.getUserArea());
        }
        if (bl && this.selectedColumnFigure != null) {
            n = this.selectedColumnFigure.getWidth();
            this.selectedColumnFigure.getMyCanvas().redraw(this.selectedColumnFigure.getXOffset() + (n - n2) / 2 - 1, this.selectedColumnNode.getBeginPosition() - 1, n2 + 2, this.selectedColumnNode.getPositionRange() + 2, true);
        }
        if (this.selectedNodeLink != null) {
            this.selectedNodeLink.setSelected(false);
            this.updateUI();
        }
        this.updateUI();
    }

    public void setSelectedColumnFigure(ColumnFigure columnFigure) {
        if (this.selectedColumnFigure == null && columnFigure != null) {
            columnFigure.setSelected(true);
            columnFigure.getMyCanvas().redraw();
            this.selectedColumnFigure = columnFigure;
        } else if (this.selectedColumnFigure != null && columnFigure != null && !this.selectedColumnFigure.equals(columnFigure)) {
            this.selectedColumnFigure.setSelected(false);
            this.selectedColumnFigure.getMyCanvas().redraw();
            columnFigure.setSelected(true);
            columnFigure.getMyCanvas().redraw();
            this.selectedColumnFigure = columnFigure;
        }
        if (this.selectedColumnFigure != null && this.selectedColumnFigure.getUserArea() != null) {
            UIPlugin.getDefault().getSelectionModel(this.sdViewerPage.getMOFObject()).add(this.selectedColumnFigure.getUserArea());
        }
        this.updateUI();
    }

    public void setSelectedNodeLink(ColumnFigure columnFigure, NodeLink nodeLink) {
        if (this.selectedColumnNode != null) {
            this.selectedColumnNode.setSelected(false);
        }
        if (this.selectedColumnFigure != null) {
            this.selectedColumnFigure.setSelected(false);
        }
        nodeLink.setSelected(true);
        this.updateUI();
        this.selectedNodeLink = nodeLink;
    }

    public void scrollToNode(ColumnNode columnNode) {
        int n;
        ColumnFigure columnFigure;
        int n2 = LogCDrawUtils.getBoxHeight();
        int n3 = LogCDrawUtils.getUpperSpace();
        int n4 = LogCDrawUtils.getTimeUnit();
        ScrollBar scrollBar = this.graphComposite.getHorizontalBar();
        ScrollBar scrollBar2 = this.graphComposite.getVerticalBar();
        int n5 = 0;
        int n6 = 0;
        int n7 = columnFigure.getOriginalLocation().x;
        columnFigure = (ColumnFigure)columnNode.getContainer();
        if (n7 + columnFigure.getWidth() > scrollBar.getSize().x) {
            n5 = n7 - (scrollBar.getSize().x - columnFigure.getWidth()) / 2;
        }
        n6 = (n = columnNode.getStartPosition() + (n3 + n2 - this.graphComposite.getSize().y / 2) / n4) < 0 ? 0 : n;
        this.hScroll(n5);
        scrollBar.setSelection(n5);
        this.vScroll(n6);
        scrollBar2.setSelection(n6);
    }

    public void find() {
        this.drawAreaFindDialog = new DrawAreaFindDialog(this.getParent().getShell(), this.graph);
        this.drawAreaFindDialog.open();
        if (this.drawAreaFindDialog.getReturnCode() == 0 && this.drawAreaFindDialog.getSelectedNode() != null) {
            ScrollBar scrollBar = this.graphComposite.getHorizontalBar();
            int n = 0;
            ColumnFigure columnFigure = (ColumnFigure)this.drawAreaFindDialog.getSelectedNode();
            this.setSelectedColumnFigure(columnFigure);
            int n2 = columnFigure.getOriginalLocation().x;
            if (n2 + columnFigure.getWidth() > scrollBar.getSize().x) {
                n = n2 - (scrollBar.getSize().x - columnFigure.getWidth()) / 2;
            }
            this.hScroll(n);
            scrollBar.setSelection(n);
        }
    }

    public MouseEvent getIdEvent() {
        return this.idEvent;
    }

    public void setIdEvent(MouseEvent mouseEvent) {
        if (this.idEvent == null || this.idEvent.x != mouseEvent.x || this.idEvent.y != mouseEvent.y) {
            this.idEvent = mouseEvent;
            int n = LogCDrawUtils.getNodeWidth();
            if (this.selectedColumnNode != null) {
                this.selectedColumnNode.setSelected(false);
                if (this.selectedColumnFigure != null) {
                    this.width = this.selectedColumnFigure.getWidth();
                    this.selectedColumnFigure.getMyCanvas().redraw(this.selectedColumnFigure.getXOffset() + (this.width - n) / 2 - 1, this.selectedColumnNode.getBeginPosition() - 1, n + 2, this.selectedColumnNode.getPositionRange() + 2, true);
                }
                this.selectedColumnNode = null;
                this.selectedColumnFigure = null;
            }
            if (this.selectedColumnFigure != null) {
                this.selectedColumnFigure.setSelected(false);
                this.selectedColumnFigure.getMyCanvas().redraw(this.selectedColumnFigure.getXOffset(), 0, this.selectedColumnFigure.getXOffset() + this.width, this.selectedColumnFigure.getHeight(), true);
                this.selectedColumnFigure = null;
            }
            if (this.selectedNodeLink != null) {
                this.selectedNodeLink.setSelected(false);
                this.updateUI();
                this.selectedNodeLink = null;
            }
        }
    }

    public void dispose() {
        this._viewsActions.clear();
        super.dispose();
    }

    public void controlMoved(ControlEvent controlEvent) {
    }

    public void controlResized(ControlEvent controlEvent) {
        Object object = controlEvent.getSource();
        if (object instanceof SDViewerUI) {
            Rectangle rectangle = this.getClientArea();
            int n = LogCDrawUtils.getWeightScaleWidth();
            this.drawAreaWeightScale.setSize(n, rectangle.height);
            this.graphComposite.setSize(rectangle.width - n, rectangle.height);
            this.canvas.setSize(rectangle.width - n, rectangle.height);
            int n2 = 0;
            while (n2 < this.graph.getTopNodeCount()) {
                ColumnFigure columnFigure = (ColumnFigure)this.graph.getTopNodes()[n2];
                columnFigure.setHeight(this.getClientArea().height);
                LogCDrawUtils.setBottomMax(this.getSize().y / LogCDrawUtils.getTimeUnit());
                ++n2;
            }
            this.adjustVScroll();
            this.adjustHScroll();
            this.update();
            this.drawAreaOverview.close();
            this.drawAreaOverview.adjustParentSize(this.getSize().x - this.graphComposite.getVerticalBar().getSize().x, this.getSize().y - this.graphComposite.getHorizontalBar().getSize().y);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        ScrollBar scrollBar = (ScrollBar)selectionEvent.getSource();
        if (scrollBar == this.graphComposite.getHorizontalBar()) {
            this.hScroll(scrollBar.getSelection());
        } else if (scrollBar == this.graphComposite.getVerticalBar()) {
            this.vScroll(scrollBar.getSelection());
        }
        this.update();
    }

    public void keyPressed(KeyEvent keyEvent) {
        ScrollBar scrollBar = this.graphComposite.getHorizontalBar();
        ScrollBar scrollBar2 = this.graphComposite.getVerticalBar();
        int n = LogCDrawUtils.getTimeUnit();
        int n2 = LogCDrawUtils.getBoxSpace();
        ColumnFigure columnFigure = null;
        switch (keyEvent.keyCode) {
            case 0x1000004: {
                if (scrollBar.getPageIncrement() == scrollBar.getMaximum()) break;
                int n3 = scrollBar.getSelection() + this.getColumnFigureAtLocation(5).getWidth();
                if (n3 > scrollBar.getMaximum()) {
                    n3 = scrollBar.getMaximum();
                }
                this.hScroll(n3);
                scrollBar.setSelection(n3);
                break;
            }
            case 0x1000003: {
                if (scrollBar.getSelection() <= 0) break;
                int n4 = scrollBar.getSelection() - this.getColumnFigureAtLocation(-5).getWidth();
                if (n4 < 0) {
                    n4 = 0;
                }
                this.hScroll(n4);
                scrollBar.setSelection(n4);
                break;
            }
            case 0x1000002: {
                if (this.endOfTime * n <= this.graphComposite.getSize().y) break;
                int n5 = scrollBar2.getSelection() + n;
                if (n5 > scrollBar2.getMaximum() - this.graphComposite.getSize().y / n) {
                    n5 = scrollBar2.getMaximum() - this.graphComposite.getSize().y / n;
                }
                this.vScroll(n5);
                scrollBar2.setSelection(n5);
                break;
            }
            case 0x1000001: {
                if (scrollBar2.getSelection() <= 0) break;
                int n6 = scrollBar2.getSelection() - n;
                if (n6 < 0) {
                    n6 = 0;
                }
                this.vScroll(n6);
                scrollBar2.setSelection(n6);
                break;
            }
            case 0x1000006: {
                if (this.endOfTime * n <= this.graphComposite.getSize().y) break;
                int n7 = scrollBar2.getSelection() + this.graphComposite.getSize().y / n;
                if (n7 > scrollBar2.getMaximum() - this.graphComposite.getSize().y / n) {
                    n7 = scrollBar2.getMaximum() - this.graphComposite.getSize().y / n;
                }
                this.vScroll(n7);
                scrollBar2.setSelection(n7);
                break;
            }
            case 0x1000005: {
                if (scrollBar2.getSelection() <= 0) break;
                int n8 = scrollBar2.getSelection() - this.graphComposite.getSize().y / n;
                if (n8 < 0) {
                    n8 = 0;
                }
                this.vScroll(n8);
                scrollBar2.setSelection(n8);
                break;
            }
            case 0x1000007: {
                if (this.selectedNodeLink == null) break;
                columnFigure = (ColumnFigure)((ColumnNode)this.selectedNodeLink.getSource()).getContainer();
                int n9 = columnFigure.getOriginalLocation().x;
                if (columnFigure.getIndexInContainer() > ((ColumnFigure)((ColumnNode)this.selectedNodeLink.getTarget()).getContainer()).getIndexInContainer()) {
                    n9 = n9 - this.graphComposite.getBounds().width + scrollBar2.getSize().x + ((ColumnFigure)((ColumnNode)this.selectedNodeLink.getSource()).getContainer()).getWidth();
                }
                if (n9 < 0) {
                    n9 = 0;
                }
                this.hScroll(n9);
                scrollBar.setSelection(n9);
                break;
            }
            case 0x1000008: {
                if (this.selectedNodeLink == null) break;
                columnFigure = (ColumnFigure)((ColumnNode)this.selectedNodeLink.getTarget()).getContainer();
                int n10 = columnFigure.getOriginalLocation().x;
                if (columnFigure.getIndexInContainer() > ((ColumnFigure)((ColumnNode)this.selectedNodeLink.getSource()).getContainer()).getIndexInContainer()) {
                    n10 = n10 - this.graphComposite.getBounds().width + scrollBar2.getSize().x + ((ColumnFigure)((ColumnNode)this.selectedNodeLink.getTarget()).getContainer()).getWidth();
                }
                if (n10 < 0) {
                    n10 = 0;
                }
                this.hScroll(n10);
                scrollBar.setSelection(n10);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
    }

    public ISelection getSelection() {
        if (this.selectedColumnNode != null && this.selectedColumnNode.getUserArea() != null) {
            return new StructuredSelection(this.selectedColumnNode.getUserArea());
        }
        if (this.selectedColumnFigure != null && this.selectedColumnFigure.getUserArea() != null) {
            return new StructuredSelection(this.selectedColumnFigure.getUserArea());
        }
        return new StructuredSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
    }

    public void setSelection(ISelection iSelection) {
    }

    public Canvas getCanvas() {
        return this.canvas;
    }
}

