/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.hyades.logging.core.ILogger;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public abstract class AbstractAccessLogParser
extends Parser {
    private static final String TARGET_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String TIME_STAMP_FORMAT = "dd/MMM/yyyy:HH:mm:ss";
    protected String host;
    protected String method;
    protected String file;
    protected String rcode;
    protected String fileSize;
    protected String userid;
    protected String message;
    protected StringBuffer creationTime;
    protected String productVersion;
    protected String sourceId;
    private String currentCreationTime = "";
    private long duplicateCreationTimeCounter = 0L;

    public void parse(ILogger iLogger) throws LogParserException {
        super.parse(iLogger);
        try {
            while (this.curLine != null) {
                this.reset();
                if (this.parseData()) {
                    IExtendedDataElement iExtendedDataElement;
                    this.messages[this.arrayIndex].init();
                    this.messages[this.arrayIndex].setSourceComponentId(Parser.eventFactory.createComponentIdentification());
                    this.messages[this.arrayIndex].getSourceComponentId().init();
                    this.messages[this.arrayIndex].setMsgDataElement(Parser.eventFactory.createMsgDataElement());
                    this.messages[this.arrayIndex].getMsgDataElement().init();
                    this.messages[this.arrayIndex].getSourceComponentId().setLocation(this.localHostId);
                    this.messages[this.arrayIndex].getSourceComponentId().setLocationType(this.localHostIdFormat);
                    this.messages[this.arrayIndex].getSourceComponentId().setComponent(this.sourceId);
                    StringBuffer stringBuffer = new StringBuffer(this.localHostId);
                    if (this.file_path != null) {
                        stringBuffer.append(' ');
                        stringBuffer.append(this.file_path);
                    }
                    if (this.localHostName != null) {
                        stringBuffer.append(' ');
                        stringBuffer.append(this.localHostName);
                    }
                    stringBuffer.append(' ');
                    if (this.currentCreationTime.equals(this.creationTime.toString().trim())) {
                        this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateCreationTimeCounter);
                    } else {
                        this.currentCreationTime = this.creationTime.toString().trim();
                        this.duplicateCreationTimeCounter = 0L;
                    }
                    this.messages[this.arrayIndex].getSourceComponentId().setSubComponent("Unknown");
                    this.messages[this.arrayIndex].getMsgDataElement().setMsgIdType("Not Applicable");
                    this.messages[this.arrayIndex].getMsgDataElement().setMsgId("None");
                    this.messages[this.arrayIndex].setCreationTime(this.creationTime.toString());
                    this.messages[this.arrayIndex].setMsg(this.message);
                    this.messages[this.arrayIndex].getMsgDataElement().setMsgLocale("en-US");
                    this.messages[this.arrayIndex].setSeverity((short)10);
                    if (this.method != null) {
                        iExtendedDataElement = Parser.createStringEDE("method", this.method);
                        this.messages[this.arrayIndex].addExtendedDataElement(iExtendedDataElement);
                    }
                    if (this.host != null) {
                        iExtendedDataElement = Parser.createStringEDE("client", this.host);
                        this.messages[this.arrayIndex].addExtendedDataElement(iExtendedDataElement);
                    }
                    if (this.file != null) {
                        iExtendedDataElement = Parser.createStringEDE("file", this.file);
                        this.messages[this.arrayIndex].addExtendedDataElement(iExtendedDataElement);
                    }
                    if (this.rcode != null) {
                        iExtendedDataElement = Parser.createStringEDE("return_code", this.rcode);
                        this.messages[this.arrayIndex].addExtendedDataElement(iExtendedDataElement);
                    }
                    if (this.fileSize != null) {
                        iExtendedDataElement = Parser.createStringEDE("file_size", this.fileSize);
                        this.messages[this.arrayIndex].addExtendedDataElement(iExtendedDataElement);
                    }
                    if (this.userid != null) {
                        iExtendedDataElement = Parser.createStringEDE("userid", this.userid);
                        this.messages[this.arrayIndex].addExtendedDataElement(iExtendedDataElement);
                    }
                    this.logger.write((Object)this.messages[this.arrayIndex]);
                }
                this.curLine = this.readLine();
            }
            this.writePartialArray();
        }
        catch (Throwable throwable) {
            LogParserException logParserException = new LogParserException(ParserUtilities.getResourceString("ACCESS_LOG_PARSER_ERROR_"), throwable);
            logParserException.fillInStackTrace();
            throw logParserException;
        }
    }

    protected boolean parseDate(int n, int n2) {
        ParsePosition parsePosition;
        SimpleDateFormat simpleDateFormat;
        Date date;
        String string = "";
        this.curLine = this.curLine.trim();
        this.curLine = this.curLine + "\n";
        if (this.isChar(this.curLine, n + 0, '[') && this.isNum(this.curLine, n + 1, 2) && this.isChar(this.curLine, n + 3, '/') && this.isLet(this.curLine, n + 4, 3) && this.isChar(this.curLine, n + 7, '/') && this.isNum(this.curLine, n + 8, 4) && this.isChar(this.curLine, n + 12, ':') && this.isNum(this.curLine, n + 13, 2) && this.isChar(this.curLine, n + 15, ':') && this.isNum(this.curLine, n + 16, 2) && this.isChar(this.curLine, n + 18, ':') && this.isNum(this.curLine, n + 19, 2) && this.isChar(this.curLine, n + 21, ' ') && (this.isChar(this.curLine, n + 22, '-') || this.isChar(this.curLine, n + 22, '+')) && this.isNum(this.curLine, n + 23, 4) && this.isChar(this.curLine, n + 27, ']') && (date = (simpleDateFormat = new SimpleDateFormat(TIME_STAMP_FORMAT, Locale.US)).parse(string = string + this.curLine.substring(1, 21), parsePosition = new ParsePosition(0))) != null) {
            char c = this.curLine.charAt(22);
            int n3 = Integer.parseInt(this.curLine.substring(23, 25));
            int n4 = Integer.parseInt(this.curLine.substring(25, 27));
            if (c == '+') {
                date.setTime(date.getTime());
            } else {
                date.setTime(date.getTime());
            }
            if (n2 == 0) {
                simpleDateFormat = new SimpleDateFormat(TARGET_FORMAT);
                this.creationTime = new StringBuffer(simpleDateFormat.format(date));
                this.creationTime.replace(10, 11, "T");
                this.creationTime.append(".000000");
                this.creationTime.append(c);
                String string2 = String.valueOf(n3);
                if (string2.length() == 1) {
                    this.creationTime.append("0");
                }
                this.creationTime.append(string2);
                this.creationTime.append(":");
                String string3 = String.valueOf(n4);
                if (string3.length() == 1) {
                    this.creationTime.append("0");
                }
                this.creationTime.append(string3);
                this.curLine = this.curLine.substring(28);
            }
            return true;
        }
        return false;
    }

    protected void reset() {
        this.userid = null;
        this.method = null;
        this.rcode = null;
        this.host = null;
        this.file = null;
        this.fileSize = null;
        this.message = null;
        this.creationTime = null;
    }

    protected boolean parseData() {
        this.curLine = this.curLine.trim();
        this.curLine = this.curLine + "\n";
        this.host = this.curLine.substring(0, this.curLine.indexOf(" "));
        this.curLine = this.curLine.substring(this.curLine.indexOf(" ")).trim() + "\n";
        this.curLine = this.curLine.substring(this.curLine.indexOf(" ")).trim() + "\n";
        this.userid = this.curLine.substring(0, this.curLine.indexOf(" "));
        if (this.userid.equals("-")) {
            this.userid = null;
        }
        this.curLine = this.curLine.substring(this.curLine.indexOf("["));
        this.curLine = this.curLine.trim();
        this.curLine = this.curLine + "\n";
        if (!this.parseDate(0, 0)) {
            return false;
        }
        this.curLine = this.curLine.trim();
        this.curLine = this.curLine + "\n";
        int n = this.curLine.indexOf(34);
        this.method = this.curLine.substring(n + 1, this.curLine.indexOf(" ", n + 1));
        this.message = this.curLine.substring(n).trim();
        this.curLine = this.curLine.substring(this.curLine.indexOf(32, n));
        this.curLine = this.curLine.trim();
        this.file = this.curLine.substring(0, this.curLine.indexOf(32));
        this.curLine = this.curLine.substring(this.curLine.indexOf(34) + 1);
        this.curLine = this.curLine.trim();
        this.rcode = this.curLine.substring(0, this.curLine.indexOf(32));
        this.curLine = this.curLine.substring(this.curLine.indexOf(32)).trim();
        int n2 = this.curLine.indexOf(32);
        this.fileSize = n2 != -1 ? this.curLine.substring(0, n2) : this.curLine.trim();
        return true;
    }
}

