/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.security.SecurityPlugin;
import org.eclipse.hyades.security.util.ConnectivityUI;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConnectivityDialog
extends Dialog {
    private ConnectivityUI _connectivityUI;
    private String fUserId;
    private String fPassword;
    private String fDescription;
    private boolean fSelectUserField = true;

    public ConnectivityDialog(Shell shell) {
        this(shell, "", "", true);
    }

    public ConnectivityDialog(Shell shell, String string) {
        this(shell, string, "", true);
    }

    public ConnectivityDialog(Shell shell, String string, boolean bl) {
        this(shell, string, "", bl);
    }

    public ConnectivityDialog(Shell shell, String string, String string2, boolean bl) {
        super(shell);
        this.fUserId = string;
        this.fPassword = string2;
        this.fSelectUserField = bl;
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(SecurityPlugin.getResourceString("SEC_MSG"));
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        GridData gridData = GridUtil.createFill();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this._connectivityUI = new ConnectivityUI(this.getShell());
        this._connectivityUI.setUserSelection(this.fSelectUserField);
        this._connectivityUI.setDescription(this.fDescription);
        this._connectivityUI.createContents(composite2);
        this._connectivityUI.setUserId(this.fUserId);
        this._connectivityUI.setPassword(this.fPassword);
        return composite2;
    }

    protected Control createButtonBar(Composite composite) {
        Control control = super.createButtonBar(composite);
        this.getShell().setDefaultButton(this.getButton(0));
        return control;
    }

    protected void okPressed() {
        this.fUserId = this._connectivityUI.getUserId();
        this.fPassword = this._connectivityUI.getPassword();
        if (this.fUserId.equals("")) {
            String string = SecurityPlugin.getResourceString("USER_TEXT_ERROR_");
            String string2 = SecurityPlugin.getResourceString("INVALID_SETTINGS");
            Status status = new Status(2, "org.eclipse.core.resources", 2, string, null);
            ErrorDialog.openError((Shell)SecurityPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string2, (IStatus)status);
            return;
        }
        if (this.fPassword.equals("")) {
            String string = SecurityPlugin.getResourceString("PWD_TEXT_ERROR_");
            String string3 = SecurityPlugin.getResourceString("INVALID_SETTINGS");
            Status status = new Status(2, "org.eclipse.core.resources", 2, string, null);
            ErrorDialog.openError((Shell)SecurityPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string3, (IStatus)status);
            return;
        }
        super.okPressed();
    }

    public String getUserId() {
        return this.fUserId;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public void setDescription(String string) {
        this.fDescription = string;
    }
}

