/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.eclipse.hyades.loaders.util.IXMLLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.XMLFragmentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class SAXFragmentHandler
extends DefaultHandler
implements XMLFragmentHandler {
    private InputSource inputSource = null;
    private ParserPipedInputStream xmlStream = null;
    private SAXParser parser;
    private Thread parseThread;
    private IXMLLoader handler;

    SAXFragmentHandler() {
    }

    public void setXMLLoader(IXMLLoader iXMLLoader) {
        try {
            this.parser = this.makeParser();
            this.xmlStream = new ParserPipedInputStream();
            this.parseThread = new Thread(Thread.currentThread().getThreadGroup(), "xmlParserThread"){

                public void run() {
                    if (SAXFragmentHandler.this.xmlStream == null) {
                        return;
                    }
                    SAXFragmentHandler.this.parse();
                }
            };
            this.parseThread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.handler = iXMLLoader;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.handler.characters(cArray, n, n2);
    }

    public void endDocument() throws SAXException {
        this.handler.endDocument(null, 0);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.handler.endElement(string3, 0);
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        return null;
    }

    public void scanContent(byte[] byArray, int n, int n2) throws InvalidXMLException {
        if (this.xmlStream != null) {
            this.xmlStream.writeBuf(byArray, n, n2);
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.handler.startDocument();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.handler.startElement(string3, false, attributes.getLength() == 0);
        int n = 0;
        while (n < attributes.getLength()) {
            this.handler.attributeName(attributes.getQName(n));
            this.handler.attributeValueCharacters(attributes.getValue(n));
            ++n;
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void terminateParser() {
        if (this.xmlStream != null) {
            this.xmlStream.makeClosed();
            this.xmlStream = null;
        }
        this.notifyAll();
        this.parseThread.interrupt();
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    protected SAXParser makeParser() throws ParserConfigurationException, SAXException {
        SAXParserFactoryImpl sAXParserFactoryImpl = new SAXParserFactoryImpl();
        sAXParserFactoryImpl.setValidating(false);
        return sAXParserFactoryImpl.newSAXParser();
    }

    protected synchronized void parse() throws InvalidXMLException {
        try {
            this.inputSource = new InputSource(this.xmlStream);
            this.parser.parse(this.inputSource, (DefaultHandler)this);
        }
        catch (Exception exception) {
            this.handler.error(new InvalidXMLException(exception));
        }
    }

    public static class ParserPipedInputStream
    extends InputStream {
        private byte[] inBuf;
        private boolean closed = false;
        private int inCount = 0;
        private long inTotalLength = 0L;
        private int inPos = 0;

        public int available() throws IOException {
            this.waitForNewData();
            return this.inCount;
        }

        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        public boolean hasEmptyBuffer() {
            return this.inCount == 0;
        }

        public synchronized void mark(int n) {
            super.mark(n);
        }

        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            --this.inCount;
            return this.inBuf[this.inPos++];
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            int n3 = Math.min(this.inCount, n2);
            System.arraycopy(this.inBuf, this.inPos, byArray, n, n3);
            this.inPos += n3;
            this.inCount -= n3;
            return n3;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public synchronized void reset() throws IOException {
            super.reset();
        }

        public long skip(long l) throws IOException {
            if ((l += (long)this.inPos) < this.inTotalLength) {
                this.inPos = (int)l;
                return l;
            }
            return -1L;
        }

        public synchronized void writeBuf(byte[] byArray, int n, int n2) {
            if (byArray == null || n2 == 0) {
                return;
            }
            this.inBuf = byArray;
            this.inPos = n;
            this.inTotalLength = n + n2;
            this.inCount = n2;
            this.notifyAll();
            this.waitForEmptyBuffer();
        }

        private synchronized void makeClosed() {
            this.inBuf = null;
            this.inCount = 0;
            this.inPos = 0;
            this.closed = true;
            this.notifyAll();
        }

        private void waitForEmptyBuffer() {
            while (!this.hasEmptyBuffer() && !this.closed) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    if (!this.hasEmptyBuffer() && !this.closed) continue;
                    return;
                }
            }
        }

        private synchronized void waitForNewData() {
            boolean bl = true;
            while (this.hasEmptyBuffer()) {
                if (bl) {
                    this.notifyAll();
                    bl = false;
                }
                if (this.closed) {
                    return;
                }
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    if (!this.closed) continue;
                    return;
                }
            }
        }
    }
}

