/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.util.EObjectsTraverser;
import org.eclipse.hyades.models.hierarchy.util.FastList;

public class ContainmentTraverser
extends EObjectsTraverser {
    private boolean resolve;
    private ChildrenListPool childrenPool;

    public ContainmentTraverser(Collection collection) {
        super(collection);
        this.resolve = true;
        this.childrenPool = new ChildrenListPool();
    }

    public ContainmentTraverser(Collection collection, boolean bl) {
        super(collection);
        this.resolve = bl;
        this.childrenPool = new ChildrenListPool();
    }

    protected boolean traverseEObject(EObject eObject) {
        List list = this.childrenPool.alloc();
        this.populateChildren(eObject, list);
        boolean bl = this.traverse(list);
        this.childrenPool.release(list);
        return bl;
    }

    private void populateChildren(EObject eObject, List list) {
        Iterator iterator = eObject.eClass().getEAllContainments().iterator();
        while (iterator.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
            if (!eObject.eIsSet(eStructuralFeature)) continue;
            Object object = eObject.eGet(eStructuralFeature, this.resolve);
            if (object instanceof EList) {
                Iterator iterator2 = this.getIterator((EList)object);
                while (iterator2.hasNext()) {
                    EObject eObject2 = (EObject)iterator2.next();
                    if (eObject2 == null) continue;
                    list.add(eObject2);
                }
                continue;
            }
            if (object == null) continue;
            list.add(object);
        }
    }

    protected Iterator getIterator(EList eList) {
        if (this.resolve) {
            return eList.iterator();
        }
        return ((InternalEList)eList).basicIterator();
    }

    protected EObject getElement(EObject eObject) {
        return eObject;
    }

    public static final class ChildrenListPool {
        private ArrayList lists = new ArrayList(20);
        private int currentEntryIndex = -1;

        public List alloc() {
            Object object;
            if (this.lists.size() == this.currentEntryIndex + 1) {
                object = new FastList();
                this.lists.add(object);
                ++this.currentEntryIndex;
            } else {
                ++this.currentEntryIndex;
                object = (List)this.lists.get(this.currentEntryIndex);
            }
            return object;
        }

        public void release(List list) {
            list.clear();
            --this.currentEntryIndex;
        }
    }
}

