/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;

public class SaveUtil {
    protected static final boolean debugSystemOut = false;
    private static Hashtable documentList = new Hashtable();

    public static void addDocument(Resource resource) {
        if (resource == null) {
            return;
        }
        documentList.put(resource.getURI(), resource);
    }

    public static final int documentsSize() {
        return documentList.size();
    }

    public static Hashtable getDocuments() {
        return documentList;
    }

    public static URI createURI(String string) {
        if (string.startsWith("platform:/resource")) {
            return URI.createURI((String)string);
        }
        if (string.startsWith("/")) {
            return URI.createURI((String)("platform:/resource" + string));
        }
        return URI.createURI((String)("platform:/resource/" + string));
    }

    public static void removeDocument(Resource resource) {
        if (resource == null) {
            return;
        }
        documentList.remove(resource.getURI());
    }

    public static void save(TRCMonitor tRCMonitor, IProgressMonitor iProgressMonitor) throws Exception {
        try {
            SaveUtil.saveResource(iProgressMonitor, tRCMonitor.eResource());
        }
        catch (Exception exception) {
            iProgressMonitor.done();
            throw exception;
        }
        EList eList = tRCMonitor.getNodes();
        int n = 0;
        while (n < eList.size()) {
            if (!((TRCNode)eList.get(n)).eIsProxy()) {
                SaveUtil.save((TRCNode)eList.get(n), iProgressMonitor);
            }
            ++n;
        }
    }

    public static void saveDocuments() throws Exception {
        SaveUtil.saveDocuments(null);
    }

    public static void saveDocuments(IProgressMonitor iProgressMonitor) throws Exception {
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask("Saving...", documentList.size());
        }
        if (!documentList.isEmpty()) {
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            hashMap.put("DECLARE_XML", Boolean.TRUE);
            Enumeration enumeration = documentList.elements();
            while (enumeration.hasMoreElements()) {
                XMIResource xMIResource = (XMIResource)enumeration.nextElement();
                try {
                    xMIResource.save(hashMap);
                }
                catch (Exception exception) {
                    if (iProgressMonitor != null) {
                        iProgressMonitor.done();
                    }
                    throw exception;
                }
            }
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }

    public static void saveResource(IProgressMonitor iProgressMonitor, Resource resource) throws Exception {
        if (iProgressMonitor != null) {
            iProgressMonitor.setTaskName(resource.getURI().path());
        }
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("DECLARE_XML", Boolean.TRUE);
        resource.save(hashMap);
        if (iProgressMonitor != null) {
            iProgressMonitor.worked(1);
        }
    }

    private static final void save(TRCAgent tRCAgent, IProgressMonitor iProgressMonitor) throws Exception {
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            SaveUtil.saveResource(iProgressMonitor, tRCAgent.eResource());
        }
        catch (Exception exception) {
            iProgressMonitor.done();
            throw exception;
        }
    }

    private static final void save(TRCNode tRCNode, IProgressMonitor iProgressMonitor) throws Exception {
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            SaveUtil.saveResource(iProgressMonitor, tRCNode.eResource());
        }
        catch (Exception exception) {
            iProgressMonitor.done();
            throw exception;
        }
        EList eList = tRCNode.getProcessProxies();
        int n = 0;
        while (n < eList.size()) {
            TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)eList.get(n);
            if (!tRCProcessProxy.eIsProxy()) {
                SaveUtil.save(tRCProcessProxy, iProgressMonitor);
            }
            ++n;
        }
    }

    private static final void save(TRCProcessProxy tRCProcessProxy, IProgressMonitor iProgressMonitor) throws Exception {
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            SaveUtil.saveResource(iProgressMonitor, tRCProcessProxy.eResource());
        }
        catch (Exception exception) {
            iProgressMonitor.done();
            throw exception;
        }
        EList eList = tRCProcessProxy.getAgentProxies();
        int n = 0;
        while (n < eList.size()) {
            TRCAgent tRCAgent = ((TRCAgentProxy)eList.get(n)).getAgent();
            if (!tRCAgent.eIsProxy()) {
                SaveUtil.save(tRCAgent, iProgressMonitor);
            }
            ++n;
        }
    }
}

