/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.trace.internal.loader;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.sd.ui.internal.model.Graph;
import org.eclipse.hyades.sd.ui.internal.model.GraphNode;
import org.eclipse.hyades.sd.ui.internal.model.NodeConnection;
import org.eclipse.hyades.sd.ui.internal.model.NodeContainer;

public class TRCModelLoaderUtility {
    protected Graph graph = null;
    protected Hashtable containers = new Hashtable();
    protected Hashtable nodes = new Hashtable();
    protected Hashtable agents = new Hashtable();
    protected TRCAgentProxy[] agentList = new TRCAgentProxy[3];
    protected int nextAgent = 0;
    protected double oldestEndTime = 0.0;
    protected String unknownString = "_unknown";

    protected void setGraph(Graph graph) {
        this.graph = graph;
    }

    protected Graph getGraph() {
        return this.graph;
    }

    protected NodeContainer resolveContainer(TRCMethodInvocation tRCMethodInvocation, int n) {
        NodeContainer nodeContainer = null;
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 15: {
                nodeContainer = this.resolveToNode(tRCMethodInvocation);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 20: {
                nodeContainer = this.resolveToAgent(tRCMethodInvocation);
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 19: {
                nodeContainer = this.resolveToProcess(tRCMethodInvocation);
                break;
            }
            case 10: 
            case 14: 
            case 18: {
                nodeContainer = this.resolveToThread(tRCMethodInvocation);
                break;
            }
            case 16: {
                nodeContainer = this.resolveToObject(tRCMethodInvocation);
                break;
            }
            default: {
                nodeContainer = this.resolveToClass(tRCMethodInvocation);
            }
        }
        return nodeContainer;
    }

    protected NodeContainer resolveToMonitor(TRCMethodInvocation tRCMethodInvocation) {
        NodeContainer nodeContainer = null;
        TRCMonitor tRCMonitor = tRCMethodInvocation.getThread().getProcess().getAgent().getAgentProxy().getProcessProxy().getNode().getMonitor();
        nodeContainer = (NodeContainer)this.containers.get(tRCMonitor);
        if (nodeContainer == null) {
            nodeContainer = this.addTopNode(tRCMonitor);
            this.containers.put(tRCMonitor, nodeContainer);
        }
        return nodeContainer;
    }

    protected NodeContainer resolveToNode(TRCMethodInvocation tRCMethodInvocation) {
        NodeContainer nodeContainer = null;
        TRCNode tRCNode = tRCMethodInvocation.getThread().getProcess().getAgent().getAgentProxy().getProcessProxy().getNode();
        nodeContainer = (NodeContainer)this.containers.get(tRCNode);
        if (nodeContainer == null) {
            nodeContainer = this.addTopNode(tRCNode, tRCMethodInvocation);
            this.containers.put(tRCNode, nodeContainer);
        }
        return nodeContainer;
    }

    protected NodeContainer resolveToAgent(TRCMethodInvocation tRCMethodInvocation) {
        NodeContainer nodeContainer = null;
        TRCAgent tRCAgent = tRCMethodInvocation.getThread().getProcess().getAgent();
        nodeContainer = (NodeContainer)this.containers.get(tRCAgent);
        if (nodeContainer == null) {
            nodeContainer = this.addTopNode(tRCAgent, tRCMethodInvocation);
            this.containers.put(tRCAgent, nodeContainer);
        }
        return nodeContainer;
    }

    protected NodeContainer resolveToProcess(TRCMethodInvocation tRCMethodInvocation) {
        NodeContainer nodeContainer = null;
        TRCProcess tRCProcess = tRCMethodInvocation.getThread().getProcess();
        nodeContainer = (NodeContainer)this.containers.get(tRCProcess);
        if (nodeContainer == null) {
            nodeContainer = this.addTopNode(tRCProcess, tRCMethodInvocation);
            this.containers.put(tRCProcess, nodeContainer);
        }
        return nodeContainer;
    }

    protected NodeContainer resolveToThread(TRCMethodInvocation tRCMethodInvocation) {
        NodeContainer nodeContainer = null;
        TRCThread tRCThread = tRCMethodInvocation.getThread();
        nodeContainer = (NodeContainer)this.containers.get(tRCThread);
        if (nodeContainer == null) {
            nodeContainer = this.addTopNode(tRCThread, tRCMethodInvocation);
            this.containers.put(tRCThread, nodeContainer);
        }
        return nodeContainer;
    }

    protected NodeContainer resolveToClass(TRCMethodInvocation tRCMethodInvocation) {
        NodeContainer nodeContainer = null;
        TRCClass tRCClass = this.getClass(tRCMethodInvocation);
        nodeContainer = (NodeContainer)this.containers.get(tRCClass);
        if (nodeContainer == null) {
            nodeContainer = this.addTopNode(tRCClass, tRCMethodInvocation);
            this.containers.put(tRCClass, nodeContainer);
        }
        return nodeContainer;
    }

    protected NodeContainer resolveToObject(TRCMethodInvocation tRCMethodInvocation) {
        NodeContainer nodeContainer = null;
        TRCTraceObject tRCTraceObject = tRCMethodInvocation.getOwningObject();
        nodeContainer = (NodeContainer)this.containers.get(tRCTraceObject);
        if (nodeContainer == null) {
            nodeContainer = this.addTopNode((TRCObject)tRCTraceObject, tRCMethodInvocation);
            this.containers.put(tRCTraceObject, nodeContainer);
        }
        return nodeContainer;
    }

    protected void resolveMethodNode(TRCMethodInvocation tRCMethodInvocation, NodeContainer nodeContainer) {
        if (!(tRCMethodInvocation instanceof TRCFullMethodInvocation) || !this.invocationIsOfInterest(tRCMethodInvocation)) {
            return;
        }
        GraphNode graphNode = null;
        TRCFullMethodInvocation tRCFullMethodInvocation = (TRCFullMethodInvocation)tRCMethodInvocation;
        graphNode = (GraphNode)this.nodes.get(tRCFullMethodInvocation);
        if (graphNode == null) {
            graphNode = this.addNode(this.resolveFullMethodName((TRCMethodInvocation)tRCFullMethodInvocation), tRCFullMethodInvocation.getMethod().getName(), String.valueOf(tRCFullMethodInvocation.getTicket()), 8, nodeContainer);
            graphNode.setStartTime(tRCFullMethodInvocation.getEntryTime() + this.getAgentDelta(tRCFullMethodInvocation.getThread().getProcess().getAgent().getAgentProxy()));
            if (tRCFullMethodInvocation.getExitTime() != 0.0) {
                graphNode.setEndTime(tRCFullMethodInvocation.getExitTime() + this.getAgentDelta(tRCFullMethodInvocation.getThread().getProcess().getAgent().getAgentProxy()));
                this.setOldestEndTime(graphNode.getEndTime());
            } else {
                this.setOldestEndTime(graphNode.getStartTime());
                graphNode.setEndTime(this.getOldestEndTime());
            }
            this.nodes.put(tRCFullMethodInvocation, graphNode);
            graphNode.setUserArea((Object)tRCFullMethodInvocation);
        }
    }

    private boolean invocationIsOfInterest(TRCMethodInvocation tRCMethodInvocation) {
        if (!this.graph.getFiltered()) {
            return true;
        }
        boolean bl = true;
        switch (this.getGraph().getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 15: {
                bl = this.isOnNodeBoundary(tRCMethodInvocation);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 20: {
                bl = this.isOnAgentBoundary(tRCMethodInvocation);
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 19: {
                bl = this.isOnProcessBoundary(tRCMethodInvocation);
                break;
            }
            case 10: 
            case 14: 
            case 18: {
                bl = this.isOnThreadBoundary(tRCMethodInvocation);
                break;
            }
            case 16: {
                if (this.resolveType((TRCObject)tRCMethodInvocation.getOwningObject()) == 6) {
                    bl = this.isOnObjectBoundary(tRCMethodInvocation);
                    break;
                }
                if (this.resolveType((TRCObject)tRCMethodInvocation.getOwningObject()) != 7) break;
                bl = this.isOnClassBoundary(tRCMethodInvocation);
                break;
            }
            case 17: {
                bl = this.isOnClassNameBoundary(tRCMethodInvocation);
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private boolean isOnClassBoundary(TRCMethodInvocation tRCMethodInvocation) {
        TRCClass tRCClass = tRCMethodInvocation.getMethod().getDefiningClass();
        if (tRCMethodInvocation.getInvokedBy() != null) {
            if (tRCMethodInvocation.getInvokedBy() != null && !tRCMethodInvocation.getInvokedBy().getMethod().getDefiningClass().getName().equals(tRCClass.getName())) {
                return true;
            }
        } else {
            return true;
        }
        Iterator iterator = tRCMethodInvocation.getInvokes().iterator();
        while (iterator.hasNext()) {
            TRCMethodInvocation tRCMethodInvocation2 = (TRCMethodInvocation)iterator.next();
            if (tRCMethodInvocation2 == null) continue;
            if (!tRCMethodInvocation2.getMethod().getDefiningClass().getName().equals(tRCClass.getName())) {
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isOnClassNameBoundary(TRCMethodInvocation tRCMethodInvocation) {
        TRCClass tRCClass = tRCMethodInvocation.getMethod().getDefiningClass();
        if (tRCMethodInvocation.getInvokedBy() != null) {
            if (!tRCMethodInvocation.getInvokedBy().getMethod().getDefiningClass().getName().startsWith(tRCClass.getName()) && !tRCClass.getName().startsWith(tRCMethodInvocation.getInvokedBy().getMethod().getDefiningClass().getName())) {
                return true;
            }
        } else {
            return true;
        }
        Iterator iterator = tRCMethodInvocation.getInvokes().iterator();
        while (iterator.hasNext()) {
            TRCMethodInvocation tRCMethodInvocation2 = (TRCMethodInvocation)iterator.next();
            if (tRCMethodInvocation2 == null) continue;
            if (!tRCMethodInvocation2.getMethod().getDefiningClass().getName().startsWith(tRCClass.getName()) && !tRCClass.getName().startsWith(tRCMethodInvocation2.getMethod().getDefiningClass().getName())) {
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isOnObjectBoundary(TRCMethodInvocation tRCMethodInvocation) {
        TRCTraceObject tRCTraceObject = tRCMethodInvocation.getOwningObject();
        if (tRCMethodInvocation.getInvokedBy() != null) {
            if (tRCMethodInvocation.getInvokedBy() != null && tRCMethodInvocation.getInvokedBy().getOwningObject() != tRCTraceObject) {
                return true;
            }
        } else {
            return true;
        }
        Iterator iterator = tRCMethodInvocation.getInvokes().iterator();
        while (iterator.hasNext()) {
            TRCMethodInvocation tRCMethodInvocation2 = (TRCMethodInvocation)iterator.next();
            if (tRCMethodInvocation2 == null) continue;
            if (tRCMethodInvocation2.getOwningObject() != tRCTraceObject) {
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isOnThreadBoundary(TRCMethodInvocation tRCMethodInvocation) {
        TRCThread tRCThread = tRCMethodInvocation.getThread();
        if (tRCMethodInvocation.getInvokedBy() != null) {
            if (tRCMethodInvocation.getInvokedBy() != null && tRCMethodInvocation.getInvokedBy().getThread() != tRCThread) {
                return true;
            }
        } else {
            return true;
        }
        Iterator iterator = tRCMethodInvocation.getInvokes().iterator();
        while (iterator.hasNext()) {
            TRCMethodInvocation tRCMethodInvocation2 = (TRCMethodInvocation)iterator.next();
            if (tRCMethodInvocation2 == null) continue;
            if (tRCMethodInvocation2.getThread() != tRCThread) {
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isOnProcessBoundary(TRCMethodInvocation tRCMethodInvocation) {
        TRCProcess tRCProcess = tRCMethodInvocation.getThread().getProcess();
        if (tRCMethodInvocation.getInvokedBy() != null) {
            if (tRCMethodInvocation.getInvokedBy() != null && tRCMethodInvocation.getInvokedBy().getThread().getProcess() != tRCProcess) {
                return true;
            }
        } else {
            return true;
        }
        Iterator iterator = tRCMethodInvocation.getInvokes().iterator();
        while (iterator.hasNext()) {
            TRCMethodInvocation tRCMethodInvocation2 = (TRCMethodInvocation)iterator.next();
            if (tRCMethodInvocation2 == null) continue;
            if (tRCMethodInvocation2.getThread().getProcess() != tRCProcess) {
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isOnAgentBoundary(TRCMethodInvocation tRCMethodInvocation) {
        TRCAgent tRCAgent = tRCMethodInvocation.getThread().getProcess().getAgent();
        if (tRCMethodInvocation.getInvokedBy() != null) {
            if (tRCMethodInvocation.getInvokedBy() != null && tRCMethodInvocation.getInvokedBy().getThread().getProcess().getAgent() != tRCAgent) {
                return true;
            }
        } else {
            return true;
        }
        Iterator iterator = tRCMethodInvocation.getInvokes().iterator();
        while (iterator.hasNext()) {
            TRCMethodInvocation tRCMethodInvocation2 = (TRCMethodInvocation)iterator.next();
            if (tRCMethodInvocation2 == null) continue;
            if (tRCMethodInvocation2.getThread().getProcess().getAgent() != tRCAgent) {
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isOnNodeBoundary(TRCMethodInvocation tRCMethodInvocation) {
        TRCNode tRCNode = tRCMethodInvocation.getThread().getProcess().getAgent().getAgentProxy().getProcessProxy().getNode();
        if (tRCMethodInvocation.getInvokedBy() != null) {
            if (tRCMethodInvocation.getInvokedBy() != null && tRCMethodInvocation.getInvokedBy().getThread().getProcess().getAgent().getAgentProxy().getProcessProxy().getNode() != tRCNode) {
                return true;
            }
        } else {
            return true;
        }
        Iterator iterator = tRCMethodInvocation.getInvokes().iterator();
        while (iterator.hasNext()) {
            TRCMethodInvocation tRCMethodInvocation2 = (TRCMethodInvocation)iterator.next();
            if (tRCMethodInvocation2 == null) continue;
            if (tRCMethodInvocation2.getThread().getProcess().getAgent().getAgentProxy().getProcessProxy().getNode() != tRCNode) {
                return true;
            }
            return true;
        }
        return false;
    }

    private StringBuffer appendNodeName(StringBuffer stringBuffer, TRCMethodInvocation tRCMethodInvocation) {
        if (tRCMethodInvocation.getThread().getProcess().getAgent().getAgentProxy().getProcessProxy().getNode().getMonitor().getNodes().size() > 1) {
            stringBuffer.append(tRCMethodInvocation.getThread().getProcess().getAgent().getAgentProxy().getProcessProxy().getNode().getName());
            stringBuffer.append(":");
        }
        return stringBuffer;
    }

    private StringBuffer appendProcessName(StringBuffer stringBuffer, TRCMethodInvocation tRCMethodInvocation) {
        if (tRCMethodInvocation.getThread().getProcess().getName() != null) {
            stringBuffer.append(tRCMethodInvocation.getThread().getProcess().getName());
        } else {
            stringBuffer.append(this.unknownString);
        }
        return stringBuffer;
    }

    private StringBuffer appendProcessId(StringBuffer stringBuffer, TRCMethodInvocation tRCMethodInvocation) {
        if (tRCMethodInvocation.getThread().getProcess().getAgent().getAgentProxy().getProcessProxy().getNode().getProcessProxies().size() > 1) {
            if (tRCMethodInvocation.getThread().getProcess().getAgent().getAgentProxy().getProcessProxy().getPid() != 0) {
                stringBuffer.append(tRCMethodInvocation.getThread().getProcess().getAgent().getAgentProxy().getProcessProxy().getPid());
            } else {
                stringBuffer.append(this.unknownString);
            }
            stringBuffer.append(":");
        }
        return stringBuffer;
    }

    private StringBuffer appendThreadName(StringBuffer stringBuffer, TRCMethodInvocation tRCMethodInvocation) {
        if (tRCMethodInvocation.getThread().getName() != null) {
            stringBuffer.append(tRCMethodInvocation.getThread().getName());
        } else {
            stringBuffer.append(this.unknownString);
        }
        return stringBuffer;
    }

    private StringBuffer appendThreadId(StringBuffer stringBuffer, TRCMethodInvocation tRCMethodInvocation) {
        if (tRCMethodInvocation.getThread().getProcess().getThreads().size() > 1) {
            if (tRCMethodInvocation.getThread().getName() != null) {
                stringBuffer.append(tRCMethodInvocation.getThread().getName());
            } else {
                stringBuffer.append(tRCMethodInvocation.getThread().getId());
            }
            stringBuffer.append(":");
        }
        return stringBuffer;
    }

    private String resolveFullContainerName(TRCMethodInvocation tRCMethodInvocation) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.getGraph().getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 15: {
                stringBuffer.append(tRCMethodInvocation.getThread().getProcess().getAgent().getAgentProxy().getProcessProxy().getNode().getName());
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 19: 
            case 20: {
                this.appendNodeName(stringBuffer, tRCMethodInvocation);
                this.appendProcessName(stringBuffer, tRCMethodInvocation);
                break;
            }
            case 10: 
            case 14: 
            case 18: {
                this.appendNodeName(stringBuffer, tRCMethodInvocation);
                this.appendProcessId(stringBuffer, tRCMethodInvocation);
                this.appendThreadName(stringBuffer, tRCMethodInvocation);
                break;
            }
            case 16: {
                if (tRCMethodInvocation.getOwningObject().getIsA() != null) {
                    this.appendNodeName(stringBuffer, tRCMethodInvocation);
                    this.appendProcessId(stringBuffer, tRCMethodInvocation);
                    this.appendThreadId(stringBuffer, tRCMethodInvocation);
                    stringBuffer.append(tRCMethodInvocation.getMethod().getDefiningClass().getName());
                    break;
                }
                stringBuffer = this.appendNodeName(stringBuffer, tRCMethodInvocation);
                this.appendProcessId(stringBuffer, tRCMethodInvocation);
                this.appendThreadId(stringBuffer, tRCMethodInvocation);
                stringBuffer.append(tRCMethodInvocation.getMethod().getDefiningClass().getName());
                break;
            }
            case 17: {
                this.appendNodeName(stringBuffer, tRCMethodInvocation);
                this.appendProcessId(stringBuffer, tRCMethodInvocation);
                this.appendThreadId(stringBuffer, tRCMethodInvocation);
                stringBuffer.append(tRCMethodInvocation.getMethod().getDefiningClass().getName());
                break;
            }
            default: {
                stringBuffer.append(tRCMethodInvocation.getMethod().getName());
            }
        }
        return stringBuffer.toString();
    }

    private String resolveFullMethodName(TRCMethodInvocation tRCMethodInvocation) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.getGraph().getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 15: {
                this.appendProcessId(stringBuffer, tRCMethodInvocation);
                this.appendThreadId(stringBuffer, tRCMethodInvocation);
                stringBuffer.append(tRCMethodInvocation.getMethod().getDefiningClass().getName());
                stringBuffer.append(".");
                stringBuffer.append(tRCMethodInvocation.getMethod().getName());
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 19: 
            case 20: {
                this.appendThreadId(stringBuffer, tRCMethodInvocation);
                stringBuffer.append(tRCMethodInvocation.getMethod().getDefiningClass().getName());
                stringBuffer.append(".");
                stringBuffer.append(tRCMethodInvocation.getMethod().getName());
                break;
            }
            case 10: 
            case 14: 
            case 18: {
                stringBuffer.append(tRCMethodInvocation.getMethod().getDefiningClass().getName());
                stringBuffer.append(".");
                stringBuffer.append(tRCMethodInvocation.getMethod().getName());
                break;
            }
            case 16: {
                if (tRCMethodInvocation.getOwningObject().getIsA() != null) {
                    stringBuffer.append(tRCMethodInvocation.getMethod().getName());
                    break;
                }
                stringBuffer.append(tRCMethodInvocation.getMethod().getName());
                break;
            }
            case 17: {
                stringBuffer.append(tRCMethodInvocation.getMethod().getName());
                break;
            }
            default: {
                stringBuffer.append(tRCMethodInvocation.getMethod().getName());
            }
        }
        return stringBuffer.toString();
    }

    protected String createTypeName(TRCObject tRCObject) {
        return tRCObject.getIsA().getName();
    }

    protected String createShortClassName(String string) {
        if (string.lastIndexOf("/") > -1) {
            return string.substring(string.lastIndexOf("/") + 1);
        }
        if (string.lastIndexOf(".") > -1) {
            return string.substring(string.lastIndexOf(".") + 1);
        }
        if (string.indexOf(":") > -1) {
            return string.substring(string.lastIndexOf(":") + 1);
        }
        return string;
    }

    protected String createShortNodeName(String string) {
        if (string.indexOf("/") > -1) {
            return string.substring(0, string.lastIndexOf("/"));
        }
        if (string.indexOf(":") > -1) {
            return string.substring(string.lastIndexOf(":") + 1);
        }
        if (string.indexOf(".") > -1) {
            return string.substring(0, string.lastIndexOf("."));
        }
        return string;
    }

    protected String createSecondaryName(TRCObject tRCObject) {
        if (tRCObject.getId() == 0L) {
            return this.unknownString;
        }
        return String.valueOf(tRCObject.getId());
    }

    protected NodeContainer addTopNode(TRCObject tRCObject, TRCMethodInvocation tRCMethodInvocation) {
        NodeContainer nodeContainer = null;
        if (this.resolveType(tRCObject) == 6) {
            nodeContainer = this.graph.getContentFactory().createNodeContainer();
            nodeContainer.setName(this.resolveFullContainerName(tRCMethodInvocation));
            nodeContainer.setShortName(this.createShortClassName(nodeContainer.getName()));
            nodeContainer.setSecondaryName(this.createSecondaryName(tRCObject));
            nodeContainer.setType(this.resolveType(tRCObject));
            this.graph.addTopNode((GraphNode)nodeContainer);
            nodeContainer.setGraph(this.graph);
        } else if (this.resolveType(tRCObject) == 7) {
            nodeContainer = this.addTopNode(this.getClass(tRCMethodInvocation), tRCMethodInvocation);
        }
        nodeContainer.setUserArea((Object)tRCObject);
        return nodeContainer;
    }

    protected NodeContainer addTopNode(TRCClass tRCClass, TRCMethodInvocation tRCMethodInvocation) {
        NodeContainer nodeContainer = this.graph.getContentFactory().createNodeContainer();
        nodeContainer.setUserArea((Object)tRCClass);
        nodeContainer.setName(this.resolveFullContainerName(tRCMethodInvocation));
        nodeContainer.setShortName(this.createShortClassName(nodeContainer.getName()));
        nodeContainer.setSecondaryName(String.valueOf(tRCClass.getId()));
        nodeContainer.setType(7);
        this.graph.addTopNode((GraphNode)nodeContainer);
        nodeContainer.setGraph(this.graph);
        return nodeContainer;
    }

    protected NodeContainer addTopNode(TRCThread tRCThread, TRCMethodInvocation tRCMethodInvocation) {
        NodeContainer nodeContainer = this.graph.getContentFactory().createNodeContainer();
        nodeContainer.setName(this.resolveFullContainerName(tRCMethodInvocation));
        nodeContainer.setShortName(this.createShortNodeName(nodeContainer.getName()));
        if (tRCThread.getId() == 0) {
            nodeContainer.setSecondaryName(this.unknownString);
        } else {
            nodeContainer.setSecondaryName(String.valueOf(tRCThread.getId()));
        }
        nodeContainer.setType(5);
        this.graph.addTopNode((GraphNode)nodeContainer);
        nodeContainer.setGraph(this.graph);
        return nodeContainer;
    }

    protected NodeContainer addTopNode(TRCProcess tRCProcess, TRCMethodInvocation tRCMethodInvocation) {
        NodeContainer nodeContainer = this.graph.getContentFactory().createNodeContainer();
        if (tRCProcess.getAgent().getAgentProxy().getProcessProxy().getName() == null) {
            nodeContainer.setName(this.unknownString);
        } else {
            nodeContainer.setName(this.resolveFullContainerName(tRCMethodInvocation));
        }
        nodeContainer.setShortName(this.createShortNodeName(nodeContainer.getName()));
        if (tRCProcess.getAgent().getAgentProxy().getProcessProxy().getPid() == 0) {
            nodeContainer.setSecondaryName(this.unknownString);
        } else {
            nodeContainer.setSecondaryName(String.valueOf(tRCProcess.getAgent().getAgentProxy().getProcessProxy().getPid()));
        }
        nodeContainer.setType(4);
        this.graph.addTopNode((GraphNode)nodeContainer);
        nodeContainer.setGraph(this.graph);
        return nodeContainer;
    }

    protected NodeContainer addTopNode(TRCAgent tRCAgent, TRCMethodInvocation tRCMethodInvocation) {
        NodeContainer nodeContainer = this.graph.getContentFactory().createNodeContainer();
        if (tRCAgent.getName() == null) {
            nodeContainer.setName(this.unknownString);
        } else {
            nodeContainer.setName(this.resolveFullContainerName(tRCMethodInvocation));
        }
        nodeContainer.setShortName(this.createShortClassName(nodeContainer.getName()));
        if (tRCAgent.getRuntimeId() == null) {
            nodeContainer.setSecondaryName(this.unknownString);
        } else {
            nodeContainer.setSecondaryName(tRCAgent.getRuntimeId());
        }
        nodeContainer.setType(3);
        this.graph.addTopNode((GraphNode)nodeContainer);
        nodeContainer.setGraph(this.graph);
        return nodeContainer;
    }

    protected NodeContainer addTopNode(TRCNode tRCNode, TRCMethodInvocation tRCMethodInvocation) {
        NodeContainer nodeContainer = this.graph.getContentFactory().createNodeContainer();
        if (tRCNode.getName() == null) {
            nodeContainer.setName(this.unknownString);
        } else {
            nodeContainer.setName(this.resolveFullContainerName(tRCMethodInvocation));
        }
        nodeContainer.setShortName(this.createShortNodeName(nodeContainer.getName()));
        if (tRCNode.getIpAddress() == null) {
            nodeContainer.setSecondaryName(this.unknownString);
        } else {
            nodeContainer.setSecondaryName(tRCNode.getIpAddress());
        }
        nodeContainer.setType(2);
        this.graph.addTopNode((GraphNode)nodeContainer);
        nodeContainer.setGraph(this.graph);
        return nodeContainer;
    }

    protected NodeContainer addTopNode(TRCMonitor tRCMonitor) {
        NodeContainer nodeContainer = this.graph.getContentFactory().createNodeContainer();
        if (tRCMonitor.getName() == null) {
            nodeContainer.setName(this.unknownString);
        } else {
            nodeContainer.setName(tRCMonitor.getName());
        }
        nodeContainer.setShortName(this.createShortNodeName(nodeContainer.getName()));
        if (tRCMonitor.getName() == null) {
            nodeContainer.setSecondaryName(this.unknownString);
        } else {
            nodeContainer.setSecondaryName(tRCMonitor.getName());
        }
        nodeContainer.setType(9);
        this.graph.addTopNode((GraphNode)nodeContainer);
        nodeContainer.setGraph(this.graph);
        return nodeContainer;
    }

    protected GraphNode addNode(String string, String string2, String string3, int n, NodeContainer nodeContainer) {
        GraphNode graphNode = this.graph.getContentFactory().createGraphNode();
        graphNode.setName(string);
        graphNode.setShortName(string2);
        graphNode.setSecondaryName(string3);
        graphNode.setType(n);
        nodeContainer.addInternalNode(graphNode);
        graphNode.setContainer(nodeContainer);
        return graphNode;
    }

    protected void addNodeConnections(TRCMethodInvocation tRCMethodInvocation) {
        NodeConnection nodeConnection = null;
        GraphNode graphNode = (GraphNode)this.nodes.get(tRCMethodInvocation);
        GraphNode graphNode2 = null;
        double d = 0.0;
        Iterator iterator = tRCMethodInvocation.getInvokes().iterator();
        while (iterator.hasNext()) {
            TRCMethodInvocation tRCMethodInvocation2 = (TRCMethodInvocation)iterator.next();
            if (!(tRCMethodInvocation2 instanceof TRCFullMethodInvocation) || tRCMethodInvocation2 == null) continue;
            TRCFullMethodInvocation tRCFullMethodInvocation = (TRCFullMethodInvocation)tRCMethodInvocation2;
            d = this.getAgentDelta(tRCFullMethodInvocation.getThread().getProcess().getAgent().getAgentProxy());
            graphNode2 = (GraphNode)this.nodes.get(tRCFullMethodInvocation);
            if (graphNode2 != null) {
                if (this.graph.getFiltered() && graphNode.getContainer() == graphNode2.getContainer()) {
                    return;
                }
                if (tRCFullMethodInvocation.getEntryTime() != 0.0) {
                    nodeConnection = this.graph.createNodeConnection();
                    nodeConnection.setName(graphNode2.getName());
                    nodeConnection.setShortName(graphNode2.getShortName());
                    nodeConnection.setSecondaryName(graphNode2.getSecondaryName());
                    nodeConnection.setTarget(graphNode2);
                    nodeConnection.setSource(graphNode);
                    nodeConnection.setType(5);
                    if (graphNode2.getStartTime() >= tRCFullMethodInvocation.getEntryTime() + d) {
                        nodeConnection.setEndIncrement(graphNode2.getStartIncrement());
                    } else {
                        nodeConnection.setEndTime(tRCFullMethodInvocation.getEntryTime() + d);
                    }
                    nodeConnection.setStartIncrement(nodeConnection.getEndIncrement());
                    if (nodeConnection.getStartTime() > graphNode.getEndTime()) {
                        graphNode.setEndIncrement(nodeConnection.getStartIncrement());
                    }
                    graphNode2.addTargetConnection(nodeConnection);
                    graphNode.addSourceConnection(nodeConnection);
                }
                if (tRCFullMethodInvocation.getExitTime() == 0.0) continue;
                nodeConnection = this.graph.createNodeConnection();
                nodeConnection.setName(graphNode2.getName() + " return");
                nodeConnection.setShortName(graphNode2.getShortName());
                nodeConnection.setSecondaryName(graphNode2.getSecondaryName());
                nodeConnection.setTarget(graphNode);
                nodeConnection.setSource(graphNode2);
                nodeConnection.setType(7);
                if (graphNode2.getEndTime() > tRCFullMethodInvocation.getExitTime() + d) {
                    nodeConnection.setStartTime(tRCFullMethodInvocation.getExitTime() + d);
                } else {
                    nodeConnection.setStartIncrement(graphNode2.getEndIncrement());
                }
                nodeConnection.setEndIncrement(nodeConnection.getStartIncrement());
                if (nodeConnection.getEndTime() > graphNode.getEndTime()) {
                    graphNode.setEndIncrement(nodeConnection.getEndIncrement());
                }
                graphNode.addTargetConnection(nodeConnection);
                graphNode2.addSourceConnection(nodeConnection);
                continue;
            }
            graphNode2 = null;
        }
    }

    protected int resolveType(TRCObject tRCObject) {
        if (tRCObject.getProcess().getClassClass() == tRCObject.getIsA()) {
            return 7;
        }
        return 6;
    }

    protected void resolveConnections() {
        Enumeration enumeration = this.nodes.keys();
        while (enumeration.hasMoreElements()) {
            this.addNodeConnections((TRCMethodInvocation)enumeration.nextElement());
        }
    }

    protected void setOldestEndTime(double d) {
        if (d > this.oldestEndTime) {
            this.oldestEndTime = d;
        }
    }

    protected double getOldestEndTime() {
        return this.oldestEndTime;
    }

    protected double getAgentDelta(TRCAgentProxy tRCAgentProxy) {
        double d = this.agents.containsKey(tRCAgentProxy) ? (Double)this.agents.get(tRCAgentProxy) + tRCAgentProxy.getProcessProxy().getNode().getDeltaTime() : 0.0;
        return d;
    }

    protected void addAgent(TRCAgentProxy tRCAgentProxy) {
        if (this.agents.containsKey(tRCAgentProxy)) {
            return;
        }
        this.agents.put(tRCAgentProxy, new Double(0.0));
        try {
            this.agentList[this.nextAgent] = tRCAgentProxy;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            TRCAgentProxy[] tRCAgentProxyArray = new TRCAgentProxy[this.agentList.length + 16];
            System.arraycopy(this.agentList, 0, tRCAgentProxyArray, 0, this.agentList.length);
            this.agentList = tRCAgentProxyArray;
            this.agentList[this.nextAgent] = tRCAgentProxy;
        }
        ++this.nextAgent;
    }

    protected void loadAllAgents(TRCMonitor tRCMonitor) {
        if (tRCMonitor != null) {
            Iterator iterator = tRCMonitor.getNodes().iterator();
            while (iterator.hasNext()) {
                TRCNode tRCNode = (TRCNode)iterator.next();
                if (tRCNode == null || tRCNode.eIsProxy()) continue;
                this.loadAllAgents(tRCNode);
            }
        }
    }

    protected void loadAllAgents(TRCNode tRCNode) {
        Iterator iterator = tRCNode.getProcessProxies().iterator();
        while (iterator.hasNext()) {
            TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)iterator.next();
            if (tRCProcessProxy == null || tRCProcessProxy.eIsProxy()) continue;
            this.loadAllAgents(tRCProcessProxy);
        }
    }

    protected void loadAllAgents(TRCProcessProxy tRCProcessProxy) {
        Iterator iterator = tRCProcessProxy.getAgentProxies().iterator();
        while (iterator.hasNext()) {
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator.next();
            if (tRCAgentProxy == null || tRCAgentProxy.eIsProxy()) continue;
            this.addAgent(tRCAgentProxy);
        }
    }

    protected Hashtable getAgentTable() {
        return this.agents;
    }

    protected void syncAgentTimes() {
        int n;
        if (this.nextAgent == 0) {
            return;
        }
        Hashtable hashtable = this.getAgentTable();
        TRCAgentProxy tRCAgentProxy = null;
        int n2 = n = 0;
        while (n2 < this.nextAgent) {
            if (this.agentList[n2].getStartTime() != 0.0) {
                n = n2;
                tRCAgentProxy = this.agentList[n2];
                n2 = this.nextAgent;
            }
            ++n2;
        }
        int n3 = n;
        while (n3 < this.nextAgent) {
            try {
                if (this.agentList[n3].getStartTime() + this.agentList[n3].getProcessProxy().getNode().getDeltaTime() < tRCAgentProxy.getStartTime() + tRCAgentProxy.getProcessProxy().getNode().getDeltaTime()) {
                    tRCAgentProxy = this.agentList[n3];
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            ++n3;
        }
        int n4 = n;
        while (n4 < this.nextAgent) {
            if (this.agentList[n4].getStartTime() + this.agentList[n4].getProcessProxy().getNode().getDeltaTime() != 0.0) {
                double d = this.agentList[n4].getStartTime() + this.agentList[n4].getProcessProxy().getNode().getDeltaTime() - tRCAgentProxy.getStartTime() - tRCAgentProxy.getProcessProxy().getNode().getDeltaTime();
                hashtable.put(this.agentList[n4], new Double(d));
            }
            ++n4;
        }
    }

    public void loadInvocationsIntoModel(TRCAgentProxy tRCAgentProxy, int n) {
        if (tRCAgentProxy == null) {
            return;
        }
        TRCProcess tRCProcess = (TRCProcess)tRCAgentProxy.getAgent().getProcess();
        if (tRCProcess != null) {
            Iterator iterator = tRCProcess.getThreads().iterator();
            while (iterator.hasNext()) {
                TRCThread tRCThread = (TRCThread)iterator.next();
                if (tRCThread == null) continue;
                Iterator iterator2 = tRCThread.getInitialInvocations().iterator();
                while (iterator2.hasNext()) {
                    TRCMethodInvocation tRCMethodInvocation = (TRCMethodInvocation)iterator2.next();
                    if (tRCMethodInvocation == null) continue;
                    NodeContainer nodeContainer = this.resolveContainer(tRCMethodInvocation, n);
                    this.resolveMethodNode(tRCMethodInvocation, nodeContainer);
                    this.call(tRCMethodInvocation.getInvokes(), n);
                }
            }
        }
        this.resolveConnections();
    }

    private void call(EList eList, int n) {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            TRCMethodInvocation tRCMethodInvocation = (TRCMethodInvocation)iterator.next();
            NodeContainer nodeContainer = this.resolveContainer(tRCMethodInvocation, n);
            this.resolveMethodNode(tRCMethodInvocation, nodeContainer);
            this.call(tRCMethodInvocation.getInvokes(), n);
        }
    }

    public void loadInvocationsIntoModel(TRCProcessProxy tRCProcessProxy, int n) {
        if (tRCProcessProxy == null) {
            return;
        }
        Iterator iterator = tRCProcessProxy.getAgentProxies().iterator();
        while (iterator.hasNext()) {
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator.next();
            if (tRCAgentProxy == null || tRCAgentProxy.eIsProxy()) continue;
            this.loadInvocationsIntoModel(tRCAgentProxy, n);
        }
    }

    public void loadInvocationsIntoModel(TRCNode tRCNode, int n) {
        if (tRCNode == null) {
            return;
        }
        Iterator iterator = tRCNode.getProcessProxies().iterator();
        while (iterator.hasNext()) {
            TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)iterator.next();
            if (tRCProcessProxy == null || tRCProcessProxy.eIsProxy()) continue;
            this.loadInvocationsIntoModel(tRCProcessProxy, n);
        }
    }

    public void loadInvocationsIntoModel(TRCMonitor tRCMonitor, int n) {
        if (tRCMonitor == null) {
            return;
        }
        Iterator iterator = tRCMonitor.getNodes().iterator();
        while (iterator.hasNext()) {
            TRCNode tRCNode = (TRCNode)iterator.next();
            if (tRCNode == null || tRCNode.eIsProxy()) continue;
            this.loadInvocationsIntoModel(tRCNode, n);
        }
    }

    private TRCClass getClass(TRCMethodInvocation tRCMethodInvocation) {
        TRCTraceObject tRCTraceObject = tRCMethodInvocation.getOwningObject();
        if (tRCTraceObject.getIsA() != tRCMethodInvocation.getProcess().getClassClass()) {
            return tRCTraceObject.getIsA();
        }
        return tRCMethodInvocation.getMethod().getDefiningClass();
    }
}

