/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.report;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.classloader.PathEntriesClassLoader;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.hyades.ui.report.IReportGenerator;

public class ReportDescription
implements IReportDescription {
    private String name = null;
    private String className = null;
    private String classPath = null;
    private IReportGenerator reportGenerator = null;
    private IConfigurationElement configurationElement;
    private ClassLoader parentClassLoader;

    public ReportDescription(ClassLoader classLoader, String string, String string2, String string3) {
        this.name = string;
        this.className = string2;
        this.classPath = string3;
        this.parentClassLoader = classLoader;
    }

    public ReportDescription(String string, String string2, String string3, IConfigurationElement iConfigurationElement) {
        this.name = string;
        this.className = string2;
        this.classPath = string3;
        this.configurationElement = iConfigurationElement;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public IReportGenerator getReportGenerator() throws Exception {
        if (this.reportGenerator == null) {
            if (this.configurationElement == null) {
                String string = this.getClassName();
                String string2 = this.getClassPath();
                PathEntriesClassLoader pathEntriesClassLoader = new PathEntriesClassLoader(this.parentClassLoader, string2);
                if (pathEntriesClassLoader != null) {
                    try {
                        this.reportGenerator = (IReportGenerator)pathEntriesClassLoader.loadClass(string).newInstance();
                    }
                    catch (Throwable throwable) {
                        HyadesUIPlugin.logError(throwable);
                        return null;
                    }
                    this.reportGenerator.setUsedClasspath(string2);
                }
            } else {
                try {
                    this.reportGenerator = (IReportGenerator)this.configurationElement.createExecutableExtension("class");
                }
                catch (Throwable throwable) {
                    HyadesUIPlugin.logError(throwable);
                    return null;
                }
            }
        }
        return this.reportGenerator;
    }

    public boolean isDefinedByPlugin() {
        return this.configurationElement != null;
    }

    public void setClassName(String string) {
        this.className = string;
        this.reportGenerator = null;
    }

    public void setClassPath(String string) {
        this.classPath = string;
        this.reportGenerator = null;
    }

    public void setName(String string) {
        this.name = string;
    }
}

