/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.preference;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.security.KeystoreHelper;
import org.eclipse.hyades.security.SecurityImages;
import org.eclipse.hyades.security.SecurityPlugin;
import org.eclipse.hyades.security.preference.TableViewerSorter;
import org.eclipse.hyades.security.util.CertificateProperties;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.security.util.SecurityUI;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AgentControllerPage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private static final String[] COLUMNS = new String[]{"STRING", "STRING"};
    private TableViewer tableViewer;
    private ArrayList tableElements = new ArrayList();
    private Button btnAdd;
    private Button btnRemove;
    private Button btnRename;
    private Button btnProperties;
    private KeyStore ks;

    public AgentControllerPage() {
        this.setPreferenceStore(SecurityPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)GridUtil.createFill());
        composite2.setLayout((Layout)new GridLayout());
        TabFolder tabFolder = new TabFolder(composite2, 0);
        tabFolder.setLayout((Layout)new GridLayout());
        tabFolder.setLayoutData((Object)GridUtil.createFill());
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SecurityPlugin.getResourceString("STR_PREF_PD_AC_SECURITY"));
        tabItem.setImage(SecurityImages.getImage("certif_file.gif"));
        tabItem.setControl(this.createSecurityTab((Composite)tabFolder));
        return composite2;
    }

    private Control createSecurityTab(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.verticalSpacing = 10;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createFill());
        Label label = new Label(composite2, 0);
        label.setText(SecurityPlugin.getResourceString("STR_PREF_SEC_DESCRIPTION"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.createTableViewer(composite2);
        Composite composite3 = new Composite(composite2, 0);
        gridData = new GridData(1040);
        composite3.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        this.createButtons(composite3);
        this.initializeValues();
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnRename.addSelectionListener((SelectionListener)this);
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnProperties.addSelectionListener((SelectionListener)this);
        return composite2;
    }

    private void createTableViewer(Composite composite) {
        this.tableViewer = new TableViewer(composite, 67588);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = GridUtil.createFill();
        gridData.heightHint = 50;
        gridData.widthHint = 100;
        table.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        CellEditor[] cellEditorArray = new CellEditor[COLUMNS.length];
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(SecurityPlugin.getResourceString("STR_PREF_ALIAS_NAME"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        cellEditorArray[0] = new TextCellEditor((Composite)table);
        TableColumn tableColumn2 = new TableColumn(table, 16384);
        tableColumn2.setText(SecurityPlugin.getResourceString("STR_PREF_CERTIFICATES"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(120));
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setColumnProperties(COLUMNS);
        this.tableViewer.setContentProvider((IContentProvider)new PreferenceContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PreferenceLabelProvider());
        this.tableViewer.getTable().addSelectionListener((SelectionListener)this);
        TableViewerSorter.setTableSorter(this.tableViewer, 0, true);
    }

    private void createButtons(Composite composite) {
        this.btnAdd = new Button(composite, 8);
        this.btnAdd.setText(SecurityPlugin.getResourceString("STR_ADD_LBL"));
        GridData gridData = GridUtil.createHorizontalFill();
        this.btnAdd.setLayoutData((Object)gridData);
        this.btnRemove = new Button(composite, 8);
        this.btnRemove.setText(SecurityPlugin.getResourceString("STR_REMOVE_LBL"));
        gridData = GridUtil.createHorizontalFill();
        this.btnRemove.setLayoutData((Object)gridData);
        this.btnRemove.setEnabled(false);
        Composite composite2 = new Composite(composite, 0);
        gridData = GridUtil.createHorizontalFill();
        gridData.verticalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        this.btnRename = new Button(composite, 8);
        this.btnRename.setText(SecurityPlugin.getResourceString("STR_RENAME_LBL"));
        gridData = GridUtil.createHorizontalFill();
        this.btnRename.setLayoutData((Object)gridData);
        this.btnRename.setEnabled(false);
        this.btnProperties = new Button(composite, 8);
        this.btnProperties.setText(SecurityPlugin.getResourceString("STR_PROPERTIES_LBL"));
        gridData = GridUtil.createHorizontalFill();
        this.btnProperties.setLayoutData((Object)gridData);
        this.btnProperties.setEnabled(false);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        boolean bl;
        AddDialog addDialog;
        if (selectionEvent.widget == this.btnAdd) {
            addDialog = new AddDialog(this.getShell());
            addDialog.open();
            if (addDialog.getReturnCode() == 0) {
                this.tableViewer.refresh();
            }
        } else if (selectionEvent.widget == this.btnRemove) {
            addDialog = (IStructuredSelection)this.tableViewer.getSelection();
            if (addDialog.size() > 0) {
                Iterator iterator = addDialog.iterator();
                while (iterator.hasNext()) {
                    try {
                        MyTableElement myTableElement = (MyTableElement)iterator.next();
                        this.ks.deleteEntry(myTableElement.getAlias());
                        ((AbstractCollection)this.tableElements).remove(myTableElement);
                    }
                    catch (KeyStoreException keyStoreException) {
                        // empty catch block
                    }
                }
                this.tableViewer.refresh();
            }
        } else if (selectionEvent.widget == this.btnRename) {
            addDialog = (IStructuredSelection)this.tableViewer.getSelection();
            if (addDialog.size() == 1) {
                MyTableElement myTableElement = (MyTableElement)addDialog.getFirstElement();
                RenameDialog renameDialog = new RenameDialog(this.getShell(), myTableElement.getAlias());
                renameDialog.open();
                if (renameDialog.getReturnCode() == 0) {
                    try {
                        KeystoreHelper.addCertificateToKeyStore((KeyStore)this.ks, (Certificate)((Certificate)myTableElement.getValue()), (String)renameDialog.getNewAlias());
                        this.ks.deleteEntry(myTableElement.getAlias());
                        myTableElement.setAlias(renameDialog.getNewAlias());
                        this.tableViewer.refresh();
                    }
                    catch (KeyStoreException keyStoreException) {}
                }
            }
        } else if (selectionEvent.widget == this.btnProperties && (addDialog = (IStructuredSelection)this.tableViewer.getSelection()).size() == 1) {
            MyTableElement myTableElement = (MyTableElement)addDialog.getFirstElement();
            CertificateProperties certificateProperties = new CertificateProperties(this.getShell());
            certificateProperties.init(myTableElement.getAlias(), myTableElement.getValue());
            certificateProperties.open();
        }
        this.btnRename.setEnabled(!(bl = this.tableViewer.getSelection().isEmpty()));
        this.btnRemove.setEnabled(!bl);
        this.btnProperties.setEnabled(!bl);
    }

    public Point computeSize() {
        Point point = super.computeSize();
        return point;
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        String string = SecurityPlugin.getKeyStoreLocation();
        String string2 = SecurityPlugin.getWorkspaceName();
        try {
            KeystoreHelper.persistKeyStore((KeyStore)this.ks, (String)string, (String)string2);
        }
        catch (IOException iOException) {
            String string3 = SecurityPlugin.getResourceString("STR_IO_SAVE_ERROR_");
            string3 = TString.change(string3, "%1", string);
            string3 = TString.change(string3, "%1", string);
            String string4 = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string3, (Throwable)iOException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string4, (IStatus)status);
            return false;
        }
        catch (CertificateException certificateException) {
            String string5 = SecurityPlugin.getResourceString("STR_CERTIFICATE_STORE_ERROR_");
            string5 = TString.change(string5, "%1", string);
            String string6 = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string5, (Throwable)certificateException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string6, (IStatus)status);
            return false;
        }
        catch (KeyStoreException keyStoreException) {
            String string7 = SecurityPlugin.getResourceString("STR_UNINIT_KEYSTORE_ERROR_");
            string7 = TString.change(string7, "%1", SecurityPlugin.getKeyStoreLocation());
            String string8 = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string7, (Throwable)keyStoreException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string8, (IStatus)status);
            return false;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string9 = SecurityPlugin.getResourceString("STR_ALGORITHM_ERROR_");
            string9 = TString.change(string9, "%1", SecurityPlugin.getKeyStoreLocation());
            String string10 = SecurityPlugin.getResourceString("STR_KEYSTORE_SAVE_ERROR_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string9, (Throwable)noSuchAlgorithmException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string10, (IStatus)status);
            return false;
        }
        return true;
    }

    private void initializeValues() {
        String string = SecurityPlugin.getKeyStoreLocation();
        String string2 = SecurityPlugin.getWorkspaceName();
        try {
            this.ks = KeystoreHelper.createKeyStore((String)string, (String)string2);
            Enumeration<String> enumeration = this.ks.aliases();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string3 = enumeration.nextElement();
                Certificate certificate = this.ks.getCertificate(string3);
                if (certificate != null) {
                    object = new MyTableElement(string3, SecurityPlugin.getResourceString("STR_TRUSTED_CERTIFICATE"));
                    ((MyTableElement)object).setValue(certificate);
                    this.tableElements.add(object);
                    continue;
                }
                try {
                    object = this.ks.getKey(string3, string2.toCharArray());
                    MyTableElement myTableElement = new MyTableElement(string3, SecurityPlugin.getResourceString("STR_KEY_ENTRY"));
                    myTableElement.setValue(object);
                    this.tableElements.add(myTableElement);
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            String string4 = SecurityPlugin.getResourceString("STR_LOAD_IO_EXC_");
            string4 = TString.change(string4, "%1", string);
            String string5 = SecurityPlugin.getResourceString("STR_LOAD_KEYSTORE_ERROR_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string4, (Throwable)iOException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string5, (IStatus)status);
        }
        catch (CertificateException certificateException) {
            String string6 = SecurityPlugin.getResourceString("STR_KEY_LOAD_ERROR_");
            string6 = TString.change(string6, "%1", string);
            String string7 = SecurityPlugin.getResourceString("STR_LOAD_KEYSTORE_ERROR_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string6, (Throwable)certificateException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string7, (IStatus)status);
        }
        catch (KeyStoreException keyStoreException) {
            String string8 = SecurityPlugin.getResourceString("STR_INITIALIZE_ERROR_");
            string8 = TString.change(string8, "%1", SecurityPlugin.getKeyStoreLocation());
            String string9 = SecurityPlugin.getResourceString("STR_LOAD_KEYSTORE_ERROR_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string8, (Throwable)keyStoreException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string9, (IStatus)status);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            String string10 = SecurityPlugin.getResourceString("STR_SECURITY_PROVIDER_ERROR_");
            String string11 = SecurityPlugin.getResourceString("STR_INITIALIZE_ERROR_");
            string11 = TString.change(string11, "%1", SecurityPlugin.getKeyStoreLocation());
            Status status = new Status(4, "org.eclipse.core.resources", 4, string10, (Throwable)noSuchProviderException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string11, (IStatus)status);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string12 = SecurityPlugin.getResourceString("STR_ALGORITHM_ERROR_");
            string12 = TString.change(string12, "%1", SecurityPlugin.getKeyStoreLocation());
            String string13 = SecurityPlugin.getResourceString("STR_LOAD_KEYSTORE_ERROR_");
            Status status = new Status(4, "org.eclipse.core.resources", 4, string12, (Throwable)noSuchAlgorithmException);
            ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string13, (IStatus)status);
        }
        this.tableViewer.setInput((Object)this.tableElements);
    }

    public class RenameDialog
    extends Dialog
    implements Listener {
        private Text txtName;
        private String newAlias;
        private String oldAlias;

        public RenameDialog(Shell shell, String string) {
            super(shell);
            this.oldAlias = string;
        }

        protected Control createDialogArea(Composite composite) {
            this.getShell().setText(SecurityPlugin.getResourceString("STR_RENAME_CERT_DLG_TITLE"));
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            GridData gridData = GridUtil.createFill();
            gridData.widthHint = 350;
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            composite2.setLayoutData((Object)gridData);
            Label label = new Label(composite2, 0);
            label.setText(SecurityPlugin.getResourceString("STR_CERTIFICATE_ALIAS"));
            this.txtName = new Text(composite2, 2048);
            this.txtName.setText(this.oldAlias);
            this.txtName.selectAll();
            this.txtName.addListener(24, (Listener)this);
            gridData = GridUtil.createHorizontalFill();
            gridData.widthHint = 200;
            this.txtName.setLayoutData((Object)gridData);
            return composite2;
        }

        private void validateDialog() {
            if (this.txtName.getText().trim().length() == 0) {
                this.getButton(0).setEnabled(false);
            } else {
                this.getButton(0).setEnabled(true);
            }
        }

        public void handleEvent(Event event) {
            if (event.widget.equals(this.txtName)) {
                this.validateDialog();
            }
        }

        protected Control createButtonBar(Composite composite) {
            Control control = super.createButtonBar(composite);
            this.validateDialog();
            return control;
        }

        public String getNewAlias() {
            return this.newAlias;
        }

        protected void okPressed() {
            this.newAlias = this.txtName.getText();
            super.okPressed();
        }
    }

    public class AddDialog
    extends Dialog
    implements Listener {
        private SecurityUI _securityUI;
        private Certificate fCertificate;
        private Shell shell;

        public AddDialog(Shell shell) {
            super(shell);
            this.shell = shell;
        }

        protected Control createDialogArea(Composite composite) {
            this.getShell().setText(SecurityPlugin.getResourceString("STR_ADD_CERT_DLG_TITLE"));
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            GridData gridData = GridUtil.createFill();
            gridLayout.numColumns = 1;
            composite2.setLayout((Layout)gridLayout);
            composite2.setLayoutData((Object)gridData);
            this._securityUI = new SecurityUI(this.shell);
            this._securityUI.createContents(composite2);
            this._securityUI.registerListener(this);
            return composite2;
        }

        protected Control createButtonBar(Composite composite) {
            Control control = super.createButtonBar(composite);
            this.getButton(0).setEnabled(false);
            return control;
        }

        protected void okPressed() {
            try {
                this.fCertificate = this._securityUI.loadCertificate(AgentControllerPage.this.ks);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = SecurityPlugin.getResourceString("STR_KEY_IO_ERROR_");
                string = TString.change(string, "%1", this._securityUI.getPath());
                String string2 = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
                Status status = new Status(4, "org.eclipse.core.resources", 4, string, (Throwable)fileNotFoundException);
                ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string2, (IStatus)status);
                return;
            }
            catch (IOException iOException) {
                String string = SecurityPlugin.getResourceString("STR_LOAD_IO_EXC_");
                string = TString.change(string, "%1", this._securityUI.getPath());
                string = TString.change(string, "%1", SecurityPlugin.getKeyStoreLocation());
                String string3 = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
                Status status = new Status(4, "org.eclipse.core.resources", 4, string, (Throwable)iOException);
                ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string3, (IStatus)status);
                return;
            }
            catch (CertificateException certificateException) {
                String string = SecurityPlugin.getResourceString("STR_CERTIFICATE_EXC_");
                string = TString.change(string, "%1", this._securityUI.getPath());
                String string4 = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
                Status status = new Status(4, "org.eclipse.core.resources", 4, string, (Throwable)certificateException);
                ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string4, (IStatus)status);
                return;
            }
            catch (KeyStoreException keyStoreException) {
                String string = SecurityPlugin.getResourceString("STR_KEY_STORE_ERROR_");
                string = TString.change(string, "%1", SecurityPlugin.getKeyStoreLocation());
                String string5 = SecurityPlugin.getResourceString("STR_CERTIFICATE_LOAD_EXC_");
                Status status = new Status(4, "org.eclipse.core.resources", 4, string, (Throwable)keyStoreException);
                ErrorDialog.openError((Shell)SecurityPlugin.getActiveWorkbenchShell(), (String)SecurityPlugin.getResourceString("SEC_MSG"), (String)string5, (IStatus)status);
                return;
            }
            MyTableElement myTableElement = new MyTableElement(this._securityUI.getAliasName(), SecurityPlugin.getResourceString("STR_TRUSTED_CERTIFICATE"));
            myTableElement.setValue(this.fCertificate);
            AgentControllerPage.this.tableElements.add(myTableElement);
            super.okPressed();
        }

        public void handleEvent(Event event) {
            this.getButton(0).setEnabled(this._securityUI.validateDialog());
        }

        public Certificate getCertificate() {
            return this.fCertificate;
        }
    }

    private class PreferenceCellModifier
    implements ICellModifier {
        private Viewer viewer;

        public PreferenceCellModifier(Viewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object object, String string) {
            if (object instanceof MyTableElement) {
                MyTableElement myTableElement = (MyTableElement)object;
                if (string.equals(COLUMNS[0])) {
                    return true;
                }
                if (string.equals(COLUMNS[1])) {
                    return false;
                }
            }
            return false;
        }

        public Object getValue(Object object, String string) {
            if (object instanceof MyTableElement) {
                MyTableElement myTableElement = (MyTableElement)object;
                if (string.equals(COLUMNS[0])) {
                    return myTableElement.getAlias();
                }
                if (string.equals(COLUMNS[1])) {
                    return this.getValueIndex(myTableElement.getType());
                }
            }
            return null;
        }

        public void modify(Object object, String string, Object object2) {
            Object object3;
            if (object instanceof TableItem && (object3 = ((TableItem)object).getData()) instanceof MyTableElement) {
                MyTableElement myTableElement = (MyTableElement)object3;
                if (string.equals(COLUMNS[0])) {
                    myTableElement.setAlias((String)object2);
                }
                this.viewer.refresh();
            }
        }

        private Integer getValueIndex(String string) {
            return new Integer(0);
        }

        private String getValue(Integer n) {
            return null;
        }
    }

    private class PreferenceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PreferenceLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof MyTableElement) {
                MyTableElement myTableElement = (MyTableElement)object;
                if (n == 0) {
                    return myTableElement.getAlias();
                }
                if (n == 1) {
                    return myTableElement.getType();
                }
            }
            return "";
        }
    }

    private class PreferenceContentProvider
    implements IStructuredContentProvider {
        private PreferenceContentProvider() {
        }

        public Object[] getElements(Object object) {
            if (object instanceof ArrayList) {
                return ((ArrayList)object).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class MyTableElement {
        private String alias;
        private Object value;

        public MyTableElement(String string, String string2) {
            this.alias = string;
            this.value = string2;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String string) {
            this.alias = string;
        }

        public Object getValue() {
            return this.value;
        }

        public String getType() {
            if (this.value instanceof Certificate) {
                return SecurityPlugin.getResourceString("STR_TRUSTED_CERTIFICATE");
            }
            if (this.value instanceof Key) {
                return SecurityPlugin.getResourceString("STR_KEY_ENTRY");
            }
            return SecurityPlugin.getResourceString("STR_UNKNOWN_ENTRY");
        }

        public void setValue(Object object) {
            this.value = object;
        }
    }
}

