/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.util;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import org.eclipse.hyades.execution.security.KeystoreHelper;
import org.eclipse.hyades.security.SecurityPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SecurityUI
implements Listener {
    private Shell fShell;
    private Text txtPath;
    private Text txtName;
    private String fAlias;
    private String fType;
    private String fPath;
    private ArrayList listenerList;
    private Button btnBrowse;

    public SecurityUI(Shell shell) {
        this.fShell = shell;
        this.listenerList = new ArrayList();
    }

    public void createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 400;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(SecurityPlugin.getResourceString("STR_CERTIFICATE_FILE"));
        this.txtPath = new Text(composite2, 2048);
        this.txtPath.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.txtPath.setText("");
        this.btnBrowse = new Button(composite2, 8);
        this.btnBrowse.setText(SecurityPlugin.getResourceString("STR_BROWSE"));
        this.btnBrowse.addListener(13, (Listener)this);
        Label label2 = new Label(composite2, 0);
        label2.setText(SecurityPlugin.getResourceString("STR_CERTIFICATE_ALIAS"));
        this.txtName = new Text(composite2, 2048);
        this.txtName.setText("");
        this.txtName.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.txtName.addListener(24, (Listener)this);
        this.txtPath.addListener(24, (Listener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.btnBrowse) {
            this.showFileDialog();
            this.NotifyListeners(event);
        }
        if (event.widget == this.txtName || event.widget == this.txtPath) {
            this.fPath = this.txtPath.getText();
            this.fAlias = this.txtName.getText();
            this.NotifyListeners(event);
        }
    }

    public void NotifyListeners(Event event) {
        int n = 0;
        while (n < this.listenerList.size()) {
            ((Listener)this.listenerList.get(n)).handleEvent(event);
            ++n;
        }
    }

    public boolean validateDialog() {
        return this.txtName.getText().trim().length() > 0 && this.txtPath.getText().trim().length() > 0;
    }

    private void setButtonState() {
        this.fShell.getDefaultButton().setEnabled(this.validateDialog());
    }

    private void showFileDialog() {
        String string = this.txtPath.getText();
        FileDialog fileDialog = new FileDialog(this.fShell, 4096);
        fileDialog.setFileName(string);
        fileDialog.setFilterExtensions(new String[]{"*.cer", "*.*"});
        String string2 = fileDialog.open();
        if (string2 != null) {
            this.txtPath.setText(string2);
        }
    }

    public Certificate loadCertificate(KeyStore keyStore) throws IOException, CertificateException, KeyStoreException {
        Certificate certificate = KeystoreHelper.loadCertificate((String)this.getPath());
        KeystoreHelper.addCertificateToKeyStore((KeyStore)keyStore, (Certificate)certificate, (String)this.getAliasName());
        return certificate;
    }

    public void registerListener(Listener listener) {
        this.listenerList.add(listener);
    }

    public String getAliasName() {
        return this.fAlias;
    }

    public String getPath() {
        return this.fPath;
    }
}

