/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.Iterator;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractProfileActionDelegate
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate,
ISelectionListener {
    private IAction fAction;
    private IViewPart fViewPart;
    private IStructuredSelection fSelection;
    private boolean fInitialized = false;

    public void dispose() {
        UIPlugin.getActiveWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer", (ISelectionListener)this);
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        iWorkbenchWindow.getSelectionService().addSelectionListener("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer", (ISelectionListener)this);
    }

    public void run(IAction iAction) {
        IStructuredSelection iStructuredSelection = this.getSelection();
        final Iterator iterator = iStructuredSelection.iterator();
        String string = UIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    try {
                        AbstractProfileActionDelegate.this.doAction(e);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        boolean bl = this.initialize(iAction, iSelection);
        if (!bl && this.getView() != null) {
            this.update(iAction, iSelection);
        }
    }

    protected void update(IAction iAction, ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            iAction.setEnabled(this.getEnableStateForSelection(iStructuredSelection));
            this.setSelection(iStructuredSelection);
        } else {
            iAction.setEnabled(false);
            this.setSelection((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    protected boolean getEnableStateForSelection(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() == 0) {
            return false;
        }
        Iterator iterator = iStructuredSelection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (++n > 1 && !this.enableForMultiSelection()) {
                return false;
            }
            Object e = iterator.next();
            if (this.isEnabledFor(e)) continue;
            return false;
        }
        return true;
    }

    protected boolean enableForMultiSelection() {
        return true;
    }

    protected abstract void doAction(Object var1) throws Exception;

    protected abstract boolean isEnabledFor(Object var1);

    public void init(IViewPart iViewPart) {
        this.fViewPart = iViewPart;
    }

    protected IViewPart getView() {
        return this.fViewPart;
    }

    protected boolean initialize(IAction iAction, ISelection iSelection) {
        if (!this.isInitialized()) {
            this.setAction(iAction);
            this.update(iAction, iSelection);
            this.setInitialized(true);
            return true;
        }
        return false;
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }

    private void setSelection(IStructuredSelection iStructuredSelection) {
        this.fSelection = iStructuredSelection;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        this.update(this.getAction(), iSelection);
    }

    protected void setView(IViewPart iViewPart) {
        this.fViewPart = iViewPart;
    }

    protected boolean isInitialized() {
        return this.fInitialized;
    }

    protected void setInitialized(boolean bl) {
        this.fInitialized = bl;
    }

    protected void setAction(IAction iAction) {
        this.fAction = iAction;
    }

    protected IAction getAction() {
        return this.fAction;
    }
}

