/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.console;

import java.net.InetAddress;
import org.eclipse.hyades.internal.execution.local.common.Console;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.console.TraceConsoleDocument;

public class ConsoleDataProcessor
implements DataProcessor {
    private TRCProcessProxy fProcess;
    private Console fConsole;

    public ConsoleDataProcessor(TRCProcessProxy tRCProcessProxy) {
        this.fProcess = tRCProcessProxy;
    }

    public TRCProcessProxy getProcess() {
        return this.fProcess;
    }

    public void incommingData(byte[] byArray, int n, InetAddress inetAddress) {
        TraceConsoleDocument traceConsoleDocument = (TraceConsoleDocument)UIPlugin.getDefault().getConsoleManager().getConsoleDocument(this.fProcess);
        if (traceConsoleDocument != null) {
            traceConsoleDocument.streamAppended(this.makeString(byArray, 0, n), 0);
        }
    }

    public void incommingData(char[] cArray, int n, InetAddress inetAddress) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)cArray[n2];
            ++n2;
        }
        TraceConsoleDocument traceConsoleDocument = (TraceConsoleDocument)UIPlugin.getDefault().getConsoleManager().getConsoleDocument(this.fProcess);
        if (traceConsoleDocument != null) {
            traceConsoleDocument.streamAppended(new String(cArray, 0, n), 0);
        }
    }

    public void invalidDataType(byte[] byArray, int n, InetAddress inetAddress) {
    }

    private String makeString(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, n, n2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setConsole(Console console) {
        this.fConsole = console;
    }

    public void setProcess(TRCProcessProxy tRCProcessProxy) {
        this.fProcess = tRCProcessProxy;
    }

    public void waitingForData() {
    }

    public void write(String string) {
        if (this.fConsole != null && string != null) {
            this.fConsole.write(string);
        }
    }

    public void dispose() {
        this.fProcess = null;
        this.fConsole.close();
        this.fConsole = null;
    }
}

