/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TraceOptionsUI
implements SelectionListener,
ModifyListener {
    private Button _enableProf;
    private Button _enableLog;
    private Button _enableInfoMsg;
    private Text _projectName;
    private Text _localPort;
    private PreferencePage _preferencePage;

    public TraceOptionsUI(PreferencePage preferencePage) {
        this._preferencePage = preferencePage;
    }

    public TraceOptionsUI() {
    }

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._enableProf = new Button(composite2, 32);
        this._enableProf.setText(UIPlugin.getResourceString("ENABLE_PROFILE_TEXT"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this._enableProf.setLayoutData((Object)gridData);
        this._enableLog = new Button(composite2, 32);
        this._enableLog.setText(UIPlugin.getResourceString("ENABLE_LOGGING"));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this._enableLog.setLayoutData((Object)gridData);
        this._enableInfoMsg = new Button(composite2, 32);
        this._enableInfoMsg.setText(UIPlugin.getResourceString("SHOW_PROFILE_TIPS"));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this._enableInfoMsg.setLayoutData((Object)gridData);
        this._enableProf.addSelectionListener((SelectionListener)this);
        Label label = new Label(composite2, 0);
        label.setText(UIPlugin.getResourceString("TRACEOPTIONSUI_TEXT"));
        this._projectName = new Text(composite2, 2048);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this._projectName.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 0);
        label2.setText(UIPlugin.getResourceString("RAC_LOCALHOST_PORT_TEXT"));
        this._localPort = new Text(composite2, 2048);
        gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this._localPort.setLayoutData((Object)gridData);
        this._localPort.addModifyListener((ModifyListener)this);
        this.initializeValues();
        return composite2;
    }

    public boolean getLogOption() {
        return this._enableLog.getSelection();
    }

    public boolean getProfOption() {
        return this._enableProf.getSelection();
    }

    public boolean getInfoMsgOption() {
        return this._enableInfoMsg.getSelection();
    }

    public String getProjectName() {
        return this._projectName.getText().trim();
    }

    public String getLocalPortNumber() {
        return this._localPort.getText().trim();
    }

    private void initializeValues() {
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        this.setProfOption(iPreferenceStore.getBoolean("prof_option"));
        this.setInfoMsgOption(iPreferenceStore.getBoolean("profile_tips"));
        this._enableLog.setSelection(false);
        this._enableLog.setVisible(false);
        this.setLogOption(iPreferenceStore.getBoolean("log_option"));
        this._enableLog.setVisible(true);
        this.setProjectName(iPreferenceStore.getString("prj_name"));
        iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        this.setLocalHostPort(iPreferenceStore.getString("localhost_port"));
    }

    public void setLogOption(boolean bl) {
        this._enableLog.setSelection(bl);
    }

    public void setInfoMsgOption(boolean bl) {
        this._enableInfoMsg.setSelection(bl);
    }

    public void setProfOption(boolean bl) {
        this._enableProf.setSelection(bl);
    }

    public void setProjectName(String string) {
        this._projectName.setText(string);
    }

    public void setLocalHostPort(String string) {
        this._localPort.setText(string);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.widget == this._localPort) {
            try {
                if (this._localPort.getText().trim() == "") {
                    this._preferencePage.setErrorMessage(UIPlugin.getResourceString("RAC_EMPTY_PORT"));
                    return;
                }
                int n = Integer.parseInt(this._localPort.getText().trim());
                if (n < 0) {
                    this._preferencePage.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                    this._localPort.setFocus();
                    return;
                }
                this._preferencePage.setErrorMessage(null);
            }
            catch (NumberFormatException numberFormatException) {
                if (this._preferencePage != null) {
                    this._preferencePage.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
                }
                this._localPort.setFocus();
            }
        }
    }
}

