/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOptionsUI;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentWizard;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenProfOptionsPage
extends WizardPage {
    protected PDProjectExplorer fViewer;
    protected TraceProfileOptionsUI _optionsUI;

    public OpenProfOptionsPage(String string, PDProjectExplorer pDProjectExplorer) {
        super(string);
        this.setTitle(UIPlugin.getResourceString("PROF_FILTER_TITLE"));
        this.setDescription(UIPlugin.getResourceString("PROF_FILTER_DESC"));
        this.fViewer = pDProjectExplorer;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 5;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        composite2.setLayoutData((Object)gridData);
        this._optionsUI = new TraceProfileOptionsUI();
        this._optionsUI.createControl(composite2);
        this._optionsUI.setWizardPage(this);
        TRCAgentProxy tRCAgentProxy = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        this._optionsUI.enableHeapInfo(false);
        this.setControl((Control)composite2);
        this.populateData();
        if (tRCAgentProxy == null || !tRCAgentProxy.isActive()) {
            this.setPageComplete(false);
            this._optionsUI.enable(false);
        }
        WorkbenchHelp.setHelp((Control)composite, (String)(UIPlugin.getPluginId() + ".opop0000"));
    }

    public boolean finish(boolean bl) {
        TRCAgentProxy tRCAgentProxy = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (tRCAgentProxy == null || !tRCAgentProxy.isActive()) {
            return true;
        }
        try {
            TRCConfiguration tRCConfiguration;
            HierarchyFactory hierarchyFactory;
            Object[] objectArray = tRCAgentProxy.getConfigurations().toArray();
            if (objectArray.length > 0) {
                this.setConfiguration((TRCConfiguration)objectArray[0]);
            } else {
                hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
                tRCConfiguration = hierarchyFactory.createTRCConfiguration();
                tRCConfiguration.setAgentProxy(tRCAgentProxy);
                tRCAgentProxy.getConfigurations().add(tRCConfiguration);
                this.setConfiguration(tRCConfiguration);
            }
            if (bl && tRCAgentProxy.isActive() && tRCAgentProxy.isMonitored()) {
                hierarchyFactory = tRCAgentProxy.getProcessProxy();
                tRCConfiguration = hierarchyFactory.getNode();
                this.sendConfigurationToAgent(tRCAgentProxy, tRCConfiguration.getName(), hierarchyFactory.getPid());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            concurrentModificationException.printStackTrace();
        }
        return true;
    }

    public boolean finish() {
        return this.finish(true);
    }

    private void sendConfigurationToAgent(TRCAgentProxy tRCAgentProxy, String string, int n) {
        Node node = PDCoreUtil.profileConnect(string, String.valueOf(tRCAgentProxy.getProcessProxy().getNode().getPort()));
        if (node == null) {
            return;
        }
        Process process = node.getProcess(String.valueOf(n));
        if (process != null) {
            try {
                Agent agent = process.getAgent(tRCAgentProxy.getName());
                PDCoreUtil.setAgentConfiguration(tRCAgentProxy, agent);
                if (agent != null && agent.isActive()) {
                    agent.publishConfiguration();
                    CustomCommand customCommand = new CustomCommand();
                    customCommand.setData("APPLYFILTERS");
                    agent.invokeCustomCommand(customCommand);
                }
            }
            catch (InactiveAgentException inactiveAgentException) {
                // empty catch block
            }
        }
    }

    protected void populateData() {
        TRCAgentProxy tRCAgentProxy = ((OpenProfAgentWizard)this.getWizard()).getAgent();
        if (tRCAgentProxy == null) {
            return;
        }
        int n = tRCAgentProxy.getCollectionMode().getValue();
        this._optionsUI.setHeapDetails(n == 1 || n == 7 || n == 2);
        this._optionsUI.setExecutionStatistic(n == 3 || n == 7 || n == 0);
        this._optionsUI.setExecutionFlow(!this._optionsUI.getExecutionStatistic());
        EList eList = null;
        EList eList2 = tRCAgentProxy.getConfigurations();
        Iterator iterator = eList2.iterator();
        if (iterator.hasNext()) {
            TRCConfiguration tRCConfiguration = (TRCConfiguration)iterator.next();
            eList = tRCConfiguration.getOptions();
            this.updateConfigData(eList);
            return;
        }
        this.updateConfigData(eList);
    }

    protected void setConfiguration(TRCConfiguration tRCConfiguration) {
        block19: {
            boolean bl = false;
            try {
                TRCOption tRCOption;
                int n;
                String[][] stringArray;
                Object[] objectArray = tRCConfiguration.getOptions().toArray();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    ((TRCOption)objectArray[n2]).setConfiguration(null);
                    ++n2;
                }
                HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
                if (!this._optionsUI.getExecution()) {
                    bl = true;
                }
                if (!this._optionsUI.getHeap()) {
                    stringArray = Options.OPTIONS_ANALYZE_HEAP_NONE;
                    n = 0;
                    while (n < stringArray.length) {
                        tRCOption = hierarchyFactory.createTRCOption();
                        tRCOption.setKey(stringArray[n][0]);
                        tRCOption.setValue(stringArray[n][1]);
                        tRCOption.setConfiguration(tRCConfiguration);
                        ++n;
                    }
                } else {
                    stringArray = Options.OPTIONS_ANALYZE_HEAP;
                    n = 0;
                    while (n < stringArray.length) {
                        tRCOption = hierarchyFactory.createTRCOption();
                        tRCOption.setKey(stringArray[n][0]);
                        tRCOption.setValue(stringArray[n][1]);
                        tRCOption.setConfiguration(tRCConfiguration);
                        ++n;
                    }
                }
                if (this._optionsUI.getHeap() && !this._optionsUI.getExecution()) {
                    stringArray = Options.OPTIONS_EXECUTION_FLOW_NONE;
                    n = 0;
                    while (n < stringArray.length) {
                        tRCOption = hierarchyFactory.createTRCOption();
                        tRCOption.setKey(stringArray[n][0]);
                        tRCOption.setValue(stringArray[n][1]);
                        tRCOption.setConfiguration(tRCConfiguration);
                        ++n;
                    }
                    break block19;
                }
                if (this._optionsUI.getExecutionBoundary()) {
                    stringArray = Options.OPTIONS_EXECUTION_FLOW_BOUNDARY;
                    n = 0;
                    while (n < stringArray.length) {
                        tRCOption = hierarchyFactory.createTRCOption();
                        tRCOption.setKey(stringArray[n][0]);
                        tRCOption.setValue(stringArray[n][1]);
                        tRCOption.setConfiguration(tRCConfiguration);
                        ++n;
                    }
                    tRCOption = hierarchyFactory.createTRCOption();
                    tRCOption.setKey("BOUNDARY_DEPTH");
                    tRCOption.setValue(String.valueOf(this._optionsUI.getCollectionDepth()));
                    tRCOption.setConfiguration(tRCConfiguration);
                } else if (this._optionsUI.getExecution()) {
                    stringArray = Options.OPTIONS_EXECUTION_FLOW;
                    n = 0;
                    while (n < stringArray.length) {
                        tRCOption = hierarchyFactory.createTRCOption();
                        tRCOption.setKey(stringArray[n][0]);
                        tRCOption.setValue(stringArray[n][1]);
                        tRCOption.setConfiguration(tRCConfiguration);
                        ++n;
                    }
                } else {
                    stringArray = Options.OPTIONS_EXECUTION_FLOW_NONE;
                    n = 0;
                    while (n < stringArray.length) {
                        tRCOption = hierarchyFactory.createTRCOption();
                        tRCOption.setKey(stringArray[n][0]);
                        tRCOption.setValue(stringArray[n][1]);
                        tRCOption.setConfiguration(tRCConfiguration);
                        ++n;
                    }
                }
                if (this._optionsUI.getExecution() && !this._optionsUI.getHeap()) {
                    stringArray = Options.OPTIONS_NO_INSTANCE_INFORMATION;
                    n = 0;
                    while (n < stringArray.length) {
                        tRCOption = hierarchyFactory.createTRCOption();
                        tRCOption.setKey(stringArray[n][0]);
                        tRCOption.setValue(stringArray[n][1]);
                        tRCOption.setConfiguration(tRCConfiguration);
                        ++n;
                    }
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                concurrentModificationException.printStackTrace();
            }
        }
    }

    protected void updateConfigData(EList eList) {
        this._optionsUI.setExecutionBoundary(false);
        IPreferenceStore iPreferenceStore = UIPlugin.getDefault().getPreferenceStore();
        this._optionsUI.setCollectionDepth(iPreferenceStore.getString("collect_depth"));
        if (eList != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                TRCOption tRCOption = (TRCOption)iterator.next();
                if (tRCOption.getKey().equals("STACK_INFORMATION")) {
                    this._optionsUI.setExecution(true);
                    if (tRCOption.getValue().equals("boundaryAndContiguous")) {
                        this._optionsUI.setExecutionBoundary(true);
                        continue;
                    }
                    if (!tRCOption.getValue().equals("none")) continue;
                    this._optionsUI.setExecution(false);
                    continue;
                }
                if (tRCOption.getKey().equals("TRACE_MODE")) {
                    if (tRCOption.getValue().equals("noObjectCorrelation")) {
                        this._optionsUI.setHeap(false);
                    }
                    if (!tRCOption.getValue().equals("default")) continue;
                    this._optionsUI.setHeap(true);
                    continue;
                }
                if (!tRCOption.getKey().equals("BOUNDARY_DEPTH")) continue;
                this._optionsUI.setCollectionDepth(tRCOption.getValue());
                this._optionsUI.setExecutionBoundary(true);
                this._optionsUI.setExecution(true);
            }
        }
        this._optionsUI.enableBtnGroup();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            if (!((OpenProfAgentWizard)this.getWizard()).isProfilingAgent()) {
                this.getControl().setEnabled(false);
                this.getControl().setVisible(false);
                this.setDescription(UIPlugin.getResourceString("STR_OPTION_IGNORED"));
            } else {
                this.getControl().setEnabled(true);
                this.getControl().setVisible(true);
                this.setDescription(UIPlugin.getResourceString("PROF_FILTER_DESC"));
            }
        }
    }
}

