/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileUI;
import org.eclipse.hyades.trace.ui.internal.util.DoubleCTree;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.wizard.AttachLocalWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.AttachRemoteWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.RelaunchWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class ProfileOptionsPage
extends WizardPage {
    protected TraceProfileUI _profileUI;
    protected String _type;

    public ProfileOptionsPage(String string, String string2) {
        super(string);
        this._type = string2;
        this.setTitle(UIPlugin.getResourceString("STR_FILTERS_PAGE"));
        this.setDescription(UIPlugin.getResourceString("STR_FILTERS_DESCR"));
    }

    public void alterFilterSetChildren(FilterSetElement filterSetElement, ArrayList arrayList) {
        this._profileUI.alterFilterSetChildren(filterSetElement, arrayList);
    }

    public void addFilterSet(String string, boolean bl, ArrayList arrayList) {
        FilterSetElement filterSetElement = new FilterSetElement(string, bl);
        filterSetElement.setChildren(arrayList);
        this._profileUI.addFilterSet(filterSetElement);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 500;
        gridData.heightHint = 500;
        composite2.setLayoutData((Object)gridData);
        this._profileUI = new TraceProfileUI();
        this._profileUI.createControl(composite2);
        this.setControl((Control)composite2);
        this.initializeValues();
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)(UIPlugin.getPluginId() + ".pfwp0000"));
    }

    public boolean finish() {
        TraceProfileUI.storeValues(this._profileUI.getFilterSet());
        return true;
    }

    public ArrayList getFilterSet() {
        return this._profileUI.getFilterSet();
    }

    private void initializeValues() {
        if (this.getWizard() instanceof RelaunchWizard) {
            ((RelaunchWizard)this.getWizard()).setAgentFilters();
        } else {
            String string = UIPlugin.getDefault().getPreferenceStore().getString("set_filters");
            this.setFilters(string);
        }
    }

    public void setFilters(String string) {
        this._profileUI.setFilterSet(string);
    }

    public void removeFilterSet(int n) {
        this._profileUI.removeFilterSet(n);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            Vector vector = this.getAgentsList();
            if (vector != null && !this.hasProfilingAgent(vector)) {
                this.getControl().setEnabled(false);
                this.getControl().setVisible(false);
                this.setDescription(UIPlugin.getResourceString("STR_FILTER_IGNORED"));
            } else {
                this.getControl().setEnabled(true);
                this.getControl().setVisible(true);
                this.setDescription(UIPlugin.getResourceString("STR_FILTERS_DESCR"));
            }
        }
    }

    private Vector getAgentsList() {
        DoubleCTree doubleCTree = null;
        Vector vector = null;
        if (this._type.equals("AttachLocalWizard")) {
            doubleCTree = ((AttachLocalWizard)this.getWizard()).getAgentList();
        } else if (this._type.equals("AttachRemoteWizard")) {
            doubleCTree = ((AttachRemoteWizard)this.getWizard()).getAgentList();
        }
        if (doubleCTree != null) {
            vector = doubleCTree.getSelectedAgents();
        }
        return vector;
    }

    private boolean hasProfilingAgent(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Agent agent = (Agent)vector.elementAt(n);
            if (agent.getType() != null && agent.getType().equals("Profiler") && !agent.getName().equals("J2EE Request Profiler")) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

