/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.EnvTableElement;
import org.eclipse.hyades.trace.ui.internal.core.LaunchProcessUI;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceArguments;
import org.eclipse.hyades.trace.ui.internal.wizard.RelaunchWizard;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class RelaunchDataPage
extends WizardPage
implements ModifyListener {
    private LaunchProcessUI _processUI;
    private String _hostName;
    private int _portNumber;
    private String _selectedProject;
    private String _selectedMonitor;
    private String _profileFile;
    private boolean success = true;

    public RelaunchDataPage(String string) {
        super(string);
        this.setTitle(UIPlugin.getResourceString("PROCESS_WIZARD_TITLE"));
        this.setDescription(UIPlugin.getResourceString("RELAUNCH_CLASS_DESC"));
        this.setImageDescriptor(UIPlugin.getImageDescriptor("launch_wiz.gif"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 10;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._processUI = new LaunchProcessUI();
        Composite composite3 = this._processUI.createControl(composite2);
        this._processUI.getClassUI().addModifyListener((ModifyListener)this);
        this._processUI.setShell(this.getShell());
        this.setPageComplete(false);
        this.setControl((Control)composite2);
        this.initializePage();
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)(UIPlugin.getPluginId() + ".rrdp0000"));
    }

    public boolean finish(String string, String string2, String string3) {
        this._selectedProject = string;
        this._selectedMonitor = string2;
        this._profileFile = string3;
        return this.finish();
    }

    public boolean finish() {
        this._portNumber = Integer.parseInt(((RelaunchWizard)this.getWizard()).getNodeUI().getPortNumberUI().getText().trim());
        TraceArguments traceArguments = new TraceArguments(this._processUI.getClassName());
        if (this._profileFile != null || this._profileFile.trim().equals("")) {
            traceArguments.setProfileFile(this._profileFile);
        }
        traceArguments.setHostName(this._hostName);
        traceArguments.setClassPath(this._processUI.getClassPath());
        traceArguments.setParameters(this._processUI.getParametersUI().getText().trim());
        traceArguments.setVMArguments(this._processUI.getVMArgs().trim());
        traceArguments.setPortNumber(this._portNumber);
        traceArguments.setEnvironmentVariable(this._processUI.getEnvData());
        TRCProcessProxy tRCProcessProxy = ((RelaunchWizard)this.getWizard()).getProcess();
        if (tRCProcessProxy != null) {
            traceArguments.setLocation(tRCProcessProxy.getLocation());
        }
        ArrayList arrayList = new ArrayList();
        if (((RelaunchWizard)this.getWizard()).isProfilingEnabled()) {
            ArrayList arrayList2 = ((RelaunchWizard)this.getWizard()).getFilterSet();
            int n = 0;
            while (n < arrayList2.size()) {
                FilterSetElement filterSetElement = (FilterSetElement)arrayList2.get(n);
                if (filterSetElement.getEnabled()) {
                    UIPlugin.getDefault().getPluginPreferences().setValue("filter_name", filterSetElement.getName());
                    arrayList = filterSetElement.getChildren();
                    break;
                }
                ++n;
            }
        }
        this.success = PDCoreUtil.launchTrace(traceArguments, arrayList, ((RelaunchWizard)this.getWizard()).getOptions(), this._selectedProject, this._selectedMonitor);
        if (traceArguments.getType() != null) {
            UIPlugin.getDefault().getTraceManager().registerTrace(traceArguments.getType());
        }
        return this.success;
    }

    public String getClassName() {
        return this._processUI.getClassName();
    }

    public String getClassPath() {
        return this._processUI.getClassPath();
    }

    private void initializeFromWorkbench(IType iType) {
        try {
            String string;
            IClasspathEntry[] iClasspathEntryArray;
            IJavaProject iJavaProject = iType.getJavaProject();
            String string2 = iType.getElementName();
            String string3 = iType.getFullyQualifiedName();
            IWorkspace iWorkspace = UIPlugin.getPluginWorkbench();
            IPath iPath = iWorkspace.getRoot().getLocation();
            String string4 = iJavaProject.getProject().getLocation().toOSString();
            String string5 = "";
            if (!string4.startsWith(iPath.toOSString())) {
                string5 = string4 + File.pathSeparator;
            }
            if ((iClasspathEntryArray = iJavaProject.getResolvedClasspath(true)) != null) {
                int n = 0;
                while (n < iClasspathEntryArray.length) {
                    string = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntryArray[n]);
                    if (string != null) {
                        IPath iPath2 = string.getPath();
                        if (!string5.equals("")) {
                            string5 = string5 + "\n";
                        }
                        string5 = iPath2.getDevice() != null ? string5 + iPath2.toOSString() + File.pathSeparator : string5 + iPath.append(iPath2).toOSString() + File.pathSeparator;
                    }
                    ++n;
                }
            }
            String string6 = "";
            string = "";
            this._processUI.getClassPathUI().setText(string5.trim());
            this._processUI.getParametersUI().setText(string6.trim());
            this._processUI.getVMArgsUI().setText(string.trim());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._processUI.enable(false, true, false, true, true);
    }

    private void initializePage() {
        TraceArguments traceArguments;
        Object object = ((RelaunchWizard)this.getWizard()).getSelection();
        if (object == null) {
            return;
        }
        IType iType = null;
        TRCProcessProxy tRCProcessProxy = null;
        TRCAgentProxy tRCAgentProxy = null;
        if (object instanceof IType) {
            iType = (IType)object;
            traceArguments = UIPlugin.getDefault().getTraceManager().findTrace(iType);
            if (traceArguments != null) {
                tRCProcessProxy = traceArguments.getProcess();
                tRCAgentProxy = traceArguments.getAgent();
            }
        } else if (object instanceof TRCAgentProxy) {
            tRCAgentProxy = (TRCAgentProxy)object;
            tRCProcessProxy = tRCAgentProxy.getProcessProxy();
        } else if (object instanceof TRCProcessProxy) {
            tRCProcessProxy = (TRCProcessProxy)object;
        }
        if (iType != null) {
            this.initializeFromWorkbench(iType);
            this._processUI.getClassUI().setText(iType.getFullyQualifiedName());
        }
        if (tRCProcessProxy == null) {
            return;
        }
        traceArguments = tRCProcessProxy.getNode();
        if (iType == null) {
            String string = tRCProcessProxy.getName();
            this._processUI.getClassUI().setText(string);
            if (tRCProcessProxy.getClasspath() != null) {
                this._processUI.getClassPathUI().setText(tRCProcessProxy.getClasspath());
            }
            if (tRCProcessProxy.getParameters() != null) {
                this._processUI.getParametersUI().setText(tRCProcessProxy.getParameters());
            }
            if (tRCProcessProxy.getVmArguments() != null) {
                this._processUI.getVMArgsUI().setText(tRCProcessProxy.getVmArguments());
            }
            if (tRCProcessProxy.getEnvironmentVariables() != null) {
                this.setEnvironment(this._processUI, tRCProcessProxy);
            }
        }
        boolean bl = false;
        this._hostName = traceArguments.getName();
        try {
            Node node = NodeFactory.createNode((String)this._hostName);
            if (node.getInetAddress().equals(InetAddress.getLocalHost())) {
                bl = true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this._processUI.enable(false, true, false, bl, true);
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.setPageComplete(!this._processUI.getClassUI().getText().trim().equals(""));
    }

    public void setEnvironment(LaunchProcessUI launchProcessUI, TRCProcessProxy tRCProcessProxy) {
        ArrayList<EnvTableElement> arrayList = new ArrayList<EnvTableElement>();
        EList eList = tRCProcessProxy.getEnvironmentVariables();
        int n = 0;
        while (n < eList.size()) {
            TRCEnvironmentVariable tRCEnvironmentVariable = (TRCEnvironmentVariable)eList.get(n);
            EnvTableElement envTableElement = new EnvTableElement(tRCEnvironmentVariable.getName(), tRCEnvironmentVariable.getValue());
            arrayList.add(envTableElement);
            ++n;
        }
        launchProcessUI.setEnvData(arrayList);
    }
}

