/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.adapter.internal.SinglePatternPage;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.GraphColorDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.part.IPage;

public class SinglePatternViewer
extends TraceViewer {
    protected Action _next;
    protected Action _previous;
    protected Action _update;
    protected Action _caller;
    protected Action _callee;
    protected Action _openSource;
    protected Action _showRawTime;
    private Action _zoomInAction;
    private Action _zoomOutAction;
    private Action _stdSelectAction;
    protected Action _showCompensatedTime;
    private boolean _stdSelect = true;
    private boolean _zoomIn = false;
    private boolean _zoomOut = false;

    public Action callee() {
        return this._callee;
    }

    public Action caller() {
        return this._caller;
    }

    public TraceViewerPage createPage(EObject eObject) {
        return new SinglePatternPage(eObject, this);
    }

    public void dispose() {
        Enumeration enumeration = this._pages.elements();
        while (enumeration.hasMoreElements()) {
            IPage iPage = (IPage)enumeration.nextElement();
            if (!(iPage instanceof SinglePatternPage)) continue;
            ((SinglePatternPage)iPage).dispose();
        }
        this._openSource = null;
        this._showCompensatedTime = null;
        this._showRawTime = null;
        this._stdSelectAction = null;
        this._zoomInAction = null;
        this._zoomOutAction = null;
        this._previous = null;
        this._next = null;
        this._callee = null;
        this._caller = null;
        super.dispose();
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        String string = TraceUIPlugin.getString("STR_COMPENSATED_TIME");
        this._showCompensatedTime = new Action(string){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 0);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showCompensatedTime.setText(string);
        this._showCompensatedTime.setDescription(string);
        this._showCompensatedTime.setToolTipText(string);
        int n = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showCompensatedTime.setChecked(n == 0);
        String string2 = TraceUIPlugin.getString("STR_RAW_TIME");
        this._showRawTime = new Action(string2){

            public void run() {
                TraceUIPlugin.getDefault().getPreferenceStore().setValue("time_display", 1);
                TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
            }
        };
        this._showRawTime.setText(string2);
        this._showRawTime.setDescription(string2);
        this._showRawTime.setToolTipText(string2);
        n = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        this._showRawTime.setChecked(n == 1);
        String string3 = TraceUIPlugin.getString("STR_PREVIOUS");
        this._previous = new Action(string3){

            public void run() {
                SinglePatternPage singlePatternPage = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (singlePatternPage == null) {
                    return;
                }
                singlePatternPage.getView().previous();
            }
        };
        this._previous.setText(string3);
        TracePluginImages.setImageDescriptors((IAction)this._previous, "lcl16", "prev_nav.gif");
        this._previous.setDescription(string3);
        this._previous.setToolTipText(TraceUIPlugin.getString("STR_PREV_TEXT"));
        String string4 = TraceUIPlugin.getString("STR_NEXT");
        this._next = new Action(string4){

            public void run() {
                SinglePatternPage singlePatternPage = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (singlePatternPage == null) {
                    return;
                }
                singlePatternPage.getView().next();
            }
        };
        this._next.setText(string4);
        TracePluginImages.setImageDescriptors((IAction)this._next, "lcl16", "next_nav.gif");
        this._next.setDescription(string4);
        this._next.setToolTipText(TraceUIPlugin.getString("STR_NEXT_TEXT"));
        String string5 = TraceUIPlugin.getString("STR_HOME");
        this._update = new Action(string5){

            public void run() {
                SinglePatternPage singlePatternPage = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (singlePatternPage == null) {
                    return;
                }
                singlePatternPage.getView().updateUI();
                singlePatternPage.getView().updateButtons();
            }
        };
        this._update.setText(string5);
        TracePluginImages.setImageDescriptors((IAction)this._update, "tool16", "home_nav.gif");
        this._update.setDescription(string5);
        this._update.setToolTipText(string5);
        String string6 = TraceUIPlugin.getString("STR_STD_SELECT");
        this._stdSelectAction = new Action(string6){

            public void run() {
                SinglePatternPage singlePatternPage = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (singlePatternPage == null) {
                    return;
                }
                SinglePatternViewer.this._stdSelect = true;
                SinglePatternViewer.this._zoomIn = !SinglePatternViewer.this._stdSelect;
                SinglePatternViewer.this._zoomOut = !SinglePatternViewer.this._stdSelect;
                SinglePatternViewer.this._stdSelectAction.setChecked(true);
                SinglePatternViewer.this._zoomInAction.setChecked(false);
                SinglePatternViewer.this._zoomOutAction.setChecked(false);
                singlePatternPage.getView().zoomIn(SinglePatternViewer.this._zoomIn);
                singlePatternPage.getView().zoomOut(SinglePatternViewer.this._zoomOut);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._stdSelectAction.setText(string6);
        TracePluginImages.setImageDescriptors((IAction)this._stdSelectAction, "lcl16", "select_zoomin.gif");
        this._stdSelectAction.setDescription(string6);
        this._stdSelectAction.setToolTipText(string6);
        String string7 = TraceUIPlugin.getString("STR_ZOOM_IN");
        this._zoomInAction = new Action(string7){

            public void run() {
                SinglePatternPage singlePatternPage = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (singlePatternPage == null) {
                    return;
                }
                SinglePatternViewer.this._zoomIn = this.isChecked();
                if (!SinglePatternViewer.this._zoomIn) {
                    SinglePatternViewer.this._stdSelect = true;
                } else {
                    SinglePatternViewer.this._stdSelect = !SinglePatternViewer.this._zoomIn;
                    SinglePatternViewer.this._zoomOut = !SinglePatternViewer.this._zoomIn;
                }
                if (SinglePatternViewer.this._zoomIn) {
                    SinglePatternViewer.this._stdSelectAction.setChecked(false);
                    SinglePatternViewer.this._zoomOutAction.setChecked(false);
                } else {
                    SinglePatternViewer.this._stdSelectAction.setChecked(true);
                }
                singlePatternPage.getView().zoomIn(SinglePatternViewer.this._zoomIn);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._zoomInAction.setText(string7);
        TracePluginImages.setImageDescriptors((IAction)this._zoomInAction, "lcl16", "zoomin_nav.gif");
        this._zoomInAction.setDescription(string7);
        this._zoomInAction.setToolTipText(string7);
        String string8 = TraceUIPlugin.getString("STR_ZOOM_OUT");
        this._zoomOutAction = new Action(string8){

            public void run() {
                SinglePatternPage singlePatternPage = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (singlePatternPage == null) {
                    return;
                }
                SinglePatternViewer.this._zoomOut = this.isChecked();
                if (!SinglePatternViewer.this._zoomOut) {
                    SinglePatternViewer.this._stdSelect = true;
                } else {
                    SinglePatternViewer.this._stdSelect = !SinglePatternViewer.this._zoomOut;
                    SinglePatternViewer.this._zoomIn = !SinglePatternViewer.this._zoomOut;
                }
                if (SinglePatternViewer.this._zoomOut) {
                    SinglePatternViewer.this._stdSelectAction.setChecked(false);
                    SinglePatternViewer.this._zoomInAction.setChecked(false);
                } else {
                    SinglePatternViewer.this._stdSelectAction.setChecked(true);
                }
                singlePatternPage.getView().zoomOut(SinglePatternViewer.this._zoomOut);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._zoomOutAction.setText(string8);
        TracePluginImages.setImageDescriptors((IAction)this._zoomOutAction, "lcl16", "zoomout_nav.gif");
        this._zoomOutAction.setDescription(string8);
        this._zoomOutAction.setToolTipText(string8);
        String string9 = TraceUIPlugin.getString("STR_CALLER");
        this._caller = new Action(string9){

            public void run() {
                SinglePatternPage singlePatternPage = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (singlePatternPage == null) {
                    return;
                }
                singlePatternPage.getView().showCaller();
            }
        };
        this._caller.setText(string9);
        TracePluginImages.setImageDescriptors((IAction)this._caller, "lcl16", "showcaller_co.gif");
        this._caller.setDescription(string9);
        this._caller.setToolTipText(string9);
        String string10 = TraceUIPlugin.getString("STR_CALLEE");
        this._callee = new Action(string10){

            public void run() {
                SinglePatternPage singlePatternPage = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (singlePatternPage == null) {
                    return;
                }
                singlePatternPage.getView().showCallee();
            }
        };
        this._callee.setText(string10);
        TracePluginImages.setImageDescriptors((IAction)this._callee, "lcl16", "caller_co.gif");
        this._callee.setDescription(string10);
        this._callee.setToolTipText(string10);
        String string11 = TraceUIPlugin.getString("STR_SOURCE");
        this._openSource = new Action(string11){

            public void run() {
                SinglePatternPage singlePatternPage = (SinglePatternPage)SinglePatternViewer.this.getCurrentPage();
                if (singlePatternPage == null) {
                    return;
                }
                singlePatternPage.getView().openSource();
            }
        };
        this._openSource.setText(string11);
        TracePluginImages.setImageDescriptors((IAction)this._openSource, "tool16", "opensource_co.gif");
        this._openSource.setDescription(string11);
        this._openSource.setToolTipText(string11);
        Action action = new Action(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT")){

            public void run() {
                GraphColorDialog graphColorDialog = new GraphColorDialog(SinglePatternViewer.this.getViewSite().getShell(), TraceUIPlugin.getString("STR_GRAPH_COLOR_DLG"), null);
                graphColorDialog.open();
            }
        };
        action.setText(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));
        TracePluginImages.setImageDescriptors((IAction)action, "tool16", "opengraphcolor_co.gif");
        action.setDescription(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));
        action.setToolTipText(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        IMenuManager iMenuManager = this.getViewSite().getActionBars().getMenuManager();
        MenuManager menuManager = new MenuManager(TraceUIPlugin.getString("STR_SHOW_TIME"));
        iMenuManager.add((IContributionItem)menuManager);
        menuManager.add((IAction)this._showCompensatedTime);
        menuManager.add((IAction)this._showRawTime);
        iToolBarManager.removeAll();
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this._openSource);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this._caller);
        iToolBarManager.add((IAction)this._callee);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this._previous);
        iToolBarManager.add((IAction)this._next);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this._stdSelectAction);
        iToolBarManager.add((IAction)this._zoomInAction);
        iToolBarManager.add((IAction)this._zoomOutAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this._update);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)action);
        this.getViewSite().getActionBars().updateActionBars();
    }

    public Action next() {
        return this._next;
    }

    public Action openSource() {
        return this._openSource;
    }

    public Action previous() {
        return this._previous;
    }

    public void setFocus() {
        if (this.getCurrentPage() != null) {
            ((SinglePatternPage)this.getCurrentPage()).setFocus();
        }
    }

    public Action updateBtn() {
        return this._update;
    }

    public Action baseTime() {
        return this._showCompensatedTime;
    }

    public Action rawTime() {
        return this._showRawTime;
    }

    public boolean isValidObject(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TRCMonitor || object instanceof TRCNode) {
            return true;
        }
        if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Profiler")) {
            return true;
        }
        if (object instanceof TRCProcessProxy) {
            EList eList = ((TRCProcessProxy)object).getAgentProxies();
            int n = 0;
            while (n < eList.size()) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)eList.get(n);
                if (tRCAgentProxy != null && !tRCAgentProxy.eIsProxy() && tRCAgentProxy.getType().equals("Profiler")) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public EObject getObjectToView(EObject eObject) {
        if (eObject == null) {
            return eObject;
        }
        if (eObject instanceof TRCProcessProxy) {
            int n = 0;
            TRCAgentProxy tRCAgentProxy = null;
            EList eList = ((TRCProcessProxy)eObject).getAgentProxies();
            int n2 = 0;
            while (n2 < eList.size()) {
                TRCAgentProxy tRCAgentProxy2 = (TRCAgentProxy)eList.get(n2);
                if (tRCAgentProxy2 != null && !tRCAgentProxy2.eIsProxy() && tRCAgentProxy2.getType().equals("Profiler")) {
                    ++n;
                    tRCAgentProxy = tRCAgentProxy2;
                }
                ++n2;
            }
            if (n == 1) {
                return tRCAgentProxy;
            }
        }
        return eObject;
    }

    public String getViewTitle() {
        return TraceUIPlugin.getString("STR_METH_INVOC_TITLE");
    }

    public void initializeActionBar() {
        this._stdSelectAction.setChecked(true);
    }
}

