/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.util;

import org.eclipse.hyades.sd.ui.SDPlugin;
import org.eclipse.hyades.sd.ui.SDPluginImages;
import org.eclipse.hyades.sd.ui.internal.model.Graph;
import org.eclipse.hyades.sd.ui.internal.model.GraphNode;
import org.eclipse.hyades.sd.ui.internal.util.SearchTab;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class DrawAreaFindDialog
extends Dialog {
    List containerList;
    private int containerCount = 0;
    private Graph graph = null;
    private GraphNode[] containers = null;
    private GraphNode selectedNode = null;
    private TabFolder folder = null;
    private TabItem item = null;
    private SearchTab searchTab = null;

    public DrawAreaFindDialog(Shell shell, Graph graph) {
        super(shell);
        this.containers = graph.getTopNodes();
        this.containerCount = graph.getTopNodeCount();
        this.graph = graph;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SDPlugin.getString("STR_FIND"));
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.getButton().setText(SDPlugin.getString("STR_BUTTON_SEARCH"));
        this.getButton().setEnabled(false);
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 15;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        composite2.setLayoutData((Object)gridData);
        this.folder = new TabFolder(composite2, 0);
        gridData = GridUtil.createFill();
        gridData.heightHint = 200;
        gridData.widthHint = 300;
        this.folder.setLayoutData((Object)gridData);
        if (this.graph.getType() == 17) {
            this.createClassTab();
        } else if (this.graph.getType() == 16) {
            this.createClassTab();
            this.createObjectTab();
        } else if (this.graph.getType() == 15) {
            this.createHostTab();
        } else if (this.graph.getType() == 19) {
            this.createProcessTab();
        } else if (this.graph.getType() == 20) {
            this.createAgentTab();
        } else if (this.graph.getType() == 18) {
            this.createThreadTab();
        } else if (this.graph.getType() == 22) {
            this.createLogThreadTab();
        } else if (this.graph.getType() == 21) {
            this.createLogTab();
        }
        return composite2;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public GraphNode getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(GraphNode graphNode) {
        this.selectedNode = graphNode;
        this.getButton().setEnabled(graphNode != null);
    }

    private void createClassTab() {
        this.item = new TabItem(this.folder, 0);
        this.item.setText(SDPlugin.getString("STR_CLASS_SEARCH"));
        this.item.setImage(SDPluginImages.getImage("searchclass_obj.gif"));
        this.searchTab = new SearchTab(this.containers, this.containerCount, 7, this);
        this.item.setControl(this.searchTab.createContents((Composite)this.folder));
    }

    private void createObjectTab() {
        this.item = new TabItem(this.folder, 0);
        this.item.setText(SDPlugin.getString("STR_OBJECT_SEARCH"));
        this.item.setImage(SDPluginImages.getImage("searchobject_obj.gif"));
        this.searchTab = new SearchTab(this.containers, this.containerCount, 6, this);
        this.item.setControl(this.searchTab.createContents((Composite)this.folder));
    }

    private void createHostTab() {
        this.item = new TabItem(this.folder, 0);
        this.item.setText(SDPlugin.getString("STR_HOST_SEARCH"));
        this.item.setImage(SDPluginImages.getImage("searchhost_obj.gif"));
        this.searchTab = new SearchTab(this.containers, this.containerCount, 2, this);
        this.item.setControl(this.searchTab.createContents((Composite)this.folder));
    }

    private void createAgentTab() {
        this.item = new TabItem(this.folder, 0);
        this.item.setText(SDPlugin.getString("STR_AGENT_SEARCH"));
        this.item.setImage(SDPluginImages.getImage("searchagent_obj.gif"));
        this.searchTab = new SearchTab(this.containers, this.containerCount, 3, this);
        this.item.setControl(this.searchTab.createContents((Composite)this.folder));
    }

    private void createProcessTab() {
        this.item = new TabItem(this.folder, 0);
        this.item.setText(SDPlugin.getString("STR_PROCESS_SEARCH"));
        this.item.setImage(SDPluginImages.getImage("searchprocess_obj.gif"));
        this.searchTab = new SearchTab(this.containers, this.containerCount, 4, this);
        this.item.setControl(this.searchTab.createContents((Composite)this.folder));
    }

    private void createThreadTab() {
        this.item = new TabItem(this.folder, 0);
        this.item.setText(SDPlugin.getString("STR_THREAD_SEARCH"));
        this.item.setImage(SDPluginImages.getImage("searchthread_obj.gif"));
        this.searchTab = new SearchTab(this.containers, this.containerCount, 5, this);
        this.item.setControl(this.searchTab.createContents((Composite)this.folder));
    }

    private void createLogThreadTab() {
        this.item = new TabItem(this.folder, 0);
        this.item.setText(SDPlugin.getString("STR_THREAD_SEARCH"));
        this.item.setImage(SDPluginImages.getImage("searchlog_obj.gif"));
        this.searchTab = new SearchTab(this.containers, this.containerCount, 11, this);
        this.item.setControl(this.searchTab.createContents((Composite)this.folder));
    }

    private void createLogTab() {
        this.item = new TabItem(this.folder, 0);
        this.item.setText(SDPlugin.getString("STR_LOG_SEARCH"));
        this.item.setImage(SDPluginImages.getImage("searchlog_obj.gif"));
        this.searchTab = new SearchTab(this.containers, this.containerCount, 11, this);
        this.item.setControl(this.searchTab.createContents((Composite)this.folder));
    }

    public Button getButton() {
        return this.getButton(0);
    }
}

