/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.ui.internal.util;

import java.text.NumberFormat;
import org.eclipse.hyades.sd.ui.internal.model.Increment;
import org.eclipse.hyades.sd.ui.internal.util.LogCDrawUtils;
import org.eclipse.hyades.sd.ui.internal.views.SDViewerUI;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class DrawAreaWeightScale
extends Canvas
implements PaintListener,
MouseListener,
MouseMoveListener,
MouseTrackListener {
    Increment[] increments = null;
    GC gc;
    Composite parent;
    private static NumberFormat _decimalFormat = null;
    private static NumberFormat _decimalFormatCompact = null;
    int[] divisions = new int[7];

    public DrawAreaWeightScale(Composite composite, int n) {
        super(composite, 526336);
        LogCDrawUtils.setWeightSelection(-1, null);
        this.parent = composite;
        this.gc = new GC((Drawable)this);
        this.addPaintListener(this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseTrackListener(this);
    }

    public void setWeights(Increment[] incrementArray) {
        this.increments = incrementArray;
        this.calculateDivisions();
    }

    public void paintControl(PaintEvent paintEvent) {
        this.drawSelf();
    }

    public void drawSelf() {
        if (this.increments == null || this.increments.length == 0) {
            return;
        }
        int n = LogCDrawUtils.getBoxSpace();
        int n2 = LogCDrawUtils.getStartPosition();
        int n3 = LogCDrawUtils.getTimeUnit();
        int n4 = LogCDrawUtils.getWeightScaleWidth();
        this.gc.setBackground(Display.getCurrent().getSystemColor(22));
        this.gc.fillRectangle(0, 0, n4, this.getSize().y);
        int n5 = 0;
        int n6 = 0;
        while (n5 <= (this.getSize().y - 16) / n3 && n2 + n5 + 1 < this.increments.length && this.increments[n2 + n5 + 1] != null) {
            int n7 = this.increments[n2 + n5 + 1].getWeight();
            n6 = this.getDivision(n7);
            if (n7 <= 0) {
                n7 = 0;
            }
            Color color = new Color(null, 255, 255 - n6 * 32, 255 - n6 * 32);
            this.gc.setBackground(color);
            color.dispose();
            this.gc.fillRectangle(0, n + n5 * n3 - 1, n4, n3);
            ++n5;
        }
    }

    private int getDivision(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < 7) {
            if (n > this.divisions[n3]) {
                n2 = n3;
            }
            ++n3;
        }
        return n2 + 1;
    }

    private void calculateDivisions() {
        int n = 0;
        int n2 = 0;
        while (this.increments[n2] != null) {
            n += this.increments[n2].getWeight();
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        this.divisions[3] = n / n2;
        this.divisions[1] = this.divisions[3] / 2;
        this.divisions[0] = this.divisions[1] / 2;
        this.divisions[2] = this.divisions[0] + this.divisions[1];
        this.divisions[5] = (255 - this.divisions[3]) / 2;
        this.divisions[4] = (this.divisions[5] - this.divisions[3]) / 2;
        this.divisions[6] = this.divisions[5] + (255 - this.divisions[5]) / 2;
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
        LogCDrawUtils.setWeightSelection(-1, null);
        ((SDViewerUI)this.parent).updateUI();
        int n = LogCDrawUtils.getBoxSpace();
        int n2 = LogCDrawUtils.getTimeUnit();
        int n3 = LogCDrawUtils.getStartPosition();
        int n4 = (mouseEvent.y - n) / n2;
        int n5 = this.increments[n3 + n4 + 1].getWeight();
        int n6 = this.getDivision(n5);
        LogCDrawUtils.setWeightSelection(n3 + n4, new Color(null, 255, 255 - n6 * 32, 255 - n6 * 32));
        ((SDViewerUI)this.parent).updateUI();
    }

    public void mouseDown(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
    }

    public void mouseMove(MouseEvent mouseEvent) {
        if (this.increments == null) {
            return;
        }
        int n = LogCDrawUtils.getBoxSpace();
        if (mouseEvent.y < n) {
            ((SDViewerUI)this.parent).removeToolTip();
            return;
        }
        int n2 = (mouseEvent.y + 1 - n) / LogCDrawUtils.getTimeUnit();
        if (n2 < 0 || n2 >= this.increments.length) {
            ((SDViewerUI)this.parent).removeToolTip();
            return;
        }
        Increment increment = this.increments[LogCDrawUtils.getStartPosition() + n2 + 1];
        if (increment == null) {
            ((SDViewerUI)this.parent).removeToolTip();
            return;
        }
        ((SDViewerUI)this.parent).setToolTip(mouseEvent.x, mouseEvent.y, DrawAreaWeightScale.formatTimeValue(increment.getDeltaTime(), false));
    }

    public void mouseEnter(MouseEvent mouseEvent) {
    }

    public void mouseExit(MouseEvent mouseEvent) {
        ((SDViewerUI)this.parent).removeToolTip();
    }

    public void mouseHover(MouseEvent mouseEvent) {
    }

    public static String formatTimeValue(double d, boolean bl) {
        if (_decimalFormat == null) {
            _decimalFormat = NumberFormat.getNumberInstance();
            _decimalFormat.setMaximumIntegerDigits(6);
            _decimalFormat.setMaximumFractionDigits(12);
            _decimalFormat.setMinimumFractionDigits(12);
            _decimalFormatCompact = NumberFormat.getNumberInstance();
            _decimalFormatCompact.setMaximumIntegerDigits(6);
            _decimalFormatCompact.setMaximumFractionDigits(12);
        }
        return bl ? _decimalFormatCompact.format(d) : _decimalFormat.format(d);
    }
}

