/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.commons;

import org.apache.commons.logging.Log;
import org.eclipse.hyades.internal.logging.core.XmlGenerator;
import org.eclipse.hyades.logging.core.IExternalizableToXml;
import org.eclipse.hyades.logging.core.LoggingAgent;

public class Logger
implements Log {
    public static final int TRACE_LEVEL = 0;
    public static final int DEBUG_LEVEL = 1;
    public static final int INFO_LEVEL = 2;
    public static final int WARN_LEVEL = 3;
    public static final int ERROR_LEVEL = 4;
    public static final int FATAL_LEVEL = 5;
    private static final String[] LEVEL_NAMES = new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL"};
    private LoggingAgent loggingAgent = null;
    private int loggingLevel;
    private XmlGenerator xmlGenerator = null;

    public Logger(String string) {
        this.loggingAgent = new LoggingAgent(string);
        this.loggingLevel = 3;
        this.xmlGenerator = new XmlGenerator(string);
    }

    public boolean isTraceEnabled() {
        return this.loggingLevel <= 0;
    }

    public boolean isDebugEnabled() {
        return this.loggingLevel <= 1;
    }

    public boolean isInfoEnabled() {
        return this.loggingLevel <= 2;
    }

    public boolean isWarnEnabled() {
        return this.loggingLevel <= 3;
    }

    public boolean isErrorEnabled() {
        return this.loggingLevel <= 4;
    }

    public boolean isFatalEnabled() {
        return this.loggingLevel <= 5;
    }

    public void trace(Object object) {
        if (this.isTraceEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
        }
    }

    public void trace(Object object, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void debug(Object object) {
        if (this.isDebugEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
        }
    }

    public void debug(Object object, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void info(Object object) {
        if (this.isInfoEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
        }
    }

    public void info(Object object, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void warn(Object object) {
        if (this.isWarnEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
        }
    }

    public void warn(Object object, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void error(Object object) {
        if (this.isErrorEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
        }
    }

    public void error(Object object, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void fatal(Object object) {
        if (this.isFatalEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
        }
    }

    public void fatal(Object object, Throwable throwable) {
        if (this.isFatalEnabled()) {
            this.loggingAgent.write(this.convertToXML(object));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public String getName() {
        return this.loggingAgent.getName();
    }

    public int getLevel() {
        return this.loggingLevel;
    }

    public synchronized void setLevel(int n) throws IllegalArgumentException {
        if (n < 0 || n >= LEVEL_NAMES.length) {
            throw new IllegalArgumentException("Invalid logging level");
        }
        this.loggingLevel = n;
    }

    private String convertToXML(Object object) {
        if (object instanceof IExternalizableToXml) {
            return ((IExternalizableToXml)object).externalizeCanonicalXmlString();
        }
        this.xmlGenerator.reset(LEVEL_NAMES[this.loggingLevel], false, 4);
        return this.xmlGenerator.objectToXML(object);
    }
}

