/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.facades.behavioral.test;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.IDecision;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.IStub;
import org.eclipse.hyades.models.common.facades.behavioral.ISystemUnderTest;
import org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.IVerificationPoint;

public class ValidateFacade
extends TestCase {
    protected static ITestSuite facadeTestSuite;
    protected static Set validatedTestSuites;

    public ValidateFacade(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("Facade Validation");
        testSuite.addTest((Test)new ValidateFacade("suiteSetUp"));
        testSuite.addTest((Test)new ValidateFacade("testTestSuite"));
        testSuite.addTest((Test)new ValidateFacade("testTestCases"));
        testSuite.addTest((Test)new ValidateFacade("testSystemsUnderTest"));
        testSuite.addTest((Test)new ValidateFacade("testTestComponents"));
        testSuite.addTest((Test)new ValidateFacade("suiteTearDown"));
        return testSuite;
    }

    public void suiteSetUp() {
        validatedTestSuites = new HashSet();
        facadeTestSuite = this.getFacadeTestSuite();
    }

    public void suiteTearDown() {
        validatedTestSuites.clear();
        facadeTestSuite = null;
    }

    protected ITestSuite getFacadeTestSuite() {
        return null;
    }

    public void testTestSuite() throws Exception {
        Assert.assertNotNull((Object)facadeTestSuite);
        this.validate(facadeTestSuite);
    }

    public void testTestCases() throws Exception {
        Assert.assertNotNull((Object)facadeTestSuite);
        List list = facadeTestSuite.getITestCases();
        if (list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.validate((ITestCase)iterator.next());
        }
    }

    public void testSystemsUnderTest() throws Exception {
        Assert.assertNotNull((Object)facadeTestSuite);
        List list = facadeTestSuite.getISystemsUnderTest();
        if (list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.validate((ISystemUnderTest)iterator.next());
        }
    }

    public void testStubs() throws Exception {
        Assert.assertNotNull((Object)facadeTestSuite);
        List list = facadeTestSuite.getIStubs();
        if (list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.validate((IStub)iterator.next());
        }
    }

    protected void validate(ITestSuite iTestSuite) throws Exception {
        if (validatedTestSuites.contains(iTestSuite)) {
            return;
        }
        validatedTestSuites.add(iTestSuite);
        Assert.assertNotNull((Object)iTestSuite.getName());
        this.validate(iTestSuite.getImplementor());
        Assert.assertNotNull((Object)iTestSuite.getITestCases());
        Assert.assertNotNull((Object)iTestSuite.getISystemsUnderTest());
        Assert.assertNotNull((Object)iTestSuite.getIStubs());
    }

    protected void validate(ITestCase iTestCase) throws Exception {
        Assert.assertNotNull((Object)iTestCase);
        Assert.assertNotNull((Object)iTestCase.getName());
        Assert.assertEquals((Object)iTestCase.getOwner(), (Object)facadeTestSuite);
        this.validate(iTestCase.getImplementor());
    }

    protected void validate(IImplementor iImplementor) throws Exception {
        Assert.assertNotNull((Object)iImplementor);
        if (iImplementor.isExternalImplementor()) {
            IImplementor iImplementor2 = iImplementor;
            Assert.assertNotNull((Object)iImplementor2.getResource());
        } else if (iImplementor instanceof IImplementor) {
            IImplementor iImplementor3 = iImplementor;
            Assert.assertEquals((Object)iImplementor3.getOwner(), (Object)facadeTestSuite);
        }
    }

    protected void validate(ISystemUnderTest iSystemUnderTest) throws Exception {
        Assert.assertNotNull((Object)iSystemUnderTest);
        Assert.assertNotNull((Object)iSystemUnderTest.getName());
        Assert.assertEquals((Object)iSystemUnderTest.getOwner(), (Object)facadeTestSuite);
    }

    protected void validate(IStub iStub) throws Exception {
        Assert.assertNotNull((Object)iStub.getName());
        Assert.assertEquals((Object)iStub.getOwner(), (Object)facadeTestSuite);
    }

    protected void validate(IAction iAction) throws Exception {
        Assert.assertNotNull((Object)iAction.getActionProperties());
        if (iAction instanceof IDecision) {
            IDecision iDecision = (IDecision)iAction;
            Assert.assertNotNull((Object)iDecision.getCondition());
            Assert.assertNotNull((Object)iDecision.getCondition().getConstraint());
            Assert.assertNotNull((Object)iDecision.getSuccessBlock());
            Assert.assertNotNull((Object)iDecision.getFailureBlock());
        } else if (iAction instanceof ILoop) {
            ILoop iLoop = (ILoop)iAction;
            Assert.assertNotNull((Object)iLoop.getCondition());
            Assert.assertNotNull((Object)iLoop.getCondition().getConstraint());
            Assert.assertNotNull((Object)iLoop.getBlock());
        } else if (!(iAction instanceof IVerificationPoint)) {
            if (iAction instanceof ITargetInvocation) {
                ITargetInvocation iTargetInvocation = (ITargetInvocation)iAction;
                Assert.assertNotNull((Object)iTargetInvocation.getTarget());
            } else if (iAction instanceof ITestInvocation) {
                ITestInvocation iTestInvocation = (ITestInvocation)iAction;
                ITest iTest = iTestInvocation.getInvokedTest();
                Assert.assertNotNull((Object)iTest);
                ITestSuite iTestSuite = null;
                if (iTest instanceof ITestSuite) {
                    iTestSuite = (ITestSuite)iTest;
                } else if (iTest instanceof ITestCase) {
                    iTestSuite = ((ITestCase)iTest).getOwner();
                }
                Assert.assertNotNull((Object)iTestSuite);
                this.validate(iTestSuite);
                IImplementor iImplementor = iTestInvocation.getInvokedTest().getImplementor();
                Assert.assertNotNull((Object)iImplementor);
            }
        }
    }
}

