/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.EditorPage;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditor;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.FilePropertySource;

public class SymptomDBEditorOverviewPage
extends EditorPage {
    Label txtPath;
    Label txtSize;
    Label txtLocation;
    Label txtTimeStamp;

    public SymptomDBEditorOverviewPage(RASWidgetFactory rASWidgetFactory) {
        super(rASWidgetFactory);
    }

    public void createContent(Composite composite) {
        Composite composite2 = this.factory.createCompositeSeparator(composite);
        Composite composite3 = this.factory.createComposite(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)GridUtil.createFill());
        Label label = this.factory.createLabel(composite3, SDbPlugin.getResourceString("STR_PATH_LABEL"), 0);
        this.txtPath = this.factory.createLabel(composite3, "", 0);
        this.txtPath.setLayoutData((Object)new GridData(768));
        this.txtPath.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
        Label label2 = this.factory.createLabel(composite3, SDbPlugin.getResourceString("STR_LOCATION_LABEL"), 0);
        this.txtLocation = this.factory.createLabel(composite3, "", 0);
        this.txtLocation.setLayoutData((Object)new GridData(768));
        this.txtLocation.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
        Label label3 = this.factory.createLabel(composite3, SDbPlugin.getResourceString("STR_SIZE_LABEL"), 0);
        this.txtSize = this.factory.createLabel(composite3, "", 0);
        this.txtSize.setLayoutData((Object)new GridData(768));
        this.txtSize.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
        Label label4 = this.factory.createLabel(composite3, SDbPlugin.getResourceString("STR_TIMESTAMP_LABEL"), 0);
        this.txtTimeStamp = this.factory.createLabel(composite3, "", 0);
        this.txtTimeStamp.setLayoutData((Object)new GridData(768));
        this.txtTimeStamp.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
        Composite composite4 = this.factory.createComposite(composite);
        composite4.setLayoutData((Object)GridUtil.createFill());
        Composite composite5 = this.factory.createCompositeSeparator(composite);
        Label label5 = this.factory.createLabel(composite, SDbPlugin.getResourceString("STR_INFORMATION_LABEL"), 64);
        label5.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
        this.factory.paintChildControlsFor(composite3);
    }

    public void init(SymptomDBEditor symptomDBEditor) {
        IFile iFile = symptomDBEditor.getFile();
        if (iFile != null) {
            FilePropertySource filePropertySource = new FilePropertySource(iFile);
            this.txtPath.setText((String)filePropertySource.getPropertyValue((Object)"org.eclipse.ui.path"));
            this.txtLocation.setText(iFile.getLocation().toOSString());
            this.txtSize.setText((String)filePropertySource.getPropertyValue((Object)"org.eclipse.ui.size") + " bytes");
            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 2);
            this.txtTimeStamp.setText(dateFormat.format(new Date(iFile.getLocation().toFile().lastModified())));
            Point point = this.getContent().computeSize(-1, -1);
            ((ScrolledComposite)symptomDBEditor.getControl(0)).setMinWidth(point.x);
            ((ScrolledComposite)symptomDBEditor.getControl(0)).setMinHeight(point.y);
        }
    }
}

