/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.core.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.IOrderedProperty;
import org.eclipse.hyades.execution.core.IProcessConsole;
import org.eclipse.hyades.execution.core.impl.ExecutionComponentImpl;
import org.eclipse.hyades.execution.core.impl.ProcessExecutableObjectImpl;

public class ProcessExecutorImpl
extends ExecutionComponentImpl
implements IProcessConsole,
IExecutor {
    private String name;
    private IExecutableObject exeObj;
    private OutputStream stdin;
    private InputStream stdout;
    private InputStream stderr;
    private ConsoleInputThread cin;
    private ConsoleOutputThread cout;
    private ConsoleErrorThread cerr;
    private IOrderedProperty[] processEnvironment = null;
    private int pid = 0;

    public ProcessExecutorImpl() {
        this.name = null;
    }

    public ProcessExecutorImpl(String string) {
        this.name = string;
    }

    public void init() {
        super.init();
        this.cin = new ConsoleInputThread("Process console in");
        this.cout = new ConsoleOutputThread("Process console out");
        this.cerr = new ConsoleErrorThread("Process console error");
        this.cin.setDaemon(true);
        this.cout.setDaemon(true);
        this.cerr.setDaemon(true);
    }

    public void setExecutableObject(IExecutableObject iExecutableObject) {
        this.exeObj = iExecutableObject;
    }

    public IExecutableObject getExecutableObject() {
        return this.exeObj;
    }

    public void launch() {
        IExecutionComponent iExecutionComponent;
        do {
            if (!((iExecutionComponent = this.getParent()) instanceof IExecutionEnvironment)) continue;
            this.processEnvironment = ((IExecutionEnvironment)iExecutionComponent).getEnv();
            break;
        } while (iExecutionComponent != null);
        this.cin.start();
        this.cout.start();
        this.cerr.start();
        this.pid = this.startProcess0();
        if (this.pid < 0) {
            System.out.println("Launch error, return code from startProcess0() = " + this.pid);
            return;
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            ProcessStatusThread processStatusThread = new ProcessStatusThread(this, this.pid);
            processStatusThread.start();
        }
    }

    public void kill() {
        this.killProcess0();
    }

    public OutputStream getStandardInputStream() throws ExecutionComponentStateException {
        if (this.stdin == null) {
            throw new ExecutionComponentStateException(1, "No standard input stream has been set");
        }
        return this.stdin;
    }

    public InputStream getStandardOutputStream() throws ExecutionComponentStateException {
        if (this.stdout == null) {
            throw new ExecutionComponentStateException(1, "No standard output stream has been set");
        }
        return this.stdout;
    }

    public InputStream getStandardErrorStream() throws ExecutionComponentStateException {
        if (this.stderr == null) {
            throw new ExecutionComponentStateException(1, "No standard error stream has been set");
        }
        return this.stderr;
    }

    private void processExited() {
        if (this.state == 2) {
            ExecutionComponentStateChangeEvent executionComponentStateChangeEvent = new ExecutionComponentStateChangeEvent(this, 4);
            this.fireStateChangeEvent(executionComponentStateChangeEvent);
        }
    }

    public String getPid() {
        return new Integer(this.pid).toString();
    }

    public int getProcessStatus(int n) {
        return this.getProcessStatus0(n);
    }

    public IProcessConsole getProcessConsole() {
        return this;
    }

    public IExecutableObject getCompatibleExecutableObject(String string) throws ClassNotFoundException {
        IExecutableObject iExecutableObject = null;
        Class<?> clazz = Class.forName(string);
        try {
            iExecutableObject = (IExecutableObject)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (iExecutableObject != null && iExecutableObject instanceof ProcessExecutableObjectImpl) {
            return iExecutableObject;
        }
        return null;
    }

    private native int startProcess0();

    private native void killProcess0();

    private native void writeToProcess0(char var1);

    private native int readFromProcessOutput0();

    private native int readFromProcessError0();

    private native int getProcessStatus0(int var1);

    static {
        try {
            System.loadLibrary("hclaunch");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class ConsoleErrorThread
    extends Thread {
        private PipedOutputStream writer;

        public ConsoleErrorThread(String string) {
            this.setName(string);
            this.setDaemon(true);
            ProcessExecutorImpl.this.stderr = new PipedInputStream();
            try {
                this.writer = new PipedOutputStream((PipedInputStream)ProcessExecutorImpl.this.stderr);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void run() {
            int n = 0;
            try {
                while ((n = ProcessExecutorImpl.this.readFromProcessError0()) != -1) {
                    this.writer.write(n);
                    this.writer.flush();
                }
            }
            catch (Exception exception) {
                System.out.println("Console error closed by process");
            }
        }
    }

    class ConsoleOutputThread
    extends Thread {
        private PipedOutputStream writer;

        public ConsoleOutputThread(String string) {
            this.setName(string);
            this.setDaemon(true);
            ProcessExecutorImpl.this.stdout = new PipedInputStream();
            try {
                this.writer = new PipedOutputStream((PipedInputStream)ProcessExecutorImpl.this.stdout);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void run() {
            try {
                int n;
                while ((n = ProcessExecutorImpl.this.readFromProcessOutput0()) != -1) {
                    this.writer.write(n);
                    this.writer.flush();
                }
            }
            catch (IOException iOException) {
                System.out.println("Console output closed by process");
            }
        }
    }

    class ConsoleInputThread
    extends Thread {
        private PipedInputStream reader;
        private StringBuffer strbuf;
        private char c;

        public ConsoleInputThread(String string) {
            this.setName(string);
            this.setDaemon(true);
            ProcessExecutorImpl.this.stdin = new PipedOutputStream();
            try {
                this.reader = new PipedInputStream((PipedOutputStream)ProcessExecutorImpl.this.stdin);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void run() {
            try {
                while (true) {
                    this.c = (char)this.reader.read();
                    ProcessExecutorImpl.this.writeToProcess0(this.c);
                }
            }
            catch (IOException iOException) {
                System.out.println("Console input closed by process");
                return;
            }
        }
    }

    class ProcessStatusThread
    extends Thread {
        int pid;
        int cur_state = 2;
        IExecutor executor;

        public ProcessStatusThread(IExecutor iExecutor, int n) {
            this.setName("Process status monitor");
            this.executor = iExecutor;
            this.setDaemon(true);
            this.pid = n;
        }

        public void run() {
            while (this.cur_state != 4) {
                this.cur_state = ProcessExecutorImpl.this.getProcessStatus(this.pid);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            ProcessExecutorImpl.this.processExited();
        }
    }
}

